/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import javax.lang.model.element.Modifier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.Utils;
import net.openhft.chronicle.values.ValueBuilder;

abstract class HeapMemberGenerator
extends MemberGenerator {
    FieldSpec field;
    private FieldSpec fieldAddress;

    HeapMemberGenerator(FieldModel fieldModel) {
        super(fieldModel);
    }

    abstract String putVolatile();

    abstract String putOrdered();

    abstract String compareAndSwap();

    abstract String arrayBase();

    abstract String arrayScale();

    FieldSpec fieldOffset(ValueBuilder valueBuilder) {
        if (this.fieldAddress == null) {
            this.fieldAddress = FieldSpec.builder(Long.TYPE, (String)(this.fieldModel.name + "Address"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).build();
            valueBuilder.staticBlockBuilder().addStatement("$N = $N.objectFieldOffset($T.getField($N.class, $S))", new Object[]{this.fieldAddress, valueBuilder.unsafe(), Jvm.class, valueBuilder.className, this.field.name});
            valueBuilder.typeBuilder.addField(this.fieldAddress);
        }
        return this.fieldAddress;
    }

    Class fieldType() {
        return this.fieldModel.type;
    }

    abstract String wrap(ValueBuilder var1, MethodSpec.Builder var2, String var3);

    abstract String unwrap(MethodSpec.Builder var1, String var2);

    @Override
    void generateFields(ValueBuilder valueBuilder) {
        this.field = FieldSpec.builder((Type)this.fieldType(), (String)this.fieldModel.fieldName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        valueBuilder.typeBuilder.addField(this.field);
    }

    @Override
    void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
        this.field = FieldSpec.builder((TypeName)ArrayTypeName.of((Type)this.fieldType()), (String)this.fieldModel.fieldName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T[$L]", new Object[]{this.fieldType(), arrayFieldModel.array.length()}).build();
        valueBuilder.typeBuilder.addField(this.field);
    }

    @Override
    public void generateGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String rawValue = "raw" + Utils.capitalize(this.field.name) + "Value";
        methodBuilder.addStatement("$T $N = $N", new Object[]{this.fieldType(), rawValue, this.field});
        methodBuilder.addStatement("return $N", new Object[]{this.wrap(valueBuilder, methodBuilder, rawValue)});
    }

    @Override
    public void generateArrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String rawValue = "raw" + Utils.capitalize(this.field.name) + "Value";
        methodBuilder.addStatement("$T $N = $N[index]", new Object[]{this.fieldType(), rawValue, this.field});
        methodBuilder.addStatement("return $N", new Object[]{this.wrap(valueBuilder, methodBuilder, rawValue)});
    }

    @Override
    public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("this.$N = $N", new Object[]{this.field, this.unwrap(methodBuilder, this.fieldModel.varName())});
    }

    @Override
    public void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("this.$N[index] = $N", new Object[]{this.field, this.unwrap(methodBuilder, this.fieldModel.varName())});
    }

    @Override
    public void generateSetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("$N.$N(this, $N, $N)", new Object[]{valueBuilder.unsafe(), this.putVolatile(), this.fieldOffset(valueBuilder), this.unwrap(methodBuilder, this.fieldModel.varName())});
    }

    @Override
    public void generateArrayElementSetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        Class type = Utils.UNSAFE_CLASS;
        methodBuilder.addStatement(String.format("$N.$N($N, (long) $T.$N + (index * (long) $T.$N), %s)", this.unwrap(methodBuilder, this.fieldModel.varName())), new Object[]{valueBuilder.unsafe(), this.putVolatile(), this.field, type, this.arrayBase(), type, this.arrayScale()});
    }

    @Override
    public void generateSetOrdered(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("$N.$N(this, $N, $N)", new Object[]{valueBuilder.unsafe(), this.putOrdered(), this.fieldOffset(valueBuilder), this.unwrap(methodBuilder, this.fieldModel.varName())});
    }

    @Override
    public void generateArrayElementSetOrdered(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        Class type = Utils.UNSAFE_CLASS;
        methodBuilder.addStatement(String.format("$N.$N($N, (long) $T.$N + (index * (long) $T.$N), %s)", this.unwrap(methodBuilder, this.fieldModel.varName())), new Object[]{valueBuilder.unsafe(), this.putOrdered(), this.field, type, this.arrayBase(), type, this.arrayScale()});
    }

    @Override
    public void generateCompareAndSwap(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String unwrappedOld = this.unwrap(methodBuilder, this.fieldModel.oldName());
        String unwrappedNew = this.unwrap(methodBuilder, this.fieldModel.newName());
        methodBuilder.addStatement("return $N.$N(this, $N, $N, $N)", new Object[]{valueBuilder.unsafe(), this.compareAndSwap(), this.fieldOffset(valueBuilder), unwrappedOld, unwrappedNew});
    }

    @Override
    public void generateArrayElementCompareAndSwap(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        String unwrappedOld = this.unwrap(methodBuilder, this.fieldModel.oldName());
        String unwrappedNew = this.unwrap(methodBuilder, this.fieldModel.newName());
        Class type = Utils.UNSAFE_CLASS;
        methodBuilder.addStatement("return $N.$N($N, (long) $T.$N + (index * (long) $T.$N), $N, $N)", new Object[]{valueBuilder.unsafe(), this.compareAndSwap(), this.field, type, this.arrayBase(), type, this.arrayScale(), unwrappedOld, unwrappedNew});
    }

    @Override
    public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String copy = this.fieldModel.name + "Copy";
        methodBuilder.addStatement("$T $N = from.$N()", new Object[]{this.fieldModel.type, copy, this.fieldModel.getOrGetVolatile().getName()});
        methodBuilder.addStatement("this.$N = $N", new Object[]{this.field, this.unwrap(methodBuilder, copy)});
    }

    @Override
    public void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String copy = arrayFieldModel.name + "Copy";
        methodBuilder.addStatement("$T $N = from.$N(index)", new Object[]{arrayFieldModel.type, copy, arrayFieldModel.getOrGetVolatile().getName()});
        methodBuilder.addStatement("this.$N[index] = $N", new Object[]{this.field, this.unwrap(methodBuilder, copy)});
    }

    @Override
    void generateToString(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String rawValue = "raw" + Utils.capitalize(this.field.name) + "Value";
        methodBuilder.addStatement("$T $N = $N", new Object[]{this.fieldType(), rawValue, this.field});
        this.genToString(methodBuilder, this.wrap(valueBuilder, methodBuilder, rawValue));
    }

    @Override
    void generateArrayElementToString(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String rawValue = "raw" + Utils.capitalize(this.field.name) + "Value";
        methodBuilder.addStatement("$T $N = $N[index]", new Object[]{this.fieldType(), rawValue, this.field});
        this.genArrayElementToString(methodBuilder, this.wrap(valueBuilder, methodBuilder, rawValue));
    }
}

