/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.CharSequences;
import net.openhft.chronicle.values.Copyable;
import net.openhft.chronicle.values.Enums;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.SimpleURIClassObject;
import net.openhft.chronicle.values.ValueModel;
import net.openhft.chronicle.values.Values;
import org.jetbrains.annotations.NotNull;

class MyJavaFileManager
implements JavaFileManager {
    private static final Map.Entry<Package, List<JavaFileObject>> valuesPackageFileObjects = MyJavaFileManager.classesToFileObjects(Arrays.asList(Enums.class, CharSequences.class, ValueModel.class, Values.class, FieldModel.class, ArrayFieldModel.class, Copyable.class));
    private static final Map.Entry<Package, List<JavaFileObject>> bytesPackageFileObjects = MyJavaFileManager.classesToFileObjects(Arrays.asList(Bytes.class, BytesStore.class, BytesUtil.class, Byteable.class, BytesMarshallable.class));
    private static final Map.Entry<Package, List<JavaFileObject>> corePackageFileObjects = MyJavaFileManager.classesToFileObjects(Collections.singletonList(ReferenceCounted.class));
    private static final Map.Entry<Package, List<JavaFileObject>> coreIoPackageFileObjects = MyJavaFileManager.classesToFileObjects(Arrays.asList(Closeable.class, IORuntimeException.class));
    private final Map<Package, List<JavaFileObject>> packages = new HashMap<Package, List<JavaFileObject>>();
    private final StandardJavaFileManager fileManager;
    private final Map<String, ByteArrayOutputStream> buffers = new LinkedHashMap<String, ByteArrayOutputStream>();

    private static Stream<JavaFileObject> classFileObjects(Class<?> c) {
        ArrayList<JavaFileObject> fileObjects = new ArrayList<JavaFileObject>();
        MyJavaFileManager.addFileObjects(fileObjects, c);
        return fileObjects.stream();
    }

    private static void addFileObjects(List<JavaFileObject> fileObjects, Class<?> c) {
        Type[] interfaces;
        fileObjects.add(MyJavaFileManager.classFileObject(c));
        for (Type superInterface : interfaces = c.getGenericInterfaces()) {
            Class rawInterface = ValueModel.rawInterface(superInterface);
            if (!rawInterface.getPackage().equals(c.getPackage())) continue;
            MyJavaFileManager.addFileObjects(fileObjects, rawInterface);
        }
    }

    private static JavaFileObject classFileObject(Class<?> c) {
        try {
            String className = c.getName();
            int lastDotIndex = className.lastIndexOf(46);
            URI uri = c.getResource(className.substring(lastDotIndex + 1) + ".class").toURI();
            return new SimpleURIClassObject(uri, c);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map.Entry<Package, List<JavaFileObject>> classesToFileObjects(List<Class<?>> classes) {
        List fileObjects = classes.stream().flatMap(MyJavaFileManager::classFileObjects).distinct().collect(Collectors.toList());
        return new AbstractMap.SimpleEntry<Package, List<JavaFileObject>>(classes.get(0).getPackage(), fileObjects);
    }

    private static void addToPackages(Map<Package, List<JavaFileObject>> packages, Map.Entry<Package, List<JavaFileObject>> fileObjects) {
        packages.put(fileObjects.getKey(), fileObjects.getValue());
    }

    MyJavaFileManager(Class valueType, StandardJavaFileManager fileManager) {
        Map.Entry<Package, List<JavaFileObject>> valueTypePackageFileObjects = MyJavaFileManager.classesToFileObjects(Collections.singletonList(valueType));
        MyJavaFileManager.addToPackages(this.packages, coreIoPackageFileObjects);
        MyJavaFileManager.addToPackages(this.packages, corePackageFileObjects);
        MyJavaFileManager.addToPackages(this.packages, bytesPackageFileObjects);
        MyJavaFileManager.addToPackages(this.packages, valuesPackageFileObjects);
        MyJavaFileManager.addToPackages(this.packages, valueTypePackageFileObjects);
        this.fileManager = fileManager;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.fileManager.getClassLoader(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        ArrayList<JavaFileObject> fileObjects = new ArrayList<JavaFileObject>();
        for (Map.Entry<Package, List<JavaFileObject>> packageFileObjects : this.packages.entrySet()) {
            if (!packageName.equals(packageFileObjects.getKey().getName())) continue;
            fileObjects.addAll((Collection<JavaFileObject>)packageFileObjects.getValue());
            break;
        }
        this.fileManager.list(location, packageName, kinds, recurse).forEach(fileObjects::add);
        return fileObjects;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof SimpleURIClassObject) {
            return ((SimpleURIClassObject)file).c.getName();
        }
        return this.fileManager.inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.fileManager.isSameFile(a, b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.fileManager.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.fileManager.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (location == StandardLocation.CLASS_OUTPUT && this.buffers.containsKey(className) && kind == JavaFileObject.Kind.CLASS) {
            final byte[] bytes = this.buffers.get(className).toByteArray();
            return new SimpleJavaFileObject(URI.create(className), kind){

                @Override
                @NotNull
                public InputStream openInputStream() {
                    return new ByteArrayInputStream(bytes);
                }
            };
        }
        return this.fileManager.getJavaFileForInput(location, className, kind);
    }

    @Override
    @NotNull
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return new SimpleJavaFileObject(URI.create(className), kind){

            @Override
            @NotNull
            public OutputStream openOutputStream() {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                MyJavaFileManager.this.buffers.put(className, baos);
                return baos;
            }
        };
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.fileManager.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.fileManager.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.fileManager.close();
    }

    @Override
    public int isSupportedOption(String option) {
        return this.fileManager.isSupportedOption(option);
    }

    @NotNull
    public Map<String, byte[]> getAllBuffers() {
        LinkedHashMap<String, byte[]> ret = new LinkedHashMap<String, byte[]>(this.buffers.size() * 2);
        for (Map.Entry<String, ByteArrayOutputStream> entry : this.buffers.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().toByteArray());
        }
        return ret;
    }
}

