/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.values.Copyable;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.MethodTemplate;
import net.openhft.chronicle.values.ValueModel;

enum CodeTemplate {

    public static final Function<Method, Parameter> NO_ANNOTATED_PARAM = m -> null;
    static final List<Class<?>> NON_MODEL_TYPES = Arrays.asList(Object.class, Serializable.class, Externalizable.class, BytesMarshallable.class, Copyable.class, Byteable.class);
    private static final SortedSet<MethodTemplate> METHOD_TEMPLATES = new TreeSet<MethodTemplate>(Comparator.comparing(t -> t.parameters).thenComparing(k -> -k.regex.length()).thenComparing(k -> k.regex));
    private static final String FIELD_NAME = "([a-zA-Z$][a-zA-Z\\d_$]*)";

    private static void addReadPatterns(String regex, int arguments, BiConsumer<FieldModel, Method> addMethodToModel) {
        regex = regex + FIELD_NAME;
        CodeTemplate.add(regex, arguments, MethodTemplate.Type.SCALAR, Method::getReturnType, NO_ANNOTATED_PARAM, addMethodToModel);
        CodeTemplate.add(regex + "At", arguments + 1, MethodTemplate.Type.ARRAY, Method::getReturnType, NO_ANNOTATED_PARAM, addMethodToModel);
    }

    public static void addWritePattern(String regex, int arguments, BiConsumer<FieldModel, Method> addMethodToModel) {
        regex = regex + FIELD_NAME;
        CodeTemplate.add(regex, arguments, MethodTemplate.Type.SCALAR, m -> m.getParameterTypes()[arguments - 1], m -> m.getParameters()[arguments - 1], addMethodToModel);
        CodeTemplate.add(regex + "At", arguments + 1, MethodTemplate.Type.ARRAY, m -> m.getParameterTypes()[arguments], m -> m.getParameters()[arguments], addMethodToModel);
    }

    private static void add(String regex, int parameters, MethodTemplate.Type type, Function<Method, Class> fieldType, Function<Method, Parameter> annotatedParameter, BiConsumer<FieldModel, Method> addMethodToModel) {
        METHOD_TEMPLATES.add(new MethodTemplate(regex, parameters, type, fieldType, annotatedParameter, addMethodToModel));
    }

    static ValueModel createValueModel(Class<?> valueType) {
        LinkedHashMap fieldModelMap = new LinkedHashMap();
        CodeTemplate.forEachAbstractMethod(valueType, m -> {
            MethodTemplate methodTemplate = METHOD_TEMPLATES.stream().filter(t -> t.parameters == m.getParameterCount()).filter(t -> m.getName().matches(t.regex)).findFirst().orElseThrow(IllegalStateException::new);
            Matcher matcher = Pattern.compile(methodTemplate.regex).matcher(m.getName());
            if (!matcher.find()) {
                throw new AssertionError();
            }
            String fieldName = CodeTemplate.convertFieldName(matcher.group(1));
            FieldModel fieldModel = fieldModelMap.computeIfAbsent(fieldName, n -> {
                FieldModel model = methodTemplate.createModel((Method)m, (String)n);
                model.name = fieldName;
                return model;
            });
            methodTemplate.addMethodToModel.accept(fieldModel, (Method)m);
            fieldModel.addInfo((Method)m, methodTemplate);
        });
        List<FieldModel> fields = fieldModelMap.values().stream().collect(Collectors.toList());
        fields.forEach(FieldModel::postProcess);
        fields.forEach(FieldModel::checkState);
        return new ValueModel(valueType, fields.stream());
    }

    private static void forEachAbstractMethod(Class<?> c, Consumer<Method> action) {
        Stream.of(c.getMethods()).filter(m -> (m.getModifiers() & 0x400) != 0).filter(m -> NON_MODEL_TYPES.stream().noneMatch(t -> CodeTemplate.hasMethod(t, m))).sorted(Comparator.comparing(m -> m.getName().length())).forEach(action);
    }

    private static boolean hasMethod(Class<?> type, Method m) {
        return Stream.of(type.getMethods()).anyMatch(m2 -> m2.getName().equals(m.getName()) && Arrays.equals(m2.getParameterTypes(), m.getParameterTypes()));
    }

    static String convertFieldName(String name) {
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static {
        CodeTemplate.addReadPatterns("get", 0, FieldModel::setGet);
        CodeTemplate.addReadPatterns("", 0, FieldModel::setGet);
        CodeTemplate.addReadPatterns("is", 0, FieldModel::setGet);
        CodeTemplate.addReadPatterns("getVolatile", 0, FieldModel::setGetVolatile);
        CodeTemplate.addReadPatterns("getUsing", 1, FieldModel::setGetUsing);
        CodeTemplate.addWritePattern("set", 1, FieldModel::setSet);
        CodeTemplate.addWritePattern("", 1, FieldModel::setSet);
        CodeTemplate.addWritePattern("setVolatile", 1, FieldModel::setSetVolatile);
        CodeTemplate.addWritePattern("setOrdered", 1, FieldModel::setSetOrdered);
        CodeTemplate.addWritePattern("add", 1, FieldModel::setAdd);
        CodeTemplate.addWritePattern("addAtomic", 1, FieldModel::setAddAtomic);
        CodeTemplate.addWritePattern("compareAndSwap", 2, FieldModel::setCompareAndSwap);
    }
}

