/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.lang.model.element.Modifier;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.CharSequences;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.FieldNullability;
import net.openhft.chronicle.values.MaxUtf8Length;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.MethodTemplate;
import net.openhft.chronicle.values.Nullability;
import net.openhft.chronicle.values.ObjectHeapMemberGenerator;
import net.openhft.chronicle.values.ScalarFieldModel;
import net.openhft.chronicle.values.ValueBuilder;

class CharSequenceFieldModel
extends ScalarFieldModel {
    final FieldNullability nullability = new FieldNullability(this);
    MaxUtf8Length maxUtf8Length;
    private final MemberGenerator nativeGenerator = new MemberGenerator(this){

        @Override
        public void generateFields(ValueBuilder valueBuilder) {
            CharSequenceFieldModel.this.addCachedStringBuilder(valueBuilder);
        }

        @Override
        public void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
            this.generateFields(valueBuilder);
        }

        @Override
        public void generateGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedStringBuilder(valueBuilder, methodBuilder);
            this.finishGet(methodBuilder, CharSequenceFieldModel.this.get);
        }

        private void initCachedStringBuilder(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int byteOffset = CharSequenceFieldModel.this.verifiedByteOffset(valueBuilder);
            methodBuilder.beginControlFlow("if (bs.readUtf8Limited(offset + $L, $N, $L) > 0)", new Object[]{byteOffset, CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.maxUtf8Length.value()});
        }

        @Override
        public void generateArrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            this.initArrayElementCachedStringBuilder(arrayFieldModel, valueBuilder, methodBuilder);
            this.finishGet(methodBuilder, arrayFieldModel.get);
        }

        private void initArrayElementCachedStringBuilder(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            methodBuilder.beginControlFlow("if (bs.readUtf8Limited(offset + $L + elementOffset, $N, $L) > 0)", new Object[]{arrayByteOffset, CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.maxUtf8Length.value()});
        }

        private void finishGet(MethodSpec.Builder methodBuilder, Method get) {
            if (CharSequenceFieldModel.this.type == String.class) {
                methodBuilder.addStatement("return $N.toString()", new Object[]{CharSequenceFieldModel.this.cachedStringBuilder()});
            } else {
                if (CharSequenceFieldModel.this.type != StringBuilder.class && CharSequenceFieldModel.this.type != CharSequence.class) {
                    throw new IllegalStateException("Only StringBuilder, String and CharSequence classes are supported, " + CharSequenceFieldModel.this.name + " field type is " + CharSequenceFieldModel.this.type);
                }
                methodBuilder.addStatement("return $N", new Object[]{CharSequenceFieldModel.this.cachedStringBuilder()});
            }
            CharSequenceFieldModel.this.nullGetBranch(methodBuilder, get);
        }

        @Override
        public void generateGetUsing(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int byteOffset = CharSequenceFieldModel.this.verifiedByteOffset(valueBuilder);
            methodBuilder.beginControlFlow("if (bs.readUtf8Limited(offset + $L, $N, $L) > 0)", new Object[]{byteOffset, CharSequenceFieldModel.this.usingName(), CharSequenceFieldModel.this.maxUtf8Length.value()});
            this.finishGetUsing(methodBuilder, CharSequenceFieldModel.this.getUsing);
        }

        @Override
        public void generateArrayElementGetUsing(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            methodBuilder.beginControlFlow("if (bs.readUtf8Limited(offset + $L + elementOffset, $N, $L) > 0)", new Object[]{arrayByteOffset, CharSequenceFieldModel.this.usingName(), CharSequenceFieldModel.this.maxUtf8Length.value()});
            this.finishGetUsing(methodBuilder, arrayFieldModel.getUsing);
        }

        private void finishGetUsing(MethodSpec.Builder methodBuilder, Method get) {
            CharSequenceFieldModel.this.returnNotNullGetUsing(methodBuilder);
            CharSequenceFieldModel.this.nullGetBranch(methodBuilder, get);
        }

        @Override
        public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (!CharSequenceFieldModel.this.nullable()) {
                CharSequenceFieldModel.this.checkArgumentNotNull(methodBuilder);
            }
            this.genSet(valueBuilder, methodBuilder, CharSequenceFieldModel.this.varName());
        }

        private void genSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, Object toSet) {
            int byteOffset = CharSequenceFieldModel.this.verifiedByteOffset(valueBuilder);
            String endName = "__end" + CharSequenceFieldModel.this.name;
            methodBuilder.addStatement("long $N = bs.writeUtf8Limited(offset + $L, $N, $L)", new Object[]{endName, byteOffset, toSet, CharSequenceFieldModel.this.maxUtf8Length.value()});
            methodBuilder.addStatement("bs.zeroOut($N, offset + $L)", new Object[]{endName, byteOffset + CharSequenceFieldModel.this.sizeInBytes()});
        }

        @Override
        public void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (!CharSequenceFieldModel.this.nullable()) {
                CharSequenceFieldModel.this.checkArgumentNotNull(methodBuilder);
            }
            arrayFieldModel.checkBounds(methodBuilder);
            this.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, CharSequenceFieldModel.this.varName());
        }

        private void genArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, Object toSet) {
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            String endName = "__end" + CharSequenceFieldModel.this.name;
            methodBuilder.addStatement("long $N = bs.writeUtf8Limited(offset + $L + elementOffset, $N, $L)", new Object[]{endName, arrayByteOffset, toSet, CharSequenceFieldModel.this.maxUtf8Length.value()});
            methodBuilder.addStatement("bs.zeroOut($N, offset + $L + elementOffset + $L)", new Object[]{endName, arrayByteOffset, CharSequenceFieldModel.this.sizeInBytes()});
        }

        @Override
        public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("from.$N($N)", new Object[]{CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                    this.genSet(valueBuilder, methodBuilder, CharSequenceFieldModel.this.cachedStringBuilder());
                } else {
                    String getUsingResult = String.format("from.%s(%s)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    this.genSet(valueBuilder, methodBuilder, getUsingResult);
                }
            } else {
                this.genSet(valueBuilder, methodBuilder, String.format("from.%s()", CharSequenceFieldModel.this.get.getName()));
            }
        }

        @Override
        public void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            Method getUsing = arrayFieldModel.getUsing;
            if (getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("from.$N(index, $N)", new Object[]{getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                    this.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, CharSequenceFieldModel.this.cachedStringBuilder());
                } else {
                    String getUsingResult = String.format("from.%s(index, %s)", getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    this.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, getUsingResult);
                }
            } else {
                this.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, String.format("from.%s(index)", arrayFieldModel.get.getName()));
            }
        }

        @Override
        void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedStringBuilder(valueBuilder, methodBuilder);
            this.finishWriteMarshallable(methodBuilder);
        }

        @Override
        void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedStringBuilder(arrayFieldModel, valueBuilder, methodBuilder);
            this.finishWriteMarshallable(methodBuilder);
        }

        private void finishWriteMarshallable(MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("bytes.writeUtf8($N)", new Object[]{CharSequenceFieldModel.this.cachedStringBuilder()});
            methodBuilder.nextControlFlow("else", new Object[0]);
            methodBuilder.addStatement("bytes.writeUtf8(null)", new Object[0]);
            methodBuilder.endControlFlow();
        }

        @Override
        void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$N(bytes.readUtf8($N) ? $N : null)", new Object[]{CharSequenceFieldModel.this.set.getName(), CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.cachedBuilderToSettable(CharSequenceFieldModel.this.set)});
        }

        @Override
        void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$N(index, bytes.readUtf8($N) ? $N : null)", new Object[]{arrayFieldModel.set.getName(), CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.cachedBuilderToSettable(arrayFieldModel.set)});
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int byteOffset = CharSequenceFieldModel.this.verifiedByteOffset(valueBuilder);
            if (CharSequenceFieldModel.this.getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("other.$N($N)", new Object[]{CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                    methodBuilder.addCode("if ($N.length() > $L) return false;\n", new Object[]{CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.maxUtf8Length.value()});
                    methodBuilder.addCode("if (!bs.compareUtf8(offset + $L, $N)) return false;\n", new Object[]{byteOffset, CharSequenceFieldModel.this.cachedStringBuilder()});
                } else {
                    String localName = "__other" + CharSequenceFieldModel.this.name;
                    methodBuilder.addStatement("$T $N = other.$N($N)", new Object[]{CharSequence.class, localName, CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                    methodBuilder.addCode("if ($N != null && $N.length() > $L) return false;\n", new Object[]{localName, localName, CharSequenceFieldModel.this.maxUtf8Length.value()});
                    methodBuilder.addCode("if (!bs.compareUtf8(offset + $L, $N)) return false;\n", new Object[]{byteOffset, localName});
                }
            } else {
                String localName = "__other" + CharSequenceFieldModel.this.name;
                methodBuilder.addStatement("$T $N = other.$N()", new Object[]{CharSequence.class, localName, CharSequenceFieldModel.this.get.getName()});
                methodBuilder.addCode("if ($N != null && $N.length() > $L) return false;\n", new Object[]{localName, localName, CharSequenceFieldModel.this.maxUtf8Length.value()});
                methodBuilder.addCode("if (!bs.compareUtf8(offset + $L, $N)) return false;\n", new Object[]{byteOffset, localName});
            }
        }

        @Override
        void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            int arrayByteOffset = arrayFieldModel.verifiedByteOffset(valueBuilder);
            FieldModel.genVerifiedElementOffset(arrayFieldModel, methodBuilder);
            Method getUsing = arrayFieldModel.getUsing;
            if (getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("other.$N(index, $N)", new Object[]{getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                    methodBuilder.addCode("if ($N.length() > $L) return false;\n", new Object[]{CharSequenceFieldModel.this.cachedStringBuilder(), CharSequenceFieldModel.this.maxUtf8Length.value()});
                    methodBuilder.addCode("if (!bs.compareUtf8(offset + $L + elementOffset, $N)) return false;\n", new Object[]{arrayByteOffset, CharSequenceFieldModel.this.cachedStringBuilder()});
                } else {
                    String localName = "__other" + CharSequenceFieldModel.this.name;
                    methodBuilder.addStatement("$T $N = other.$N(index, $N)", new Object[]{CharSequence.class, localName, getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                    methodBuilder.addCode("if ($N != null && $N.length() > $L) return false;\n", new Object[]{localName, localName, CharSequenceFieldModel.this.maxUtf8Length.value()});
                    methodBuilder.addCode("if (!bs.compareUtf8(offset + $L + elementOffset, $N)) return false;\n", new Object[]{arrayByteOffset, localName});
                }
            } else {
                String localName = "__other" + CharSequenceFieldModel.this.name;
                methodBuilder.addStatement("$T $N = other.$N(index)", new Object[]{CharSequence.class, localName, arrayFieldModel.get.getName()});
                methodBuilder.addCode("if ($N != null && $N.length() > $L) return false;\n", new Object[]{localName, localName, CharSequenceFieldModel.this.maxUtf8Length.value()});
                methodBuilder.addCode("if (!bs.compareUtf8(offset + $L + elementOffset, $N)) return false;\n", new Object[]{arrayByteOffset, localName});
            }
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String hashCodeCharSequenceName = "__hashCode" + CharSequenceFieldModel.this.name;
            methodBuilder.addStatement("$T $N = null", new Object[]{CharSequence.class, hashCodeCharSequenceName});
            this.initCachedStringBuilder(valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N = $N", new Object[]{hashCodeCharSequenceName, CharSequenceFieldModel.this.cachedStringBuilder()});
            methodBuilder.endControlFlow();
            return "net.openhft.chronicle.values.CharSequences.hashCode(" + hashCodeCharSequenceName + ")";
        }

        @Override
        String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String hashCodeCharSequenceName = "__hashCode" + CharSequenceFieldModel.this.name;
            methodBuilder.addStatement("$T $N = null", new Object[]{CharSequence.class, hashCodeCharSequenceName});
            this.initArrayElementCachedStringBuilder(arrayFieldModel, valueBuilder, methodBuilder);
            methodBuilder.addStatement("$N = $N", new Object[]{hashCodeCharSequenceName, CharSequenceFieldModel.this.cachedStringBuilder()});
            methodBuilder.endControlFlow();
            return "net.openhft.chronicle.values.CharSequences.hashCode(" + hashCodeCharSequenceName + ")";
        }

        @Override
        void generateToString(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initCachedStringBuilder(valueBuilder, methodBuilder);
            this.genToString(methodBuilder, CharSequenceFieldModel.this.cachedStringBuilder());
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.genToString(methodBuilder, "(String) null");
            methodBuilder.endControlFlow();
        }

        @Override
        void generateArrayElementToString(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.initArrayElementCachedStringBuilder(arrayFieldModel, valueBuilder, methodBuilder);
            this.genArrayElementToString(methodBuilder, CharSequenceFieldModel.this.cachedStringBuilder());
            methodBuilder.nextControlFlow("else", new Object[0]);
            this.genArrayElementToString(methodBuilder, "(String) null");
            methodBuilder.endControlFlow();
        }
    };
    private final MemberGenerator heapGenerator = new ObjectHeapMemberGenerator(this){

        @Override
        void generateFields(ValueBuilder valueBuilder) {
            super.generateFields(valueBuilder);
            CharSequenceFieldModel.this.addCachedStringBuilder(valueBuilder);
        }

        @Override
        void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
            super.generateArrayElementFields(arrayFieldModel, valueBuilder);
            CharSequenceFieldModel.this.addCachedStringBuilder(valueBuilder);
        }

        @Override
        public void generateGetUsing(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$N.setLength(0)", new Object[]{CharSequenceFieldModel.this.usingName()});
            methodBuilder.beginControlFlow("if ($N != null)", new Object[]{this.field});
            methodBuilder.addStatement("$N.append($N)", new Object[]{CharSequenceFieldModel.this.usingName(), this.field});
            CharSequenceFieldModel.this.returnNotNullGetUsing(methodBuilder);
            CharSequenceFieldModel.this.nullGetBranch(methodBuilder, CharSequenceFieldModel.this.getUsing);
        }

        @Override
        public void generateArrayElementGetUsing(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$N.setLength(0)", new Object[]{CharSequenceFieldModel.this.usingName()});
            methodBuilder.beginControlFlow("if ($N[index] != null)", new Object[]{this.field});
            methodBuilder.addStatement("$N.append($N[index])", new Object[]{CharSequenceFieldModel.this.usingName(), this.field});
            CharSequenceFieldModel.this.returnNotNullGetUsing(methodBuilder);
            CharSequenceFieldModel.this.nullGetBranch(methodBuilder, arrayFieldModel.getUsing);
        }

        @Override
        public void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("from.$N($N)", new Object[]{CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                    methodBuilder.addStatement("$N = $N", new Object[]{CharSequenceFieldModel.this.fieldName(), CharSequenceFieldModel.this.cachedBuilderToSettable(CharSequenceFieldModel.this.set)});
                } else {
                    String getUsingResult = String.format("from.%s(%s)", CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    methodBuilder.addStatement("$T $N = $N", new Object[]{CharSequence.class, CharSequenceFieldModel.this.varName(), getUsingResult});
                    if (CharSequenceFieldModel.this.type == StringBuilder.class) {
                        methodBuilder.addStatement("$N = $N != null ? new $T($N) : null", new Object[]{CharSequenceFieldModel.this.fieldName(), CharSequenceFieldModel.this.varName(), StringBuilder.class, CharSequenceFieldModel.this.varName()});
                    } else {
                        methodBuilder.addStatement("$N = $N != null ? $N.toString() : null", new Object[]{CharSequenceFieldModel.this.fieldName(), CharSequenceFieldModel.this.varName(), CharSequenceFieldModel.this.varName()});
                    }
                }
            } else {
                methodBuilder.addStatement("$N = from.$N()", new Object[]{CharSequenceFieldModel.this.fieldName(), CharSequenceFieldModel.this.get.getName()});
            }
        }

        @Override
        public void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            Method getUsing = arrayFieldModel.getUsing;
            if (getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("from.$N(index, $N)", new Object[]{getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                    methodBuilder.addStatement("$N[index] = $N", new Object[]{CharSequenceFieldModel.this.fieldName(), CharSequenceFieldModel.this.cachedBuilderToSettable(arrayFieldModel.set)});
                } else {
                    String getUsingResult = String.format("from.%s(index, %s)", getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder());
                    methodBuilder.addStatement("$T $N = $N", new Object[]{CharSequence.class, CharSequenceFieldModel.this.varName(), getUsingResult});
                    if (CharSequenceFieldModel.this.type == StringBuilder.class) {
                        methodBuilder.addStatement("$N[index] = $N != null ? new $T($N) : null", new Object[]{CharSequenceFieldModel.this.fieldName(), CharSequenceFieldModel.this.varName(), StringBuilder.class, CharSequenceFieldModel.this.varName()});
                    } else {
                        methodBuilder.addStatement("$N[index] = $N != null ? $N.toString() : null", new Object[]{CharSequenceFieldModel.this.fieldName(), CharSequenceFieldModel.this.varName(), CharSequenceFieldModel.this.varName()});
                    }
                }
            } else {
                methodBuilder.addStatement("$N[index] = from.$N(index)", new Object[]{CharSequenceFieldModel.this.fieldName(), arrayFieldModel.get.getName()});
            }
        }

        @Override
        void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("bytes.writeUtf8($N)", new Object[]{CharSequenceFieldModel.this.fieldName()});
        }

        @Override
        void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("bytes.writeUtf8($N[index])", new Object[]{CharSequenceFieldModel.this.fieldName()});
        }

        @Override
        void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$N = $N", new Object[]{CharSequenceFieldModel.this.fieldName(), this.stringToSettable("bytes.readUtf8()")});
        }

        @Override
        void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("$N[index] = $N", new Object[]{CharSequenceFieldModel.this.fieldName(), this.stringToSettable("bytes.readUtf8()")});
        }

        private String stringToSettable(String s) {
            return CharSequenceFieldModel.this.type == StringBuilder.class ? String.format("new StringBuilder(%s)", s) : s;
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            if (CharSequenceFieldModel.this.getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("other.$N($N)", new Object[]{CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                    methodBuilder.addCode("if (!$T.equals($N, $N)) return false;\n", new Object[]{CharSequences.class, this.field, CharSequenceFieldModel.this.cachedStringBuilder()});
                } else {
                    methodBuilder.addCode("if (!$T.equals($N, other.$N($N))) return false;\n", new Object[]{CharSequences.class, this.field, CharSequenceFieldModel.this.getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                }
            } else {
                methodBuilder.addCode("if (!$T.equals($N, other.$N())) return false;\n", new Object[]{CharSequences.class, this.field, CharSequenceFieldModel.this.get.getName()});
            }
        }

        @Override
        void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            Method getUsing = arrayFieldModel.getUsing;
            if (getUsing != null) {
                if (!CharSequenceFieldModel.this.nullable()) {
                    methodBuilder.addStatement("other.$N(index, $N)", new Object[]{getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                    methodBuilder.addCode("if (!$T.equals($N[index], $N)) return false;\n", new Object[]{CharSequences.class, this.field, CharSequenceFieldModel.this.cachedStringBuilder()});
                } else {
                    methodBuilder.addCode("if (!$T.equals($N[index], other.$N(index, $N))) return false;\n", new Object[]{CharSequences.class, this.field, getUsing.getName(), CharSequenceFieldModel.this.cachedStringBuilder()});
                }
            } else {
                methodBuilder.addCode("if (!$T.equals($N[index], other.$N(index))) return false;\n", new Object[]{CharSequences.class, this.field, arrayFieldModel.get.getName()});
            }
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            return "net.openhft.chronicle.values.CharSequences.hashCode(" + this.field.name + ")";
        }

        @Override
        String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            return "net.openhft.chronicle.values.CharSequences.hashCode(" + this.field.name + "[index])";
        }
    };

    CharSequenceFieldModel() {
    }

    @Override
    void addTypeInfo(Method m, MethodTemplate template) {
        if (!template.regex.startsWith("getUsing")) {
            super.addTypeInfo(m, template);
        }
        this.nullability.addInfo(m, template);
        Parameter annotatedParameter = template.annotatedParameter.apply(m);
        if (annotatedParameter == null) {
            return;
        }
        MaxUtf8Length paramMaxUtf8Length = annotatedParameter.getAnnotation(MaxUtf8Length.class);
        if (paramMaxUtf8Length != null) {
            if (this.maxUtf8Length != null) {
                throw new IllegalStateException("@MaxUtf8Length should be specified only once for " + this.name + " field. " + "Specified " + this.maxUtf8Length + " and " + paramMaxUtf8Length);
            }
            if (paramMaxUtf8Length.value() <= 0) {
                throw new IllegalStateException(paramMaxUtf8Length + " max size should be positive");
            }
            this.maxUtf8Length = paramMaxUtf8Length;
        }
    }

    @Override
    int sizeInBits() {
        if (this.maxUtf8Length == null) {
            throw new IllegalStateException("@MaxUtf8Length must be specified for a field " + this.name);
        }
        int sizeInBytes = BytesUtil.stopBitLength((long)this.maxUtf8Length.value()) + this.maxUtf8Length.value();
        return sizeInBytes * 8;
    }

    @Override
    int offsetAlignmentInBytes() {
        if (this.offsetAlignment == -1) {
            throw new IllegalStateException("Default offset alignment doesn't make sense for CharSequence field " + this.name);
        }
        return Math.max(this.offsetAlignment, 1);
    }

    private String cachedStringBuilder() {
        return this.varName() + "Builder";
    }

    private String cachedBuilderToSettable(Method set) {
        if (set.getReturnType() == StringBuilder.class) {
            return String.format("new StringBuilder(%s)", this.cachedStringBuilder());
        }
        return this.cachedStringBuilder() + ".toString()";
    }

    private void addCachedStringBuilder(ValueBuilder valueBuilder) {
        FieldSpec cachedStringBuilder = FieldSpec.builder(StringBuilder.class, (String)this.cachedStringBuilder(), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{StringBuilder.class}).build();
        valueBuilder.typeBuilder.addField(cachedStringBuilder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nullGetBranch(MethodSpec.Builder methodBuilder, Method get) {
        methodBuilder.nextControlFlow("else", new Object[0]);
        if (this.nullable()) {
            if (get.getReturnType() == Void.TYPE) throw new IllegalStateException(this.name + " field nullable " + get.getName() + "() shouldn't return void, because null value is " + "indistinguishable from empty string. Specify the parameter in " + this.set.getName() + " method as @NotNull/@Nonnull");
            methodBuilder.addStatement("return null", new Object[0]);
        } else {
            methodBuilder.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, this.name + " shouldn't be null"});
        }
        methodBuilder.endControlFlow();
    }

    private boolean nullable() {
        return this.nullability.nullability() == Nullability.NULLABLE;
    }

    private void returnNotNullGetUsing(MethodSpec.Builder methodBuilder) {
        if (this.getUsing.getReturnType() == String.class) {
            methodBuilder.addStatement("return $N.toString()", new Object[]{this.usingName()});
        } else if (this.getUsing.getReturnType() != Void.TYPE) {
            methodBuilder.addStatement("return $N", new Object[]{this.usingName()});
        }
    }

    @Override
    MemberGenerator nativeGenerator() {
        return this.nativeGenerator;
    }

    @Override
    MemberGenerator heapGenerator() {
        return this.heapGenerator;
    }
}

