/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.openhft.chronicle.core.ClassLoading;
import net.openhft.chronicle.values.ByteCodeModel;
import net.openhft.chronicle.values.CodeTemplate;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.JavaCodeModel;
import net.openhft.chronicle.values.MethodKey;
import net.openhft.chronicle.values.MethodTemplates;
import net.openhft.chronicle.values.VanillaByteCodeModel;
import net.openhft.chronicle.values.VanillaFieldModel;
import net.openhft.chronicle.values.VanillaJavaCodeModel;

public class VanillaCodeTemplate
implements CodeTemplate {
    final List<Consumer<LinkedHashMap<String, FieldModel>>> fieldInspectors = new ArrayList<Consumer<LinkedHashMap<String, FieldModel>>>();
    final SortedMap<MethodKey, MethodTemplates> methodPatterns = new TreeMap<MethodKey, MethodTemplates>(Comparator.comparing(k -> k.arguments).thenComparing(k -> -k.regex.length()).thenComparing(k -> k.regex));
    private final Function<Class, String> nameForClass;
    private boolean generateJava = false;

    public VanillaCodeTemplate(Function<Class, String> nameForClass) {
        this.nameForClass = nameForClass;
    }

    public static CodeTemplate of(Function<Class, String> nameForClass) {
        return new VanillaCodeTemplate(nameForClass);
    }

    @Override
    public CodeTemplate addFieldInspector(Consumer<LinkedHashMap<String, FieldModel>> fieldInspector) {
        this.fieldInspectors.add(fieldInspector);
        return this;
    }

    @Override
    public CodeTemplate addMethodPattern(String regex, int arguments, Function<Method, Class> fieldType, BiConsumer<Method, FieldModel> templateExtractor, BiConsumer<FieldModel, JavaCodeModel> javaCodeGenerator, BiConsumer<FieldModel, ByteCodeModel> byteCodeGenerator) {
        this.methodPatterns.put(new MethodKey(regex, arguments), new MethodTemplates(fieldType, templateExtractor, javaCodeGenerator, byteCodeGenerator));
        return this;
    }

    @Override
    public CodeTemplate generateJava(boolean generateJava) {
        this.generateJava = generateJava;
        return this;
    }

    @Override
    public <T> T newInstance(Class<T> tClass) {
        String name = this.nameForClass.apply(tClass);
        try {
            return (T)Class.forName(name).newInstance();
        }
        catch (InstantiationException e2) {
            throw new RuntimeException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new AssertionError((Object)e3);
        }
        catch (ClassNotFoundException e3) {
            LinkedHashMap fieldModelMap = new LinkedHashMap();
            Stream.of(tClass.getDeclaredMethods()).filter(m -> (m.getModifiers() & 0x400) != 0).forEach(m -> {
                Map.Entry entry = this.methodPatterns.entrySet().stream().filter(e -> ((MethodKey)e.getKey()).arguments == m.getParameterCount()).filter(e -> m.getName().matches(((MethodKey)e.getKey()).regex)).findFirst().orElseThrow(IllegalStateException::new);
                Matcher matcher = Pattern.compile(((MethodKey)entry.getKey()).regex).matcher(m.getName());
                if (!matcher.find()) {
                    throw new AssertionError();
                }
                String fieldName = this.convertFieldName(matcher.group(1));
                FieldModel fieldModel = fieldModelMap.computeIfAbsent(fieldName, VanillaFieldModel::new);
                ((MethodTemplates)entry.getValue()).templateExtractor.accept((Method)m, fieldModel);
                fieldModel.addTemplate((Method)m, (MethodKey)entry.getKey(), (MethodTemplates)entry.getValue());
            });
            this.fieldInspectors.forEach(fi -> fi.accept(fieldModelMap));
            JavaCodeModel jcm = VanillaJavaCodeModel.forName(name, tClass);
            ByteCodeModel bcm = VanillaByteCodeModel.forName(name, tClass);
            fieldModelMap.entrySet().forEach(e -> {
                jcm.addField((String)e.getKey(), (FieldModel)e.getValue());
                bcm.addField((String)e.getKey(), (FieldModel)e.getValue());
            });
            System.out.println(jcm.generateJavaCode());
            try {
                return ClassLoading.defineClass((String)name, (byte[])bcm.generateByteCode()).newInstance();
            }
            catch (InstantiationException e4) {
                throw new IllegalStateException(e4);
            }
            catch (IllegalAccessException e5) {
                throw new AssertionError((Object)e5);
            }
        }
    }

    protected String convertFieldName(String name) {
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }
}

