/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.openhft.chronicle.values.ByteCodeModel;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.JavaCodeModel;
import net.openhft.chronicle.values.VanillaCodeTemplate;

public interface CodeTemplate {
    public static CodeTemplate heap() {
        return VanillaCodeTemplate.of(c -> c.getName() + "$$Heap").addMethodPattern("get(\\w+)", 0, Method::getReturnType, CodeTemplate::getter, CodeTemplate::jcGetter, CodeTemplate::bcGetter).addMethodPattern("is(\\w+)", 0, Method::getReturnType, CodeTemplate::getter, CodeTemplate::jcGetter, CodeTemplate::bcGetter).addMethodPattern("set(\\w+)", 1, m -> m.getParameterTypes()[0], CodeTemplate::setter, CodeTemplate::jcSetter, CodeTemplate::bcSetter).addMethodPattern("add(\\w+)", 1, m -> m.getParameterTypes()[0], CodeTemplate::adder, CodeTemplate::jcAdder, CodeTemplate::bcAdder).addMethodPattern("addAtomic(\\w+)", 1, m -> m.getParameterTypes()[0], CodeTemplate::addAtomic, CodeTemplate::jcAddAtomic, CodeTemplate::bcAddAtomic);
    }

    public static void bcAddAtomic(FieldModel fieldModel, ByteCodeModel byteCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void jcAddAtomic(FieldModel fieldModel, JavaCodeModel javaCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void addAtomic(Method method, FieldModel fieldModel) {
        throw new UnsupportedOperationException();
    }

    public static void bcAdder(FieldModel fieldModel, ByteCodeModel byteCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void jcAdder(FieldModel fieldModel, JavaCodeModel javaCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void adder(Method method, FieldModel fieldModel) {
        throw new UnsupportedOperationException();
    }

    public static void bcSetter(FieldModel fieldModel, ByteCodeModel byteCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void jcSetter(FieldModel fieldModel, JavaCodeModel javaCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void bcGetter(FieldModel fieldModel, ByteCodeModel byteCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void jcGetter(FieldModel fieldModel, JavaCodeModel javaCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void getter(Method method, FieldModel fieldModel) {
        fieldModel.setGetter(method);
    }

    public static void setter(Method method, FieldModel fieldModel) {
        fieldModel.setSetter(method);
    }

    public static CodeTemplate direct() {
        return VanillaCodeTemplate.of(c -> c.getName() + "$$Native").addMethodPattern("get(\\w+)", 0, Method::getReturnType, CodeTemplate::getter, CodeTemplate::jcNativeGetter, CodeTemplate::bcNativeGetter).addMethodPattern("is(\\w+)", 0, Method::getReturnType, CodeTemplate::getter, CodeTemplate::jcNativeGetter, CodeTemplate::bcNativeGetter).addMethodPattern("set(\\w+)", 1, m -> m.getParameterTypes()[0], CodeTemplate::setter, CodeTemplate::jcNativeSetter, CodeTemplate::bcNativeSetter).addMethodPattern("add(\\w+)", 1, m -> m.getParameterTypes()[0], CodeTemplate::adder, CodeTemplate::jcNativeAdder, CodeTemplate::bcNativeAdder).addMethodPattern("addAtomic(\\w+)", 1, m -> m.getParameterTypes()[0], CodeTemplate::addAtomic, CodeTemplate::jcNativeAddAtomic, CodeTemplate::bcNativeAddAtomic).addFieldInspector(CodeTemplate::sortFieldsById);
    }

    public static void sortFieldsById(LinkedHashMap<String, FieldModel> fieldModelMap) {
        List<Map.Entry> sortedFields = fieldModelMap.entrySet().stream().sorted(Comparator.comparing(e -> ((FieldModel)e.getValue()).getGroupId()).thenComparing(e -> -((FieldModel)e.getValue()).byteAlignment())).collect(Collectors.toList());
        fieldModelMap.clear();
        sortedFields.forEach(e -> {
            FieldModel cfr_ignored_0 = (FieldModel)fieldModelMap.put((String)e.getKey(), (FieldModel)e.getValue());
        });
    }

    public static void bcNativeAddAtomic(FieldModel fieldModel, ByteCodeModel byteCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void jcNativeAddAtomic(FieldModel fieldModel, JavaCodeModel javaCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void bcNativeAdder(FieldModel fieldModel, ByteCodeModel byteCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void jcNativeAdder(FieldModel fieldModel, JavaCodeModel javaCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void bcNativeSetter(FieldModel fieldModel, ByteCodeModel byteCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void jcNativeSetter(FieldModel fieldModel, JavaCodeModel javaCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void bcNativeGetter(FieldModel fieldModel, ByteCodeModel byteCodeModel) {
        throw new UnsupportedOperationException();
    }

    public static void jcNativeGetter(FieldModel fieldModel, JavaCodeModel javaCodeModel) {
        throw new UnsupportedOperationException();
    }

    public CodeTemplate addFieldInspector(Consumer<LinkedHashMap<String, FieldModel>> var1);

    public CodeTemplate addMethodPattern(String var1, int var2, Function<Method, Class> var3, BiConsumer<Method, FieldModel> var4, BiConsumer<FieldModel, JavaCodeModel> var5, BiConsumer<FieldModel, ByteCodeModel> var6);

    public CodeTemplate generateJava(boolean var1);

    public <T> T newInstance(Class<T> var1);
}

