/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.EventHandlers;
import net.openhft.chronicle.threads.MediumEventLoop;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaEventLoop
extends MediumEventLoop {
    public static final Set<HandlerPriority> ALLOWED_PRIORITIES = Collections.unmodifiableSet(EnumSet.of(HandlerPriority.HIGH, HandlerPriority.MEDIUM, HandlerPriority.TIMER, HandlerPriority.DAEMON));
    private final List<EventHandler> timerHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final List<EventHandler> daemonHandlers = new CopyOnWriteArrayList<EventHandler>();
    private final long timerIntervalMS;
    private final Set<HandlerPriority> priorities;

    public VanillaEventLoop(@Nullable EventLoop parent, String name, Pauser pauser, long timerIntervalMS, boolean daemon, String binding, Set<HandlerPriority> priorities) {
        super(parent, name, pauser, daemon, binding);
        this.timerIntervalMS = timerIntervalMS;
        this.priorities = EnumSet.copyOf(priorities);
    }

    public static void closeAll(@NotNull List<EventHandler> handlers) {
        Closeable.closeQuietly(handlers);
    }

    private static void clearUsedByThread(@NotNull EventHandler handler) {
        if (handler instanceof AbstractCloseable) {
            ((AbstractCloseable)handler).singleThreadedCheckReset();
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "VanillaEventLoop{name='" + this.name + '\'' + ", parent=" + this.parent + ", service=" + this.service + ", highHandler=" + this.highHandler + ", mediumHandlers=" + this.mediumHandlers + ", timerHandlers=" + this.timerHandlers + ", daemonHandlers=" + this.daemonHandlers + ", newHandlers=" + this.newHandlers + ", pauser=" + this.pauser + '}';
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        this.throwExceptionIfClosed();
        HandlerPriority priority = handler.priority();
        if (DEBUG_ADDING_HANDLERS) {
            Jvm.startup().on(this.getClass(), "Adding " + priority + " " + handler + " to " + this.name);
        }
        if (!this.priorities.contains(priority)) {
            throw new IllegalStateException(this.name() + ": Unexpected priority " + priority + " for " + handler + " allows " + this.priorities);
        }
        this.addHandlerInternal(handler);
    }

    @Override
    protected void loopStartedAllHandlers() {
        super.loopStartedAllHandlers();
        if (!this.timerHandlers.isEmpty()) {
            this.timerHandlers.forEach(EventHandler::loopStarted);
        }
        if (!this.daemonHandlers.isEmpty()) {
            this.daemonHandlers.forEach(EventHandler::loopStarted);
        }
    }

    @Override
    protected void loopFinishedAllHandlers() {
        super.loopFinishedAllHandlers();
        if (!this.timerHandlers.isEmpty()) {
            this.timerHandlers.forEach(Threads::loopFinishedQuietly);
        }
        if (!this.daemonHandlers.isEmpty()) {
            this.daemonHandlers.forEach(Threads::loopFinishedQuietly);
        }
    }

    @Override
    protected long timerIntervalMS() {
        return this.timerIntervalMS;
    }

    @Override
    protected void runTimerHandlers() {
        this.runAllHandlers(this.timerHandlers);
    }

    @Override
    protected void runDaemonHandlers() {
        this.runAllHandlers(this.daemonHandlers);
    }

    private void runAllHandlers(List<EventHandler> handlers) {
        for (int i = 0; i < handlers.size(); ++i) {
            EventHandler handler = null;
            try {
                handler = handlers.get(i);
                handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                VanillaEventLoop.removeHandler(handler, handlers);
                continue;
            }
            catch (Throwable e) {
                if (!this.handle(this, handler, e)) continue;
                VanillaEventLoop.removeHandler(handler, handlers);
            }
        }
    }

    @Override
    protected void addNewHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1.alias()) {
            case HIGH: {
                if (this.updateHighHandler(handler)) break;
                Jvm.warn().on(this.getClass(), "Only one high handler supported was " + this.highHandler + ", treating " + handler + " as MEDIUM");
            }
            case MEDIUM: {
                if (this.mediumHandlers.contains(handler)) break;
                VanillaEventLoop.clearUsedByThread(handler);
                handler.eventLoop((EventLoop)(this.parent != null ? this.parent : this));
                this.mediumHandlers.add(handler);
                this.mediumHandlers.sort(Comparator.comparing(EventHandler::priority).reversed());
                this.updateMediumHandlersArray();
                break;
            }
            case TIMER: {
                if (this.timerHandlers.contains(handler)) break;
                VanillaEventLoop.clearUsedByThread(handler);
                handler.eventLoop((EventLoop)(this.parent != null ? this.parent : this));
                this.timerHandlers.add(handler);
                break;
            }
            case DAEMON: {
                if (this.daemonHandlers.contains(handler)) break;
                VanillaEventLoop.clearUsedByThread(handler);
                handler.eventLoop((EventLoop)(this.parent != null ? this.parent : this));
                this.daemonHandlers.add(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot add a " + handler.priority() + " task to a busy waiting thread");
            }
        }
        if (this.thread != null) {
            handler.loopStarted();
        }
    }

    @Override
    public int handlerCount() {
        return this.nonDaemonHandlerCount() + this.daemonHandlers.size() + this.timerHandlers.size();
    }

    @Override
    protected void performClose() {
        try {
            super.performClose();
        }
        finally {
            this.daemonHandlers.clear();
            this.timerHandlers.clear();
        }
    }

    @Override
    protected void closeAllHandlers() {
        VanillaEventLoop.closeAll(this.daemonHandlers);
        VanillaEventLoop.closeAll(this.timerHandlers);
        super.closeAllHandlers();
    }

    @Override
    public void dumpRunningHandlers() {
        int handlerCount = this.handlerCount();
        if (handlerCount <= 0) {
            return;
        }
        List<EventHandler> collect = Stream.of(Collections.singletonList(this.highHandler), this.mediumHandlers, this.daemonHandlers, this.timerHandlers).flatMap(Collection::stream).filter(e -> e != EventHandlers.NOOP).filter(Closeable.class::isInstance).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        Jvm.debug().on(this.getClass(), "Handlers still running after being closed, handlerCount=" + handlerCount);
        collect.forEach(h -> Jvm.debug().on(this.getClass(), "\t" + h));
    }
}

