/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimingPauser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongPauser
implements Pauser,
TimingPauser {
    private static final String SHOW_PAUSES = Jvm.getProperty((String)"pauses.show");
    private final long minPauseTimeNS;
    private final long maxPauseTimeNS;
    private final AtomicBoolean pausing = new AtomicBoolean();
    private final long minBusyNS;
    private final long minYieldNS;
    private long busyNS = Long.MAX_VALUE;
    private long yieldNS = Long.MAX_VALUE;
    private long pauseTimeNS;
    private long timePaused = 0L;
    private long countPaused = 0L;
    @Nullable
    private volatile Thread thread = null;
    private long yieldStart = 0L;
    private long timeOutStart = Long.MAX_VALUE;
    private long pauseUntilNS = 0L;
    private long pauseStartNS = 0L;

    public LongPauser(int minBusy, int minYield, long minTime, long maxTime, @NotNull TimeUnit timeUnit) {
        this.minBusyNS = timeUnit.toNanos(minBusy);
        this.minYieldNS = timeUnit.toNanos(minYield);
        this.minPauseTimeNS = timeUnit.toNanos(minTime);
        this.maxPauseTimeNS = timeUnit.toNanos(maxTime);
        this.pauseTimeNS = this.minPauseTimeNS;
    }

    @Override
    public void reset() {
        this.checkYieldTime();
        this.pauseTimeNS = this.minPauseTimeNS;
        this.timeOutStart = Long.MAX_VALUE;
        this.yieldNS = Long.MAX_VALUE;
        this.busyNS = Long.MAX_VALUE;
        if (this.pauseStartNS > 0L) {
            this.showPauses();
            this.pauseStartNS = 0L;
        }
    }

    @Override
    public void pause() {
        try {
            this.pause(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Override
    public void asyncPause() {
        this.pauseUntilNS = System.nanoTime() + this.pauseTimeNS;
        this.increasePauseTimeNS();
    }

    @Override
    public boolean asyncPausing() {
        return this.pauseUntilNS > System.nanoTime();
    }

    private void showPauses() {
        String name = Thread.currentThread().getName();
        if (name.startsWith(SHOW_PAUSES)) {
            Jvm.perf().on(this.getClass(), " paused for " + (double)(System.nanoTime() - this.pauseStartNS) / 1000000.0 + " ms.");
        }
    }

    @Override
    public void pause(long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        long now = System.nanoTime();
        if (this.busyNS == Long.MAX_VALUE) {
            this.busyNS = now;
            return;
        }
        if (now < this.busyNS + this.minBusyNS) {
            Jvm.nanoPause();
            return;
        }
        this.busyNS = 0L;
        if (SHOW_PAUSES != null && this.pauseStartNS == 0L) {
            this.pauseStartNS = now;
        }
        if (this.yieldNS == Long.MAX_VALUE) {
            this.yieldNS = now;
            return;
        }
        if (now < this.yieldNS + this.minYieldNS) {
            this.yield();
            return;
        }
        if (timeout < Long.MAX_VALUE) {
            if (this.timeOutStart == Long.MAX_VALUE) {
                this.timeOutStart = now;
            } else if (this.timeOutStart + timeUnit.toNanos(timeout) - now < 0L) {
                throw new TimeoutException();
            }
        }
        this.checkYieldTime();
        this.doPause(this.pauseTimeNS);
        this.increasePauseTimeNS();
    }

    private void increasePauseTimeNS() {
        this.pauseTimeNS = Math.min(this.maxPauseTimeNS, this.pauseTimeNS + (this.pauseTimeNS >> 7) + 10000L);
    }

    private void checkYieldTime() {
        if (this.yieldStart > 0L) {
            long time = System.nanoTime() - this.yieldStart;
            this.timePaused += time;
            ++this.countPaused;
            this.yieldStart = 0L;
        }
    }

    private void yield() {
        if (this.yieldStart == 0L) {
            this.yieldStart = System.nanoTime();
        }
        Thread.yield();
    }

    void doPause(long delayNs) {
        long start = System.nanoTime();
        this.thread = Thread.currentThread();
        this.pausing.set(true);
        if (!Thread.currentThread().isInterrupted()) {
            LockSupport.parkNanos(delayNs);
        }
        this.pausing.set(false);
        long time = System.nanoTime() - start;
        this.timePaused += time;
        ++this.countPaused;
    }

    @Override
    public void unpause() {
        Thread threadSnapshot = this.thread;
        if (threadSnapshot != null && this.pausing.get()) {
            LockSupport.unpark(threadSnapshot);
        }
    }

    @Override
    public long timePaused() {
        return this.timePaused / 1000000L;
    }

    @Override
    public long countPaused() {
        return this.countPaused;
    }
}

