/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.AbstractLifecycleEventLoop;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;

public class MonitorEventLoop
extends AbstractLifecycleEventLoop
implements Runnable,
EventLoop {
    public static final String MONITOR_INITIAL_DELAY = "MonitorInitialDelay";
    static int MONITOR_INITIAL_DELAY_MS = Integer.getInteger("MonitorInitialDelay", 10000);
    private final transient ExecutorService service;
    private final EventLoop parent;
    private final List<EventHandler> handlers = new CopyOnWriteArrayList<EventHandler>();
    private final Pauser pauser;

    public MonitorEventLoop(EventLoop parent, Pauser pauser) {
        this(parent, "", pauser);
    }

    public MonitorEventLoop(EventLoop parent, String name, Pauser pauser) {
        super(name + (parent == null ? "" : parent.name()) + "/event~loop~monitor");
        this.parent = parent;
        this.pauser = pauser;
        this.service = Executors.newSingleThreadExecutor(new NamedThreadFactory(name, true, null, true));
    }

    @Override
    protected void performStart() {
        this.service.submit(this);
    }

    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    protected void performStopFromNew() {
        this.performStop();
    }

    @Override
    protected void performStopFromStarted() {
        this.performStop();
    }

    private void performStop() {
        this.unpause();
        Threads.shutdownDaemon(this.service);
        this.handlers.forEach(Threads::loopFinishedQuietly);
    }

    public boolean isAlive() {
        return this.isStarted();
    }

    public synchronized void addHandler(@NotNull EventHandler handler) {
        this.throwExceptionIfClosed();
        if (DEBUG_ADDING_HANDLERS) {
            Jvm.startup().on(this.getClass(), "Adding " + handler.priority() + " " + handler + " to " + this.name);
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Event Group has been closed");
        }
        if (!this.handlers.contains(handler)) {
            this.handlers.add(new IdempotentLoopStartedEventHandler(handler));
        }
        handler.eventLoop(this.parent);
    }

    @Override
    @HotMethod
    public void run() {
        this.throwExceptionIfClosed();
        try {
            long waitUntilMs = System.currentTimeMillis() + (long)MONITOR_INITIAL_DELAY_MS;
            while (System.currentTimeMillis() < waitUntilMs && this.isStarted()) {
                this.pauser.pause();
            }
            this.pauser.reset();
            while (this.isStarted() && !Thread.currentThread().isInterrupted()) {
                boolean busy = this.runHandlers();
                this.pauser.pause();
                if (!busy) continue;
                this.pauser.reset();
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
        }
    }

    @HotMethod
    private boolean runHandlers() {
        boolean busy = false;
        for (int i = 0; i < this.handlers.size(); ++i) {
            EventHandler handler = this.handlers.get(i);
            handler.loopStarted();
            try {
                busy |= handler.action();
                continue;
            }
            catch (InvalidEventHandlerException e) {
                this.removeHandler(i--);
                continue;
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), "Loop terminated due to exception", (Throwable)e);
                this.removeHandler(i--);
            }
        }
        return busy;
    }

    private synchronized void removeHandler(int handlerIndex) {
        block2: {
            try {
                EventHandler removedHandler = this.handlers.remove(handlerIndex);
                removedHandler.loopFinished();
                Closeable.closeQuietly((Object)removedHandler);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (this.handlers.isEmpty()) break block2;
                Jvm.warn().on(MonitorEventLoop.class, "Error removing handler!");
            }
        }
    }

    @Override
    protected void performClose() {
        super.performClose();
        Closeable.closeQuietly(this.handlers);
    }

    private static final class IdempotentLoopStartedEventHandler
    extends AbstractCloseable
    implements EventHandler {
        private final EventHandler eventHandler;
        private boolean loopStarted = false;

        public IdempotentLoopStartedEventHandler(@NotNull EventHandler eventHandler) {
            this.eventHandler = eventHandler;
        }

        public boolean action() throws InvalidEventHandlerException {
            return this.eventHandler.action();
        }

        public void eventLoop(EventLoop eventLoop) {
            this.eventHandler.eventLoop(eventLoop);
        }

        public void loopStarted() {
            if (!this.loopStarted) {
                this.loopStarted = true;
                this.eventHandler.loopStarted();
            }
        }

        public void loopFinished() {
            this.eventHandler.loopFinished();
        }

        @NotNull
        public HandlerPriority priority() {
            return this.eventHandler.priority();
        }

        public boolean equals(Object o) {
            return this.eventHandler.equals(o);
        }

        public int hashCode() {
            return this.eventHandler.hashCode();
        }

        protected void performClose() throws IllegalStateException {
            Closeable.closeQuietly((Object)this.eventHandler);
        }
    }
}

