/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.BlockingEventLoop;
import net.openhft.chronicle.threads.CoreEventLoop;
import net.openhft.chronicle.threads.MediumEventLoop;
import net.openhft.chronicle.threads.MilliPauser;
import net.openhft.chronicle.threads.MonitorEventLoop;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.PauserMonitor;
import net.openhft.chronicle.threads.ThreadMonitorEventHandler;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.threads.VanillaEventLoop;
import org.jetbrains.annotations.NotNull;

public class EventGroup
extends AbstractCloseable
implements EventLoop {
    public static final int CONC_THREADS = Integer.getInteger("eventGroup.conc.threads", Integer.getInteger("CONC_THREADS", Runtime.getRuntime().availableProcessors() / 4));
    private static final long REPLICATION_MONITOR_INTERVAL_MS = Long.getLong("REPLICATION_MONITOR_INTERVAL_MS", 500L);
    private static final long MONITOR_INTERVAL_MS = Long.getLong("MONITOR_INTERVAL_MS", 100L);
    private static final Integer REPLICATION_EVENT_PAUSE_TIME = Integer.getInteger("replicationEventPauseTime", 20);
    private final AtomicInteger counter = new AtomicInteger();
    @NotNull
    private final EventLoop monitor;
    private final CoreEventLoop core;
    private final BlockingEventLoop blocking;
    @NotNull
    private final Pauser pauser;
    private final Pauser concPauser;
    private final String concBinding;
    private final String bindingReplication;
    private final String name;
    private final Set<HandlerPriority> priorities;
    @NotNull
    private final VanillaEventLoop[] concThreads;
    private final MilliPauser milliPauser = Pauser.millis(50);
    private final boolean daemon;
    private VanillaEventLoop replication;

    @Deprecated
    public EventGroup(boolean daemon, @NotNull Pauser pauser, boolean binding, int bindingCpuCore, int bindingCpuReplication, String name, int concThreads) {
        this(daemon, pauser, bindingCpuCore != -1 ? Integer.toString(bindingCpuCore) : (binding ? "any" : "none"), bindingCpuReplication != -1 ? Integer.toString(bindingCpuReplication) : "none", name, concThreads, EnumSet.noneOf(HandlerPriority.class));
    }

    public EventGroup(boolean daemon, @NotNull Pauser pauser, String binding, String bindingReplication, String name, int concThreadsNum, Set<HandlerPriority> priorities) {
        this(daemon, pauser, binding, bindingReplication, name, concThreadsNum, "none", Pauser.balancedUpToMillis(REPLICATION_EVENT_PAUSE_TIME), priorities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventGroup(boolean daemon, @NotNull Pauser pauser, String binding, String bindingReplication, String name, int concThreadsNum, String concBinding, @NotNull Pauser concPauser, Set<HandlerPriority> priorities) {
        this.daemon = daemon;
        this.pauser = pauser;
        this.concBinding = concBinding;
        this.concPauser = concPauser;
        this.bindingReplication = bindingReplication;
        this.name = name;
        this.priorities = EnumSet.copyOf(priorities);
        ArrayList<EventLoop> closeable = new ArrayList<EventLoop>();
        try {
            Set corePriorities = priorities.stream().filter(VanillaEventLoop.ALLOWED_PRIORITIES::contains).collect(Collectors.toSet());
            this.core = priorities.stream().anyMatch(VanillaEventLoop.ALLOWED_PRIORITIES::contains) ? (corePriorities.equals(EnumSet.of(HandlerPriority.MEDIUM)) ? new MediumEventLoop(this, name + "core-event-loop", pauser, daemon, binding) : new VanillaEventLoop((EventLoop)this, name + "core-event-loop", pauser, 1L, daemon, binding, priorities)) : null;
            closeable.add(this.core);
            this.monitor = new MonitorEventLoop(this, name + "~monitor", Pauser.millis(Integer.getInteger("monitor.interval", 10)));
            closeable.add(this.monitor);
            if (this.core != null) {
                this.monitor.addHandler((EventHandler)new PauserMonitor(pauser, name + "core-pauser", 30));
            }
            this.blocking = priorities.contains(HandlerPriority.BLOCKING) ? new BlockingEventLoop(this, name + "blocking-event-loop") : null;
            closeable.add(this.blocking);
            this.concThreads = new VanillaEventLoop[priorities.contains(HandlerPriority.CONCURRENT) ? concThreadsNum : 0];
            closeable.clear();
        }
        finally {
            Closeable.closeQuietly(closeable);
        }
    }

    public EventGroup(boolean daemon) {
        this(daemon, false);
    }

    public EventGroup(boolean daemon, boolean binding) {
        this(daemon, Pauser.balanced(), binding);
    }

    public EventGroup(boolean daemon, @NotNull Pauser pauser, boolean binding) {
        this(daemon, pauser, binding, -1, -1, "");
    }

    public EventGroup(boolean daemon, @NotNull Pauser pauser, boolean binding, String name) {
        this(daemon, pauser, binding, -1, -1, name);
    }

    public EventGroup(boolean daemon, @NotNull Pauser pauser, boolean binding, int bindingCpuCore, int bindingCpuReplication, String name) {
        this(daemon, pauser, bindingCpuCore != -1 ? Integer.toString(bindingCpuCore) : (binding ? "any" : "none"), bindingCpuReplication != -1 ? Integer.toString(bindingCpuReplication) : "none", name, CONC_THREADS, EnumSet.allOf(HandlerPriority.class));
    }

    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }

    private synchronized VanillaEventLoop getReplication() {
        if (this.replication == null) {
            TimingPauser pauser = Pauser.balancedUpToMillis(REPLICATION_EVENT_PAUSE_TIME);
            this.replication = new VanillaEventLoop((EventLoop)this, this.name + "replication-event-loop", (Pauser)pauser, (long)REPLICATION_EVENT_PAUSE_TIME.intValue(), true, this.bindingReplication, EnumSet.of(HandlerPriority.REPLICATION));
            this.monitor.addHandler((EventHandler)new LoopBlockMonitor(REPLICATION_MONITOR_INTERVAL_MS, this.replication));
            if (this.isAlive()) {
                this.replication.start();
            }
            this.monitor.addHandler((EventHandler)new PauserMonitor(pauser, this.name + "replication pauser", 60));
        }
        return this.replication;
    }

    private synchronized VanillaEventLoop getConcThread(int n) {
        if (this.concThreads[n] == null) {
            this.concThreads[n] = new VanillaEventLoop((EventLoop)this, this.name + "conc-event-loop-" + n, this.concPauser, (long)REPLICATION_EVENT_PAUSE_TIME.intValue(), this.daemon, this.concBinding, EnumSet.of(HandlerPriority.CONCURRENT));
            this.monitor.addHandler((EventHandler)new LoopBlockMonitor(REPLICATION_MONITOR_INTERVAL_MS, this.concThreads[n]));
            if (this.isAlive()) {
                this.concThreads[n].start();
            }
            this.monitor.addHandler((EventHandler)new PauserMonitor(this.pauser, this.name + "conc-event-loop-" + n + " pauser", 60));
        }
        return this.concThreads[n];
    }

    public void awaitTermination() {
        this.monitor.awaitTermination();
        if (this.core != null) {
            this.core.awaitTermination();
        }
        if (this.blocking != null) {
            this.blocking.awaitTermination();
        }
        if (this.replication != null) {
            this.replication.awaitTermination();
        }
        for (VanillaEventLoop concThread : this.concThreads) {
            if (concThread == null) continue;
            concThread.awaitTermination();
        }
    }

    public void unpause() {
        this.pauser.unpause();
        if (this.blocking != null) {
            this.blocking.unpause();
        }
        if (this.replication != null) {
            this.replication.unpause();
        }
    }

    public String name() {
        return this.name;
    }

    public void addHandler(@NotNull EventHandler handler) {
        this.throwExceptionIfClosed();
        HandlerPriority t1 = handler.priority();
        switch (t1) {
            case MONITOR: {
                this.monitor.addHandler(handler);
                break;
            }
            case HIGH: 
            case MEDIUM: 
            case TIMER: 
            case DAEMON: {
                if (this.core == null) {
                    throw new IllegalStateException("Cannot add " + t1 + " " + handler + " to " + this.name);
                }
                this.core.addHandler(handler);
                break;
            }
            case BLOCKING: {
                if (this.blocking == null) {
                    throw new IllegalStateException("Cannot add BLOCKING " + handler + " to " + this.name);
                }
                this.blocking.addHandler(handler);
                break;
            }
            case REPLICATION: {
                if (!this.priorities.contains(HandlerPriority.REPLICATION)) {
                    throw new IllegalStateException("Cannot add REPLICATION " + handler + " to " + this.name);
                }
                this.getReplication().addHandler(handler);
                break;
            }
            case CONCURRENT: {
                if (this.concThreads.length == 0) {
                    throw new IllegalStateException("Cannot add CONCURRENT " + handler + " to " + this.name);
                }
                this.getConcThread(this.counter.getAndIncrement() % this.concThreads.length).addHandler(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown priority " + handler.priority());
            }
        }
    }

    public void setupTimeLimitMonitor(long timeLimitNS, LongSupplier timeOfStart) {
        this.throwExceptionIfClosed();
        this.addTimingMonitor(this.name + "-monitor", timeLimitNS, timeOfStart, this.core::thread);
    }

    public void addTimingMonitor(String description, long timeLimitNS, LongSupplier timeSupplier, Supplier<Thread> threadSupplier) {
        this.milliPauser.minPauseTimeMS((timeLimitNS + 999999L) / 1000000L);
        this.addHandler(new ThreadMonitorEventHandler(description, timeLimitNS, timeSupplier, threadSupplier));
    }

    public synchronized void start() {
        this.throwExceptionIfClosed();
        if (!this.isAlive()) {
            if (this.core != null) {
                this.core.start();
            }
            if (this.blocking != null) {
                this.blocking.start();
            }
            if (this.replication != null) {
                this.replication.start();
            }
            for (VanillaEventLoop concThread : this.concThreads) {
                if (concThread == null) continue;
                concThread.start();
            }
            this.monitor.start();
            if (this.core != null) {
                this.monitor.addHandler((EventHandler)new LoopBlockMonitor(MONITOR_INTERVAL_MS, this.core));
            }
            while (!this.isAlive()) {
                Jvm.pause((long)1L);
            }
        }
    }

    public void stop() {
        this.monitor.stop();
        if (this.replication != null) {
            this.replication.stop();
        }
        for (VanillaEventLoop concThread : this.concThreads) {
            if (concThread == null) continue;
            concThread.stop();
        }
        if (this.core != null) {
            this.core.stop();
        }
        if (this.blocking != null) {
            this.blocking.stop();
        }
    }

    public boolean isAlive() {
        return (this.core == null ? this.monitor : this.core).isAlive();
    }

    protected void performClose() {
        this.stop();
        Closeable.closeQuietly((Object[])new Object[]{this.core, this.monitor, this.replication, this.blocking});
        Closeable.closeQuietly((Object[])this.concThreads);
        this.awaitTermination();
    }

    static final class LoopBlockMonitor
    implements EventHandler {
        private final long monitoryIntervalMs;
        @NotNull
        private final CoreEventLoop eventLoop;
        private long printBlockTimeMS;
        private long interval;

        public LoopBlockMonitor(long monitoryIntervalMs, @NotNull CoreEventLoop eventLoop) {
            this.monitoryIntervalMs = monitoryIntervalMs;
            assert (eventLoop != null);
            this.eventLoop = eventLoop;
            this.interval = this.printBlockTimeMS = monitoryIntervalMs;
        }

        public boolean action() throws InvalidEventHandlerException {
            long loopStartMS = this.eventLoop.loopStartMS();
            if (loopStartMS <= 0L || loopStartMS == Long.MAX_VALUE) {
                if (this.interval != this.monitoryIntervalMs) {
                    Jvm.warn().on(this.getClass(), "Reset interval from " + this.interval);
                    this.interval = this.printBlockTimeMS = this.monitoryIntervalMs;
                }
                return false;
            }
            if (loopStartMS == 0x7FFFFFFFFFFFFFFEL) {
                Jvm.warn().on(this.getClass(), "Monitoring a task which has finished " + this.eventLoop);
                throw new InvalidEventHandlerException();
            }
            long now = System.currentTimeMillis();
            long blockingTimeMS = now - loopStartMS;
            if (blockingTimeMS >= this.printBlockTimeMS && this.eventLoop.isAlive()) {
                this.eventLoop.dumpRunningState(this.eventLoop.name() + " thread has blocked for " + blockingTimeMS + " ms.", () -> this.eventLoop.loopStartMS() == loopStartMS);
                this.printBlockTimeMS += this.interval;
                this.interval = (long)((double)this.interval * 1.41);
                if (this.interval > 20L * this.monitoryIntervalMs) {
                    this.interval = this.monitoryIntervalMs * 20L;
                    this.printBlockTimeMS -= this.printBlockTimeMS % this.interval;
                }
            }
            return false;
        }

        @NotNull
        public HandlerPriority priority() {
            return HandlerPriority.MONITOR;
        }

        public String toString() {
            return "LoopBlockMonitor<" + this.eventLoop.name() + '>';
        }
    }
}

