/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.Pauser;

public class YieldingPauser
implements Pauser {
    private final int minBusy;
    private int count = 0;
    private long timePaused = 0L;
    private long countPaused = 0L;
    private long yieldStart = 0L;

    public YieldingPauser(int minBusy) {
        this.minBusy = minBusy;
    }

    @Override
    public void reset() {
        this.checkYieldTime();
        this.count = 0;
    }

    @Override
    public void pause() {
        ++this.count;
        if (this.count < this.minBusy) {
            Jvm.safepoint();
            return;
        }
        this.yield();
    }

    private void checkYieldTime() {
        if (this.yieldStart > 0L) {
            long time = System.nanoTime() - this.yieldStart;
            this.timePaused += time;
            ++this.countPaused;
            this.yieldStart = 0L;
        }
    }

    private void yield() {
        if (this.yieldStart == 0L) {
            this.yieldStart = System.nanoTime();
        }
        Thread.yield();
    }

    @Override
    public void unpause() {
    }

    @Override
    public long timePaused() {
        return this.timePaused / 1000000L;
    }

    @Override
    public long countPaused() {
        return this.countPaused;
    }
}

