/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.threads.NamedThreadFactory;

public enum DiskSpaceMonitor implements Runnable
{
    INSTANCE;

    static final boolean WARN_DELETED;
    public static final String DISK_SPACE_CHECKER_NAME = "disk-space-checker";
    final Map<File, FileStore> fileStoreCacheMap = new ConcurrentHashMap<File, FileStore>();
    final Map<FileStore, DiskAttributes> diskAttributesMap = new ConcurrentHashMap<FileStore, DiskAttributes>();
    final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("disk-space-checker", true, 1));
    private int thresholdPercentage;

    private DiskSpaceMonitor() {
        this.executor.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.SECONDS);
    }

    public void clear() {
        this.fileStoreCacheMap.clear();
        this.diskAttributesMap.clear();
    }

    public void pollDiskSpace(File file) {
        FileStore fs = this.fileStoreCacheMap.get(file);
        if (fs == null) {
            if (file.exists()) {
                Path path = file.getAbsoluteFile().toPath();
                try {
                    fs = Files.getFileStore(path);
                    this.fileStoreCacheMap.put(file, fs);
                }
                catch (IOException e) {
                    Jvm.warn().on(this.getClass(), "Error trying to obtain the FileStore for " + path, (Throwable)e);
                    return;
                }
            } else {
                return;
            }
        }
        DiskAttributes da = this.diskAttributesMap.computeIfAbsent(fs, DiskAttributes::new);
        da.polled = true;
    }

    @Override
    public void run() {
        Iterator<DiskAttributes> iterator = this.diskAttributesMap.values().iterator();
        while (iterator.hasNext()) {
            DiskAttributes da = iterator.next();
            try {
                da.run();
            }
            catch (IOException e) {
                if (WARN_DELETED) {
                    Jvm.warn().on(this.getClass(), "Unable to get disk space for " + da.fileStore, (Throwable)e);
                }
                iterator.remove();
            }
        }
    }

    public int getThresholdPercentage() {
        return this.thresholdPercentage;
    }

    public void setThresholdPercentage(int thresholdPercentage) {
        this.thresholdPercentage = thresholdPercentage;
    }

    static {
        WARN_DELETED = Boolean.getBoolean("disk.monitor.deleted.warning");
    }

    static class DiskAttributes {
        volatile boolean polled;
        long timeNextCheckedMS;
        long totalSpace;
        private FileStore fileStore;

        DiskAttributes(FileStore fileStore) {
            this.fileStore = fileStore;
        }

        void run() throws IOException {
            long unallocatedBytes;
            long now = System.currentTimeMillis();
            if (this.timeNextCheckedMS > now || !this.polled) {
                return;
            }
            this.polled = false;
            long start = System.nanoTime();
            if (this.totalSpace <= 0L) {
                this.totalSpace = this.fileStore.getTotalSpace();
            }
            if ((unallocatedBytes = this.fileStore.getUnallocatedSpace()) < 0xC800000L) {
                Jvm.warn().on(this.getClass(), "your disk " + this.fileStore + " is almost full, warning: chronicle-queue may crash if it runs out of space.");
            } else if (unallocatedBytes < this.totalSpace * (long)INSTANCE.thresholdPercentage / 100L) {
                double diskSpaceFull = (double)(1000L * (this.totalSpace - unallocatedBytes) / this.totalSpace) / 10.0;
                Jvm.warn().on(this.getClass(), "your disk " + this.fileStore + " is " + diskSpaceFull + "% full, warning: chronicle-queue may crash if it runs out of space.");
            } else {
                this.timeNextCheckedMS = now + (unallocatedBytes >> 20);
            }
            long time = System.nanoTime() - start;
            if (time > 1000000L) {
                Jvm.debug().on(this.getClass(), "Took " + (double)(time / 10000L) / 100.0 + " ms to check the disk space of " + this.fileStore);
            }
        }
    }
}

