/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.threads.Pauser;

public class LongPauser
implements Pauser {
    private final long minPauseTimeNS;
    private final long maxPauseTimeNS;
    private final AtomicBoolean pausing = new AtomicBoolean();
    private final int minBusy;
    private final int minCount;
    private int count = 0;
    private long pauseTimeNS;
    private long timePaused = 0L;
    private long countPaused = 0L;
    private volatile Thread thread = null;

    public LongPauser(int minBusy, int minCount, long minTime, long maxTime, TimeUnit timeUnit) {
        this.minBusy = minBusy;
        this.minCount = minCount;
        this.minPauseTimeNS = timeUnit.toNanos(minTime);
        this.maxPauseTimeNS = timeUnit.toNanos(maxTime);
        this.pauseTimeNS = this.minPauseTimeNS;
    }

    @Override
    public void reset() {
        this.pauseTimeNS = this.minPauseTimeNS;
        this.count = 0;
    }

    @Override
    public void pause() {
        ++this.count;
        if (this.count < this.minBusy) {
            return;
        }
        if (this.count <= this.minBusy + this.minCount) {
            Thread.yield();
            return;
        }
        this.doPause(this.pauseTimeNS);
        this.pauseTimeNS = Math.min(this.maxPauseTimeNS, this.pauseTimeNS + this.pauseTimeNS / 10L);
    }

    void doPause(long delayNs) {
        long start = System.nanoTime();
        this.thread = Thread.currentThread();
        this.pausing.set(true);
        LockSupport.parkNanos(delayNs);
        this.pausing.set(false);
        long time = System.nanoTime() - start;
        this.timePaused += time;
        ++this.countPaused;
    }

    @Override
    public void unpause() {
        Thread thread = this.thread;
        if (thread != null && this.pausing.get()) {
            LockSupport.unpark(thread);
        }
    }

    @Override
    public long timePaused() {
        return this.timePaused / 1000000L;
    }

    @Override
    public long countPaused() {
        return this.countPaused;
    }
}

