/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.threads.api.InvalidEventHandlerException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockingEventLoop
implements EventLoop {
    private final EventLoop parent;
    @NotNull
    private final ExecutorService service;
    @Nullable
    private Thread thread = null;
    private volatile boolean closed;
    private EventHandler handler;

    public BlockingEventLoop(EventLoop parent, String name) {
        this.parent = parent;
        this.service = Executors.newCachedThreadPool(new NamedThreadFactory(name, true));
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        Closeable.closeQuietly((Object)this.handler);
        this.handler = handler;
        this.service.submit(() -> {
            this.thread = Thread.currentThread();
            handler.eventLoop(this.parent);
            try {
                while (!this.closed) {
                    handler.action();
                }
            }
            catch (InvalidEventHandlerException invalidEventHandlerException) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                if (Jvm.isDebug()) {
                    System.out.println("handler " + handler + " done.");
                }
            }
        });
    }

    @Override
    public void start() {
    }

    @Override
    public void unpause() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void close() {
        this.closed = true;
        Closeable.closeQuietly((Object)this.handler);
        this.service.shutdown();
        try {
            if (!this.service.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                this.service.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.service.shutdownNow();
        }
        try {
            if (this.thread != null) {
                this.thread.join(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.thread != null && this.thread.isAlive()) {
            StackTraceElement[] stackTrace = this.thread.getStackTrace();
            StringBuilder sb = new StringBuilder(this.thread + " still running ");
            Jvm.trimStackTrace((StringBuilder)sb, (StackTraceElement[])stackTrace);
            System.out.println(sb);
        }
    }
}

