/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.salt;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.salt.Sodium;

public enum Blake2b {

    static final int HASH_BLAKE2B_256_BYTES = 32;
    static final int HASH_BLAKE2B_512_BYTES = 64;

    public static BytesStore hash256(BytesStore message) {
        return Blake2b.hash256(null, message);
    }

    public static BytesStore hash256(BytesStore result, BytesStore message) {
        result = Sodium.Util.setSize(result, 32L);
        Sodium.checkValid(Sodium.SODIUM.crypto_generichash(result.addressForWrite(0L), 32, message.addressForRead(message.readPosition()), Maths.toUInt31((long)message.readRemaining()), 0L, 0), "couldn't Blake2b");
        return result;
    }

    public static void append256(Bytes<?> hashGeneric, BytesStore<?, ?> message) {
        long wp = hashGeneric.writePosition();
        hashGeneric.ensureCapacity(wp + 32L);
        Sodium.checkValid(Sodium.SODIUM.crypto_generichash(hashGeneric.addressForWrite(wp), 32, message.addressForRead(message.readPosition()), Maths.toUInt31((long)message.readRemaining()), 0L, 0), "couldn't Blake2b");
        hashGeneric.writeSkip(32L);
    }

    public static BytesStore hash512(BytesStore message) {
        return Blake2b.hash512(null, message);
    }

    public static BytesStore hash512(BytesStore result, BytesStore message) {
        result = Sodium.Util.setSize(result, 64L);
        Sodium.checkValid(Sodium.SODIUM.crypto_generichash(result.addressForWrite(0L), 64, message.addressForRead(message.readPosition()), Maths.toUInt31((long)message.readRemaining()), 0L, 0), "couldn't Blake2b");
        return result;
    }

    public static void append512(Bytes<?> hashGeneric, BytesStore<?, ?> message) {
        long wp = hashGeneric.writePosition();
        hashGeneric.ensureCapacity(wp + 64L);
        Sodium.checkValid(Sodium.SODIUM.crypto_generichash(hashGeneric.addressForWrite(wp), 64, message.addressForRead(message.readPosition()), Maths.toUInt31((long)message.readRemaining()), 0L, 0), "couldn't Blake2b");
        hashGeneric.writeSkip(64L);
    }

    public static class MultiPart512 {
        public final BytesStore state = Bytes.allocateDirect((long)384L);

        public MultiPart512() {
            ((Bytes)this.state).readLimit(384L);
            Sodium.SODIUM.crypto_generichash_init(this.state.addressForRead(0L), 0L, 0, 64);
        }

        public void reset() {
            Sodium.checkValid(Sodium.SODIUM.crypto_generichash_init(this.state.addressForRead(0L), 0L, 0, 64), "couldn't reset Blake2b");
        }

        public void add(BytesStore message) {
            Sodium.checkValid(Sodium.SODIUM.crypto_generichash_update(this.state.addressForRead(0L), message.addressForRead(message.readPosition()), message.readRemaining()), "Failed to add to multi-part message");
        }

        public BytesStore hash() {
            return this.hash(null);
        }

        public BytesStore hash(BytesStore result) {
            result = Sodium.Util.setSize(result, 64L);
            Sodium.checkValid(Sodium.SODIUM.crypto_generichash_final(this.state.addressForRead(0L), result.addressForWrite(0L), 64L), "Multi-part Blake2b failed");
            return result;
        }
    }

    public static class MultiPart256 {
        public final BytesStore state = Bytes.allocateDirect((long)384L);

        public MultiPart256() {
            ((Bytes)this.state).readLimit(384L);
            Sodium.SODIUM.crypto_generichash_init(this.state.addressForRead(0L), 0L, 0, 32);
        }

        public void reset() {
            Sodium.checkValid(Sodium.SODIUM.crypto_generichash_init(this.state.addressForRead(0L), 0L, 0, 32), "couldn't reset Blake2b");
        }

        public void add(BytesStore message) {
            Sodium.checkValid(Sodium.SODIUM.crypto_generichash_update(this.state.addressForRead(0L), message.addressForRead(message.readPosition()), message.readRemaining()), "Failed to add to multi-part message");
        }

        public BytesStore hash() {
            return this.hash(null);
        }

        public BytesStore hash(BytesStore result) {
            result = Sodium.Util.setSize(result, 32L);
            Sodium.checkValid(Sodium.SODIUM.crypto_generichash_final(this.state.addressForRead(0L), result.addressForWrite(0L), 32L), "Multi-part Blake2b failed");
            return result;
        }
    }
}

