/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.creator.internal;

import java.util.Objects;
import java.util.stream.Collectors;
import net.openhft.chronicle.releasenotes.creator.ReleaseNoteCreator;
import net.openhft.chronicle.releasenotes.creator.internal.util.MarkdownUtil;
import net.openhft.chronicle.releasenotes.model.AggregatedReleaseNotes;
import net.openhft.chronicle.releasenotes.model.Issue;
import net.openhft.chronicle.releasenotes.model.ReleaseNotes;

public final class MarkdownReleaseNoteCreator
implements ReleaseNoteCreator {
    private static final String DEFAULT_LABEL = "closed";
    private static final String MISSING_CHANGELOG = "No changelog for this release.";
    private static final String NEW_LINE = System.lineSeparator();

    @Override
    public String formatReleaseNotes(ReleaseNotes releaseNotes) {
        Objects.requireNonNull(releaseNotes);
        if (releaseNotes.getIssues().size() == 0) {
            return MarkdownUtil.italic(MISSING_CHANGELOG) + NEW_LINE;
        }
        StringBuilder body = new StringBuilder();
        releaseNotes.getIssues().stream().sorted(Issue.compareByLabel((String)DEFAULT_LABEL)).collect(Collectors.toList()).forEach(issue -> {
            body.append(MarkdownUtil.entry(this.label(MarkdownUtil.bold(issue.getLabels().stream().findFirst().orElse(DEFAULT_LABEL))))).append(String.format(" %s [#%d](%s)", issue.getTitle(), issue.getNumber(), issue.getUrl()));
            issue.getComment().ifPresent(comment -> body.append(String.format(" - %s", comment)));
            body.append(NEW_LINE);
        });
        return body.toString();
    }

    @Override
    public String formatAggregatedReleaseNotes(AggregatedReleaseNotes releaseNotes) {
        Objects.requireNonNull(releaseNotes);
        StringBuilder body = new StringBuilder();
        releaseNotes.getReleases().forEach(releaseNote -> body.append(MarkdownUtil.header(MarkdownUtil.bold(releaseNote.getTitle()), 3)).append(NEW_LINE).append(this.formatReleaseNotes((ReleaseNotes)releaseNote)).append(NEW_LINE));
        return body.toString();
    }

    private String label(String text) {
        return "[" + text + "]";
    }
}

