/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.creator.internal.util;

import java.util.Objects;

public final class MarkdownUtil {
    private MarkdownUtil() {
    }

    public static String header(String text, int size) {
        Objects.requireNonNull(text);
        if (size < 1) {
            throw new RuntimeException(String.format("Invalid header size %d (minimum size = 1)", size));
        }
        if (size > 6) {
            throw new RuntimeException(String.format("Invalid header size %d (maximum size = 6)", size));
        }
        StringBuilder headerBuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            headerBuilder.append("#");
        }
        headerBuilder.append(" ").append(text);
        return headerBuilder.toString();
    }

    public static String bold(String text) {
        Objects.requireNonNull(text);
        return "**" + text + "**";
    }

    public static String italic(String text) {
        Objects.requireNonNull(text);
        return "*" + text + "*";
    }

    public static String entry(String entry) {
        Objects.requireNonNull(entry);
        return "- " + entry;
    }

    public static String link(String placeholder, String link) {
        Objects.requireNonNull(placeholder);
        Objects.requireNonNull(link);
        return String.format("[%s](%s)", placeholder, link);
    }
}

