/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.connector;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.openhft.chronicle.releasenotes.connector.Connector;
import net.openhft.chronicle.releasenotes.model.ReleaseNote;

public interface ReleaseConnector
extends Connector {
    public ReleaseResult createReleaseFromBranch(String var1, String var2, String var3, List<String> var4, boolean var5);

    default public ReleaseResult createReleaseFromBranch(String repository, String tag, String branch, List<String> ignoredLabels) {
        return this.createReleaseFromBranch(repository, tag, branch, ignoredLabels, false);
    }

    public ReleaseResult createReleaseFromBranch(String var1, String var2, String var3, String var4, List<String> var5, boolean var6);

    default public ReleaseResult createReleaseFromBranch(String repository, String tag, String endTag, String branch, List<String> ignoredLabels) {
        return this.createReleaseFromBranch(repository, tag, endTag, branch, ignoredLabels, false);
    }

    public ReleaseResult createReleaseFromMilestone(String var1, String var2, String var3, List<String> var4, boolean var5);

    default public ReleaseResult createReleaseFromMilestone(String repository, String tag, String milestone, List<String> ignoredLabels) {
        return this.createReleaseFromMilestone(repository, tag, milestone, ignoredLabels, false);
    }

    public ReleaseResult createAggregatedRelease(String var1, String var2, Map<String, List<String>> var3, boolean var4);

    default public ReleaseResult createAggregatedRelease(String repository, String tag, Map<String, List<String>> releases) {
        return this.createAggregatedRelease(repository, tag, releases, false);
    }

    public ReleaseResult createAggregatedRelease(String var1, String var2, List<ReleaseNote> var3, boolean var4);

    default public ReleaseResult createAggregatedRelease(String repository, String tag, List<ReleaseNote> releaseNotes) {
        return this.createAggregatedRelease(repository, tag, releaseNotes, false);
    }

    public static class ReleaseResult {
        private final ReleaseNote releaseNote;
        private final URL releaseUrl;
        private final RuntimeException error;

        private ReleaseResult(ReleaseNote releaseNote, URL releaseUrl, RuntimeException error) {
            this.releaseNote = releaseNote;
            this.releaseUrl = releaseUrl;
            this.error = error;
        }

        public ReleaseNote getReleaseNote() {
            return this.releaseNote;
        }

        public URL getReleaseUrl() {
            return this.releaseUrl;
        }

        public RuntimeException getError() {
            return this.error;
        }

        public void throwIfFail() {
            if (this.isFail()) {
                throw this.error;
            }
        }

        public boolean isSuccess() {
            return this.error == null;
        }

        public boolean isFail() {
            return !this.isSuccess();
        }

        public static ReleaseResult success(ReleaseNote releaseNote, URL url) {
            Objects.requireNonNull(url);
            return new ReleaseResult(releaseNote, url, null);
        }

        public static ReleaseResult fail(RuntimeException error) {
            return new ReleaseResult(null, null, error);
        }
    }
}

