/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.connector;

import java.util.Objects;
import java.util.Set;
import net.openhft.chronicle.releasenotes.connector.Connector;

public interface MigrateConnector
extends Connector {
    public MigrateResult migrateMilestones(String var1, Set<String> var2, String var3, Set<String> var4);

    public static class MigrateResult {
        private final RuntimeException error;

        private MigrateResult(RuntimeException error) {
            this.error = error;
        }

        public RuntimeException getError() {
            return this.error;
        }

        public void throwIfFail() {
            if (this.isFail()) {
                throw this.error;
            }
        }

        public boolean isSuccess() {
            return this.error == null;
        }

        public boolean isFail() {
            return !this.isSuccess();
        }

        public static MigrateResult success() {
            return new MigrateResult(null);
        }

        public static MigrateResult fail(RuntimeException error) {
            Objects.requireNonNull(error);
            return new MigrateResult(error);
        }
    }
}

