/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import java.util.List;
import java.util.regex.Pattern;
import net.openhft.chronicle.queue.reader.MessageConsumer;

public final class PatternFilterMessageConsumer
implements MessageConsumer {
    private final List<Pattern> patterns;
    private final boolean shouldBePresent;
    private final MessageConsumer nextMessageConsumer;

    public PatternFilterMessageConsumer(List<Pattern> patterns, boolean shouldBePresent, MessageConsumer nextMessageConsumer) {
        this.patterns = patterns;
        this.shouldBePresent = shouldBePresent;
        this.nextMessageConsumer = nextMessageConsumer;
    }

    @Override
    public boolean consume(long index, String message) {
        for (Pattern pattern : this.patterns) {
            if (this.shouldBePresent == pattern.matcher(message).find()) continue;
            return false;
        }
        return this.nextMessageConsumer.consume(index, message);
    }
}

