/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.rollcycles;

import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.rollcycles.RollCycleArithmetic;

public enum LegacyRollCycles implements RollCycle
{
    MINUTELY("yyyyMMdd-HHmm", 60000, 2048, 16),
    HOURLY("yyyyMMdd-HH", 3600000, 4096, 16),
    DAILY("yyyyMMdd", 86400000, 8192, 64);

    private final String format;
    private final int lengthInMillis;
    private final RollCycleArithmetic arithmetic;

    private LegacyRollCycles(String format, int lengthInMillis, int indexCount, int indexSpacing) {
        this.format = format;
        this.lengthInMillis = lengthInMillis;
        this.arithmetic = RollCycleArithmetic.of(indexCount, indexSpacing);
    }

    @Override
    public long maxMessagesPerCycle() {
        return this.arithmetic.maxMessagesPerCycle();
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public int lengthInMillis() {
        return this.lengthInMillis;
    }

    @Override
    public int defaultIndexCount() {
        return this.arithmetic.indexCount();
    }

    @Override
    public int defaultIndexSpacing() {
        return this.arithmetic.indexSpacing();
    }

    @Override
    public long toIndex(int cycle, long sequenceNumber) {
        return this.arithmetic.toIndex(cycle, sequenceNumber);
    }

    @Override
    public long toSequenceNumber(long index) {
        return this.arithmetic.toSequenceNumber(index);
    }

    @Override
    public int toCycle(long index) {
        return this.arithmetic.toCycle(index);
    }
}

