/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.util;

import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.util.PretoucherFactory;
import org.jetbrains.annotations.NotNull;

public final class PretouchUtil {
    private static final PretoucherFactory INSTANCE;

    public static EventHandler createEventHandler(@NotNull SingleChronicleQueue queue) {
        if (queue == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'queue') of net/openhft/chronicle/queue/util/PretouchUtil.createEventHandler must not be null");
        }
        if (queue == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'queue') of net/openhft/chronicle/queue/util/PretouchUtil.createEventHandler must not be null");
        }
        return INSTANCE.createEventHandler(queue);
    }

    public static Pretoucher createPretoucher(@NotNull SingleChronicleQueue queue) {
        if (queue == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'queue') of net/openhft/chronicle/queue/util/PretouchUtil.createPretoucher must not be null");
        }
        if (queue == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'queue') of net/openhft/chronicle/queue/util/PretouchUtil.createPretoucher must not be null");
        }
        return INSTANCE.createPretoucher(queue);
    }

    static {
        PretoucherFactory instance;
        try {
            Class<?> clazz = Class.forName("software.chronicle.enterprise.queue.pretoucher.EnterprisePretouchUtil");
            instance = (PretoucherFactory)ObjectUtils.newInstance(clazz);
            assert (SingleChronicleQueueBuilder.areEnterpriseFeaturesAvailable());
        }
        catch (Exception e) {
            instance = new PretouchFactoryEmpty();
            SingleChronicleQueueBuilder.onlyAvailableInEnterprise("Pretoucher");
        }
        INSTANCE = instance;
    }

    private static class PretouchFactoryEmpty
    implements PretoucherFactory {
        private PretouchFactoryEmpty() {
        }

        @Override
        public EventHandler createEventHandler(@NotNull SingleChronicleQueue queue) {
            if (queue == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'queue') of net/openhft/chronicle/queue/util/PretouchUtil$PretouchFactoryEmpty.createEventHandler must not be null");
            }
            if (queue == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'queue') of net/openhft/chronicle/queue/util/PretouchUtil$PretouchFactoryEmpty.createEventHandler must not be null");
            }
            return () -> false;
        }

        @Override
        public Pretoucher createPretoucher(@NotNull SingleChronicleQueue queue) {
            if (queue == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'queue') of net/openhft/chronicle/queue/util/PretouchUtil$PretouchFactoryEmpty.createPretoucher must not be null");
            }
            if (queue == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'queue') of net/openhft/chronicle/queue/util/PretouchUtil$PretouchFactoryEmpty.createPretoucher must not be null");
            }
            return new EmptyPretoucher();
        }

        private static class EmptyPretoucher
        implements Pretoucher {
            private EmptyPretoucher() {
            }

            @Override
            public void execute() throws InvalidEventHandlerException {
            }

            @Override
            public void close() {
            }
        }
    }
}

