/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.util.Builder;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.queue.impl.table.SingleTableStore;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class SingleTableBuilder<T extends Metadata>
implements Builder<TableStore<T>> {
    @NotNull
    private final File file;
    @NotNull
    private final T metadata;
    private WireType wireType;
    private boolean readOnly;

    private SingleTableBuilder(@NotNull File path, @NotNull T metadata) {
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.<init> must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.<init> must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.<init> must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.<init> must not be null");
        }
        this.file = path;
        this.metadata = metadata;
    }

    @NotNull
    public static <T extends Metadata> SingleTableBuilder<T> builder(@NotNull File file, @NotNull WireType wireType, @NotNull T metadata) {
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.builder must not be null");
        }
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'wireType') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.builder must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.builder must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.builder must not be null");
        }
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'wireType') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.builder must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.builder must not be null");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Tables should be configured with the table file, not a directory. Actual file used: " + file.getParentFile());
        }
        if (!file.getName().endsWith(".cq4t")) {
            throw new IllegalArgumentException("Invalid file type: " + file.getName());
        }
        SingleTableBuilder<T> singleTableBuilder = new SingleTableBuilder<T>(file, metadata).wireType(wireType);
        if (singleTableBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.builder must not return null");
        }
        if (singleTableBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.builder must not return null");
        }
        return singleTableBuilder;
    }

    @NotNull
    public static <T extends Metadata> SingleTableBuilder<T> binary(@NotNull Path path, @NotNull T metadata) {
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        SingleTableBuilder<T> singleTableBuilder = SingleTableBuilder.binary(path.toFile(), metadata);
        if (singleTableBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not return null");
        }
        if (singleTableBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not return null");
        }
        return singleTableBuilder;
    }

    @NotNull
    public static <T extends Metadata> SingleTableBuilder<T> binary(@NotNull String file, @NotNull T metadata) {
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        SingleTableBuilder<T> singleTableBuilder = SingleTableBuilder.binary(new File(file), metadata);
        if (singleTableBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not return null");
        }
        if (singleTableBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not return null");
        }
        return singleTableBuilder;
    }

    @NotNull
    public static <T extends Metadata> SingleTableBuilder<T> binary(@NotNull File basePathFile, @NotNull T metadata) {
        if (basePathFile == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'basePathFile') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        if (basePathFile == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'basePathFile') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not be null");
        }
        SingleTableBuilder<T> singleTableBuilder = SingleTableBuilder.builder(basePathFile, WireType.BINARY_LIGHT, metadata);
        if (singleTableBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not return null");
        }
        if (singleTableBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.binary must not return null");
        }
        return singleTableBuilder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public TableStore<T> build() {
        TableStore tableStore;
        MappedBytes bytes;
        block19: {
            TableStore tableStore2;
            block18: {
                if (this.readOnly) {
                    if (!this.file.exists()) {
                        throw new IORuntimeException("Metadata file not found in readOnly mode");
                    }
                    TimingPauser pauser = Pauser.balanced();
                    try {
                        while (this.file.length() < OS.mapAlignment()) {
                            pauser.pause(1L, TimeUnit.SECONDS);
                        }
                    }
                    catch (TimeoutException e) {
                        throw new IORuntimeException("Metadata file found in readOnly mode, but not initialized yet");
                    }
                }
                bytes = null;
                try {
                    if (!this.readOnly && this.file.createNewFile() && !this.file.canWrite()) {
                        throw new IllegalStateException("Cannot write to tablestore file " + this.file);
                    }
                    bytes = MappedBytes.mappedBytes((File)this.file, (long)65536L, (long)65536L, (boolean)this.readOnly);
                    bytes.singleThreadedCheckDisabled(true);
                    bytes.readVolatileInt(0L);
                    Wire wire = (Wire)this.wireType.apply((Object)bytes);
                    if (this.readOnly) {
                        TableStore tableStore3 = SingleTableStore.doWithSharedLock(this.file, v -> {
                            try {
                                return this.readTableStore(wire);
                            }
                            catch (IOException ex) {
                                throw Jvm.rethrow((Throwable)ex);
                            }
                        }, () -> null);
                        tableStore2 = tableStore3;
                        break block18;
                    }
                    MappedBytes finalBytes = bytes;
                    TableStore tableStore4 = SingleTableStore.doWithExclusiveLock(this.file, v -> {
                        try {
                            if (wire.writeFirstHeader()) {
                                return this.writeTableStore(finalBytes, wire);
                            }
                            return this.readTableStore(wire);
                        }
                        catch (IOException ex) {
                            throw Jvm.rethrow((Throwable)ex);
                        }
                    }, () -> null);
                    tableStore = tableStore4;
                    break block19;
                }
                catch (IOException e) {
                    throw new IORuntimeException("file=" + this.file.getAbsolutePath(), (Throwable)e);
                }
            }
            if (tableStore2 == null) {
                throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.build must not return null");
            }
            if (tableStore2 == null) {
                throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.build must not return null");
            }
            return tableStore2;
        }
        if (tableStore == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.build must not return null");
        }
        if (tableStore == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.build must not return null");
        }
        return tableStore;
        finally {
            if (bytes != null) {
                bytes.singleThreadedCheckReset();
            }
        }
    }

    @NotNull
    private TableStore<T> readTableStore(Wire wire) throws StreamCorruptedException {
        wire.readFirstHeader();
        ValueIn valueIn = this.readTableStoreValue(wire);
        @NotNull TableStore existing = (TableStore)Objects.requireNonNull(valueIn.typedMarshallable());
        this.metadata.overrideFrom(existing.metadata());
        TableStore tableStore = existing;
        if (tableStore == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.readTableStore must not return null");
        }
        if (tableStore == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.readTableStore must not return null");
        }
        return tableStore;
    }

    private ValueIn readTableStoreValue(@NotNull Wire wire) throws StreamCorruptedException {
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.readTableStoreValue must not be null");
        }
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/table/SingleTableBuilder.readTableStoreValue must not be null");
        }
        try (ScopedResource stlSb = Wires.acquireStringBuilderScoped();){
            StringBuilder name = (StringBuilder)stlSb.get();
            ValueIn valueIn = wire.readEventName(name);
            if (!StringUtils.isEqual((StringBuilder)name, (CharSequence)MetaDataKeys.header.name())) {
                throw new StreamCorruptedException("The first message should be the header, was " + name);
            }
            ValueIn valueIn2 = valueIn;
            return valueIn2;
        }
    }

    @NotNull
    private TableStore<T> writeTableStore(MappedBytes bytes, Wire wire) {
        SingleTableStore<T> store = new SingleTableStore<T>(this.wireType, bytes, this.metadata);
        wire.writeEventName((CharSequence)"header").object(store);
        wire.updateFirstHeader();
        SingleTableStore<T> singleTableStore = store;
        if (singleTableStore == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.writeTableStore must not return null");
        }
        if (singleTableStore == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.writeTableStore must not return null");
        }
        return singleTableStore;
    }

    @Deprecated
    @NotNull
    public SingleTableBuilder<T> clone() {
        SingleTableBuilder singleTableBuilder;
        try {
            SingleTableBuilder clone;
            singleTableBuilder = clone = (SingleTableBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        if (singleTableBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.clone must not return null");
        }
        if (singleTableBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.clone must not return null");
        }
        return singleTableBuilder;
    }

    @NotNull
    public File file() {
        File file = this.file;
        if (file == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.file must not return null");
        }
        if (file == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableBuilder.file must not return null");
        }
        return file;
    }

    public WireType wireType() {
        return this.wireType;
    }

    public SingleTableBuilder<T> wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public SingleTableBuilder<T> readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{WireType.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleTableStore.class, "STStore");
    }
}

