/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.BufferOverflowException;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.threads.InterruptedRuntimeException;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueSystemProperties;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.single.IndexNotAvailableException;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.MicroToucher;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.queue.impl.table.AbstractTSQueueLock;
import net.openhft.chronicle.queue.util.MicroTouched;
import net.openhft.chronicle.queue.util.PretouchUtil;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StoreAppender
extends AbstractCloseable
implements ExcerptAppender,
ExcerptContext,
InternalAppender,
MicroTouched {
    @NotNull
    private final SingleChronicleQueue queue;
    @NotNull
    private final WriteLock writeLock;
    private final WriteLock appendLock;
    @NotNull
    private final StoreAppenderContext context;
    private final WireStorePool storePool;
    private final boolean checkInterrupts;
    @UsedViaReflection
    private final Finalizer finalizer;
    @Nullable
    SingleChronicleQueueStore store;
    long lastPosition;
    private int cycle = Integer.MIN_VALUE;
    @Nullable
    private Wire wire;
    @Nullable
    private Wire wireForIndex;
    private long positionOfHeader = 0L;
    private long lastIndex = Long.MIN_VALUE;
    @Nullable
    private Pretoucher pretoucher = null;
    private MicroToucher microtoucher = null;
    private Wire bufferWire = null;
    private int count = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoreAppender(@NotNull SingleChronicleQueue queue, @NotNull WireStorePool storePool, boolean checkInterrupts) {
        this.queue = queue;
        this.storePool = storePool;
        this.checkInterrupts = checkInterrupts;
        this.writeLock = queue.writeLock();
        this.appendLock = queue.appendLock();
        this.context = new StoreAppenderContext();
        this.finalizer = Jvm.isResourceTracing() ? new Finalizer() : null;
        try {
            int lastExistingCycle = queue.lastCycle();
            int firstCycle = queue.firstCycle();
            long start = System.nanoTime();
            WriteLock writeLock = this.queue.writeLock();
            writeLock.lock();
            try {
                if (firstCycle != Integer.MAX_VALUE) {
                    for (int eofCycle = lastExistingCycle; eofCycle >= firstCycle; --eofCycle) {
                        this.setCycle2(eofCycle, false);
                        if (!this.cycleHasEOF()) continue;
                        if (eofCycle > firstCycle) {
                            this.normaliseEOFs0(eofCycle - 1);
                        }
                        if (eofCycle >= lastExistingCycle) break;
                        this.setCycle2(eofCycle + 1, false);
                        break;
                    }
                    if (this.wire != null) {
                        this.resetPosition(false);
                    }
                }
            }
            finally {
                writeLock.unlock();
                long tookMillis = (System.nanoTime() - start) / 1000000L;
                if (tookMillis > (long)SingleChronicleQueue.WARN_SLOW_APPENDER_MS || lastExistingCycle >= 0 && this.cycle != lastExistingCycle) {
                    Jvm.perf().on(this.getClass(), "Took " + tookMillis + "ms to find first open cycle " + this.cycle);
                }
            }
        }
        catch (RuntimeException ex) {
            this.close();
            throw ex;
        }
        queue.addCloseListener(this);
    }

    private boolean cycleHasEOF() {
        if (this.wire != null) {
            assert (this.queue.writeLock().locked());
            assert (this.store != null);
            if (this.wire.bytes().tryReserve((ReferenceOwner)this)) {
                try {
                    boolean bl = WireOut.EndOfWire.PRESENT == this.wire.endOfWire(false, this.timeoutMS(), TimeUnit.MILLISECONDS, this.store.writePosition());
                    return bl;
                }
                finally {
                    this.wire.bytes().release((ReferenceOwner)this);
                }
            }
        }
        return false;
    }

    private static void releaseBytesFor(Wire w) {
        if (w != null) {
            w.bytes().release(INIT);
        }
    }

    private void checkAppendLock() {
        this.checkAppendLock(false);
    }

    private void checkAppendLock(boolean allowMyProcess) {
        if (this.appendLock.locked()) {
            this.checkAppendLockLocked(allowMyProcess);
        }
    }

    private void checkAppendLockLocked(boolean allowMyProcess) {
        if (this.appendLock instanceof AbstractTSQueueLock) {
            boolean myPID;
            AbstractTSQueueLock appendLock = (AbstractTSQueueLock)((Object)this.appendLock);
            long lockedBy = appendLock.lockedBy();
            if (lockedBy == Long.MIN_VALUE) {
                return;
            }
            boolean bl = myPID = lockedBy == (long)Jvm.getProcessId();
            if (allowMyProcess && myPID) {
                return;
            }
            throw new IllegalStateException("locked: unable to append because a lock is being held by pid=" + (myPID ? "me" : Long.valueOf(lockedBy)) + ", file=" + this.queue.file());
        }
        throw new IllegalStateException("locked: unable to append, file=" + this.queue.file());
    }

    public void writeBytes(@NotNull WriteBytesMarshallable marshallable) {
        this.throwExceptionIfClosed();
        try (DocumentContext dc = this.writingDocument();){
            Bytes bytes = dc.wire().bytes();
            long wp = bytes.writePosition();
            marshallable.writeMarshallable((BytesOut)bytes);
            if (wp == bytes.writePosition()) {
                dc.rollbackOnClose();
            }
        }
    }

    protected void performClose() {
        StoreAppender.releaseBytesFor(this.wireForIndex);
        StoreAppender.releaseBytesFor(this.wire);
        StoreAppender.releaseBytesFor(this.bufferWire);
        if (this.pretoucher != null) {
            this.pretoucher.close();
        }
        if (this.store != null) {
            this.storePool.closeStore(this.store);
            this.store = null;
        }
        this.storePool.close();
        this.pretoucher = null;
        this.wireForIndex = null;
        this.wire = null;
        this.bufferWire = null;
    }

    @Override
    public void pretouch() {
        this.throwExceptionIfClosed();
        try {
            if (this.pretoucher == null) {
                this.pretoucher = PretouchUtil.createPretoucher(this.queue());
            }
            this.pretoucher.execute();
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    public boolean microTouch() {
        this.throwExceptionIfClosed();
        if (this.microtoucher == null) {
            this.microtoucher = new MicroToucher(this);
        }
        return this.microtoucher.execute();
    }

    @Override
    public void bgMicroTouch() {
        if (this.isClosed()) {
            throw new ClosedIllegalStateException(this.getClass().getName() + " closed for " + Thread.currentThread().getName(), (Throwable)this.closedHere);
        }
        if (this.microtoucher == null) {
            this.microtoucher = new MicroToucher(this);
        }
        this.microtoucher.bgExecute();
    }

    @Override
    @Nullable
    public Wire wire() {
        return this.wire;
    }

    @Override
    @Nullable
    public Wire wireForIndex() {
        return this.wireForIndex;
    }

    @Override
    public long timeoutMS() {
        return this.queue.timeoutMS;
    }

    void lastIndex(long index) {
        this.lastIndex = index;
    }

    public boolean recordHistory() {
        return this.sourceId() != 0;
    }

    void setCycle(int cycle) {
        if (cycle != this.cycle) {
            this.setCycle2(cycle, true);
        }
    }

    private void setCycle2(int cycle, boolean createIfAbsent) {
        this.queue.throwExceptionIfClosed();
        if (cycle < 0) {
            throw new IllegalArgumentException("You can not have a cycle that starts before Epoch. cycle=" + cycle);
        }
        SingleChronicleQueue queue = this.queue;
        SingleChronicleQueueStore oldStore = this.store;
        SingleChronicleQueueStore newStore = this.storePool.acquire(cycle, createIfAbsent, oldStore);
        if (newStore != oldStore) {
            this.store = newStore;
            if (oldStore != null) {
                this.storePool.closeStore(oldStore);
            }
        }
        this.resetWires(queue);
        this.cycle = cycle;
        if (this.store == null) {
            return;
        }
        this.wire.parent((Object)this);
        this.wire.pauser((Pauser)queue.pauserSupplier.get());
        this.resetPosition(false);
        queue.onRoll(cycle);
    }

    private void resetWires(@NotNull ChronicleQueue queue) {
        WireType wireType = queue.wireType();
        Wire oldw = this.wire;
        Wire wire = this.wire = this.store == null ? null : this.createWire(wireType);
        assert (this.wire != oldw || this.wire == null);
        StoreAppender.releaseBytesFor(oldw);
        Wire old = this.wireForIndex;
        Wire wire2 = this.wireForIndex = this.store == null ? null : this.createWire(wireType);
        assert (this.wireForIndex != old || this.wireForIndex == null);
        StoreAppender.releaseBytesFor(old);
    }

    private Wire createWire(@NotNull WireType wireType) {
        Wire w = (Wire)wireType.apply((Object)this.store.bytes());
        w.usePadding(this.store.dataVersion() > 0);
        return w;
    }

    private boolean resetPosition(boolean exact) {
        long originalHeaderNumber = this.wire.headerNumber();
        try {
            if (this.store == null || this.wire == null) {
                return false;
            }
            long position = this.store.writePosition();
            this.position(position, position);
            Bytes bytes = this.wire.bytes();
            assert (!QueueSystemProperties.CHECK_INDEX || this.checkPositionOfHeader(bytes));
            long lastSequenceNumber = exact ? this.store.exactLastSequenceNumber(this) : this.store.approximateLastSequenceNumber(this);
            this.wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, lastSequenceNumber + 1L) - 1L);
            assert (!QueueSystemProperties.CHECK_INDEX || this.wire.headerNumber() != -1L || this.checkIndex(this.wire.headerNumber(), this.positionOfHeader));
            bytes.writeLimit(bytes.capacity());
            assert (!QueueSystemProperties.CHECK_INDEX || this.checkWritePositionHeaderNumber());
            return originalHeaderNumber != this.wire.headerNumber();
        }
        catch (StreamCorruptedException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    private boolean checkPositionOfHeader(Bytes<?> bytes) {
        if (this.positionOfHeader == 0L) {
            return true;
        }
        int header = bytes.readVolatileInt(this.positionOfHeader);
        return Wires.isReadyData((int)header) || Wires.isReadyMetaData((int)header) || Wires.isNotComplete((int)header);
    }

    @NotNull
    public DocumentContext writingDocument() {
        return this.writingDocument(false);
    }

    @NotNull
    public DocumentContext writingDocument(boolean metaData) {
        this.throwExceptionIfClosed();
        this.checkAppendLock(metaData);
        ++this.count;
        try {
            return this.prepareAndReturnWriteContext(metaData);
        }
        catch (RuntimeException e) {
            --this.count;
            throw e;
        }
    }

    private StoreAppenderContext prepareAndReturnWriteContext(boolean metaData) {
        if (this.count > 1) {
            assert (metaData == this.context.metaData);
            return this.context;
        }
        if (this.queue.doubleBuffer && this.writeLock.locked() && !metaData) {
            this.context.isClosed = false;
            this.context.rollbackOnClose = false;
            this.context.buffered = true;
            if (this.bufferWire == null) {
                OnHeapBytes bufferBytes = Bytes.allocateElasticOnHeap();
                this.bufferWire = (Wire)this.queue().wireType().apply((Object)bufferBytes);
            }
            this.context.wire = this.bufferWire;
            this.context.metaData(false);
        } else {
            this.writeLock.lock();
            int cycle = this.queue.cycle();
            if (this.wire == null) {
                this.setWireIfNull(cycle);
            }
            if (this.cycle != cycle) {
                this.rollCycleTo(cycle);
            }
            long safeLength = this.queue.overlapSize();
            this.resetPosition(false);
            assert (!QueueSystemProperties.CHECK_INDEX || this.checkWritePositionHeaderNumber());
            this.openContext(metaData, safeLength);
            this.wire.bytes().readPosition(this.wire.bytes().writePosition());
        }
        return this.context;
    }

    public DocumentContext acquireWritingDocument(boolean metaData) {
        if (!DISABLE_THREAD_SAFETY) {
            this.threadSafetyCheck(true);
        }
        if (this.context.wire != null && this.context.isOpen() && this.context.chainedElement()) {
            return this.context;
        }
        return this.writingDocument(metaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void normaliseEOFs() {
        long start = System.nanoTime();
        WriteLock writeLock = this.queue.writeLock();
        writeLock.lock();
        try {
            this.normaliseEOFs0(this.cycle);
        }
        finally {
            writeLock.unlock();
            long tookMillis = (System.nanoTime() - start) / 1000000L;
            if (tookMillis > (long)SingleChronicleQueue.WARN_SLOW_APPENDER_MS) {
                Jvm.perf().on(this.getClass(), "Took " + tookMillis + "ms to normaliseEOFs");
            }
        }
    }

    private void normaliseEOFs0(int cycle) {
        int first = this.queue.firstCycle();
        if (first == Integer.MAX_VALUE) {
            return;
        }
        for (int eofCycle = first; eofCycle < Math.min(this.queue.cycle(), cycle); ++eofCycle) {
            this.setCycle2(eofCycle, false);
            if (this.wire == null) continue;
            assert (this.queue.writeLock().locked());
            this.store.writeEOF(this.wire, this.timeoutMS());
        }
    }

    private void setWireIfNull(int cycle) {
        this.normaliseEOFs0(cycle);
        this.setCycle2(cycle, true);
    }

    private long writeHeader(@NotNull Wire wire, long safeLength) {
        Bytes bytes = wire.bytes();
        long pos = this.positionOfHeader;
        long lastPos = this.store.writePosition();
        if (pos < lastPos) {
            try {
                wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, this.store.lastSequenceNumber(this)));
            }
            catch (StreamCorruptedException ex) {
                Jvm.warn().on(this.getClass(), "Couldn't find last sequence", (Throwable)ex);
            }
        }
        int header = bytes.readVolatileInt(lastPos);
        assert (header != 0);
        lastPos += (long)(Wires.lengthOf((int)bytes.readVolatileInt(lastPos)) + 4);
        bytes.writePosition(lastPos);
        return wire.enterHeader(safeLength);
    }

    private void openContext(boolean metaData, long safeLength) {
        assert (this.wire != null);
        this.positionOfHeader = this.writeHeader(this.wire, safeLength);
        this.context.isClosed = false;
        this.context.rollbackOnClose = false;
        this.context.buffered = false;
        this.context.wire = this.wire;
        this.context.metaData(metaData);
    }

    boolean checkWritePositionHeaderNumber() {
        if (this.wire == null || this.wire.headerNumber() == Long.MIN_VALUE) {
            return true;
        }
        try {
            long pos = this.positionOfHeader;
            long seq1 = this.queue.rollCycle().toSequenceNumber(this.wire.headerNumber() + 1L) - 1L;
            long seq2 = this.store.sequenceForPosition(this, pos, true);
            if (seq1 != seq2) {
                String message = "~~~~~~~~~~~~~~ thread: " + Thread.currentThread().getName() + " pos: " + pos + " header: " + this.wire.headerNumber() + " seq1: " + seq1 + " seq2: " + seq2;
                AssertionError ae = new AssertionError((Object)message);
                throw ae;
            }
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), (Throwable)e);
            throw Jvm.rethrow((Throwable)e);
        }
        return true;
    }

    @Override
    public int sourceId() {
        return this.queue.sourceId;
    }

    @Override
    public void writeBytes(@NotNull BytesStore bytes) {
        this.throwExceptionIfClosed();
        this.checkAppendLock();
        this.writeLock.lock();
        try {
            int cycle = this.queue.cycle();
            if (this.wire == null) {
                this.setWireIfNull(cycle);
            }
            if (this.cycle != cycle) {
                this.rollCycleTo(cycle);
            }
            this.positionOfHeader = this.writeHeader(this.wire, (int)this.queue.overlapSize());
            assert (((AbstractWire)this.wire).isInsideHeader());
            this.beforeAppend(this.wire, this.wire.headerNumber() + 1L);
            Bytes wireBytes = this.wire.bytes();
            wireBytes.write(bytes);
            this.wire.updateHeader(this.positionOfHeader, false, 0);
            this.lastIndex(this.wire.headerNumber());
            this.lastPosition = this.positionOfHeader;
            this.store.writePosition(this.positionOfHeader);
            this.writeIndexForPosition(this.lastIndex, this.positionOfHeader);
        }
        catch (StreamCorruptedException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBytes(long index, @NotNull BytesStore bytes) {
        this.throwExceptionIfClosed();
        this.checkAppendLock();
        this.writeLock.lock();
        try {
            this.writeBytesInternal(index, bytes);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void writeBytesInternal(long index, @NotNull BytesStore bytes) {
        this.writeBytesInternal(index, bytes, false);
    }

    protected void writeBytesInternal(long index, @NotNull BytesStore bytes, boolean metadata) {
        boolean isIndex;
        boolean isNextIndex;
        this.checkAppendLock(true);
        int cycle = this.queue.rollCycle().toCycle(index);
        if (this.wire == null) {
            this.setWireIfNull(cycle);
        }
        if (this.cycle != cycle) {
            this.rollCycleTo(cycle, this.cycle > cycle);
        }
        this.resetPosition(true);
        long headerNumber = this.wire.headerNumber();
        boolean bl = isNextIndex = index == headerNumber + 1L;
        if (!isNextIndex) {
            if (index > headerNumber + 1L) {
                throw new IllegalStateException("Unable to move to index " + Long.toHexString(index) + " beyond the end of the queue, current: " + Long.toHexString(headerNumber));
            }
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), "Trying to overwrite index " + Long.toHexString(index) + " which is before the end of the queue");
            }
            return;
        }
        this.writeBytesInternal(bytes, metadata);
        headerNumber = this.wire.headerNumber();
        boolean bl2 = isIndex = index == headerNumber;
        if (!isIndex) {
            throw new IllegalStateException("index: " + index + ", header: " + headerNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBytesInternal(@NotNull BytesStore bytes, boolean metadata) {
        assert (this.writeLock.locked());
        try {
            int safeLength = (int)this.queue.overlapSize();
            assert (this.count == 0) : "count=" + this.count;
            this.openContext(metadata, safeLength);
            try {
                Bytes bytes0 = this.context.wire().bytes();
                bytes0.readPosition(bytes0.writePosition());
                bytes0.write(bytes);
            }
            finally {
                this.context.close(false);
                this.count = 0;
            }
        }
        finally {
            this.context.isClosed = true;
        }
    }

    private void position(long position, long startOfMessage) {
        if (position > this.store.writePosition() + this.queue.blockSize()) {
            throw new IllegalArgumentException("pos: " + position + ", store.writePosition()=" + this.store.writePosition() + " queue.blockSize()=" + this.queue.blockSize());
        }
        this.position0(position, startOfMessage, this.wire.bytes());
    }

    @Override
    public long lastIndexAppended() {
        if (this.lastIndex != Long.MIN_VALUE) {
            return this.lastIndex;
        }
        if (this.lastPosition == Long.MIN_VALUE || this.wire == null) {
            throw new IllegalStateException("nothing has been appended, so there is no last index");
        }
        try {
            long sequenceNumber = this.store.sequenceForPosition(this, this.lastPosition, true);
            long index = this.queue.rollCycle().toIndex(this.cycle, sequenceNumber);
            this.lastIndex(index);
            return index;
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    public int cycle() {
        if (this.cycle == Integer.MIN_VALUE) {
            int cycle = this.queue.lastCycle();
            if (cycle < 0) {
                cycle = this.queue.cycle();
            }
            return cycle;
        }
        return this.cycle;
    }

    @Override
    @NotNull
    public SingleChronicleQueue queue() {
        return this.queue;
    }

    void beforeAppend(Wire wire, long index) {
    }

    private void rollCycleTo(int toCycle) {
        this.rollCycleTo(toCycle, this.cycle > toCycle);
    }

    private void rollCycleTo(int cycle, boolean suppressEOF) {
        int lastExistingCycle;
        if (this.cycle == cycle) {
            throw new AssertionError();
        }
        if (!suppressEOF) {
            assert (this.queue.writeLock().locked());
            this.store.writeEOF(this.wire, this.timeoutMS());
        }
        if ((lastExistingCycle = this.queue.lastCycle()) < cycle && lastExistingCycle != this.cycle && lastExistingCycle >= 0) {
            this.setCycle2(lastExistingCycle, false);
            this.rollCycleTo(cycle);
        } else {
            this.setCycle2(cycle, true);
        }
    }

    void writeIndexForPosition(long index, long position) throws StreamCorruptedException {
        long sequenceNumber = this.queue.rollCycle().toSequenceNumber(index);
        this.store.setPositionForSequenceNumber(this, sequenceNumber, position);
    }

    boolean checkIndex(long index, long position) {
        try {
            long seq1 = this.queue.rollCycle().toSequenceNumber(index + 1L) - 1L;
            long seq2 = this.store.sequenceForPosition(this, position, true);
            if (seq1 != seq2) {
                long seq3 = this.store.indexing.linearScanByPosition(this.wireForIndex(), position, 0L, 0L, true);
                Jvm.error().on(this.getClass(), "Thread=" + Thread.currentThread().getName() + " pos: " + position + " seq1: " + Long.toHexString(seq1) + " seq2: " + Long.toHexString(seq2) + " seq3: " + Long.toHexString(seq3));
                assert (seq1 == seq3) : "seq1=" + seq1 + ", seq3=" + seq3;
                assert (seq1 == seq2) : "seq1=" + seq1 + ", seq2=" + seq2;
            }
        }
        catch (EOFException | StreamCorruptedException | UnrecoverableTimeoutException e) {
            throw new AssertionError((Object)e);
        }
        return true;
    }

    public String toString() {
        return "StoreAppender{queue=" + this.queue + ", cycle=" + this.cycle + ", position=" + this.positionOfHeader + ", lastIndex=" + this.lastIndex + ", lastPosition=" + this.lastPosition + '}';
    }

    void position0(long position, long startOfMessage, Bytes<?> bytes) {
        this.positionOfHeader = position;
        bytes.writeLimit(bytes.capacity());
        bytes.writePosition(startOfMessage);
    }

    @Override
    @NotNull
    public StoreAppender disableThreadSafetyCheck(boolean disableThreadSafetyCheck) {
        super.singleThreadedCheckDisabled(disableThreadSafetyCheck);
        return this;
    }

    @Override
    public File currentFile() {
        SingleChronicleQueueStore store = this.store;
        return store == null ? null : store.currentFile();
    }

    @Override
    public void sync() {
        if (this.store == null) {
            return;
        }
        Bytes bytes = this.context.wire().bytes();
        if (bytes.bytesStore() instanceof MappedBytesStore) {
            MappedBytesStore mbs = (MappedBytesStore)bytes.bytesStore();
            mbs.syncUpTo(bytes.readPosition());
            this.queue.lastIndexMSynced(this.lastIndex);
        }
    }

    final class StoreAppenderContext
    implements WriteDocumentContext {
        boolean isClosed = true;
        private boolean metaData = false;
        private boolean rollbackOnClose = false;
        private boolean buffered = false;
        @Nullable
        private Wire wire;
        private boolean alreadyClosedFound;
        private StackTrace closedHere;
        private boolean chainedElement;

        StoreAppenderContext() {
        }

        public void reset() {
            this.isClosed = true;
            this.metaData = false;
            this.rollbackOnClose = false;
            this.buffered = false;
            this.alreadyClosedFound = false;
            this.chainedElement = false;
        }

        public int sourceId() {
            return StoreAppender.this.sourceId();
        }

        public boolean isPresent() {
            return false;
        }

        public Wire wire() {
            return this.wire;
        }

        public boolean isMetaData() {
            return this.metaData;
        }

        public void rollbackOnClose() {
            this.rollbackOnClose = true;
        }

        public void close() {
            this.close(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close(boolean unlock) {
            block28: {
                block27: {
                    if (this.chainedElement) {
                        return;
                    }
                    if (this.isClosed) {
                        Jvm.warn().on(this.getClass(), "Already Closed, close was called twice.", (Throwable)new StackTrace("Second close", (Throwable)this.closedHere));
                        this.alreadyClosedFound = true;
                        return;
                    }
                    StoreAppender.this.count--;
                    if (StoreAppender.this.count > 0) {
                        return;
                    }
                    if (this.alreadyClosedFound) {
                        this.closedHere = new StackTrace("Closed here");
                    }
                    try {
                        boolean interrupted;
                        boolean bl = interrupted = StoreAppender.this.checkInterrupts && Thread.currentThread().isInterrupted();
                        if (interrupted) {
                            throw new InterruptedException();
                        }
                        if (this.rollbackOnClose) {
                            this.doRollback();
                            return;
                        }
                        if (this.wire == StoreAppender.this.wire) {
                            try {
                                this.wire.updateHeader(StoreAppender.this.positionOfHeader, this.metaData, 0);
                            }
                            catch (IllegalStateException e) {
                                if (!StoreAppender.this.queue.isClosed()) throw e;
                                this.wire.bytes().writePositionForHeader(true);
                                this.isClosed = true;
                                if (!unlock) return;
                                try {
                                    StoreAppender.this.writeLock.unlock();
                                    return;
                                }
                                catch (Exception ex) {
                                    Jvm.warn().on(this.getClass(), "Exception while unlocking: ", (Throwable)ex);
                                }
                                return;
                            }
                            StoreAppender.this.lastPosition = StoreAppender.this.positionOfHeader;
                            if (this.metaData) return;
                            StoreAppender.this.lastIndex(this.wire.headerNumber());
                            StoreAppender.this.store.writePosition(StoreAppender.this.positionOfHeader);
                            break block27;
                        }
                        if (this.wire == null) return;
                        break block28;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedRuntimeException((Throwable)e);
                    }
                    catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (StoreAppender.this.lastIndex == Long.MIN_VALUE) return;
                StoreAppender.this.writeIndexForPosition(StoreAppender.this.lastIndex, StoreAppender.this.positionOfHeader);
                if (((StoreAppender)StoreAppender.this).queue.appenderListener == null) return;
                this.callAppenderListener();
                return;
            }
            if (this.buffered) {
                StoreAppender.this.writeBytes(this.wire.bytes());
                unlock = false;
                this.wire.clear();
                return;
            }
            StoreAppender.this.writeBytesInternal((BytesStore)this.wire.bytes(), this.metaData);
            this.wire = StoreAppender.this.wire;
            return;
            finally {
                this.wire.bytes().writePositionForHeader(true);
                this.isClosed = true;
                if (unlock) {
                    try {
                        StoreAppender.this.writeLock.unlock();
                    }
                    catch (Exception ex) {
                        Jvm.warn().on(this.getClass(), "Exception while unlocking: ", (Throwable)ex);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callAppenderListener() {
            Bytes bytes = this.wire.bytes();
            long rp = bytes.readPosition();
            long wp = bytes.writePosition();
            try {
                ((StoreAppender)StoreAppender.this).queue.appenderListener.onExcerpt(this.wire, StoreAppender.this.lastIndex);
            }
            finally {
                bytes.readPosition(rp);
                bytes.writePosition(wp);
            }
        }

        private void doRollback() {
            if (this.buffered) {
                assert (this.wire != StoreAppender.this.wire);
                this.wire.clear();
            } else {
                Bytes bytes = this.wire.bytes();
                try {
                    for (long i = StoreAppender.this.positionOfHeader; i <= bytes.writePosition(); ++i) {
                        bytes.writeByte(i, (byte)0);
                    }
                    long lastPosition = StoreAppender.this.lastPosition;
                    StoreAppender.this.position0(lastPosition, lastPosition, bytes);
                    ((AbstractWire)this.wire).forceNotInsideHeader();
                }
                catch (IllegalStateException | BufferOverflowException e) {
                    if (bytes instanceof MappedBytes && ((MappedBytes)bytes).isClosed()) {
                        Jvm.warn().on(this.getClass(), "Unable to roll back excerpt as it is closed.");
                        return;
                    }
                    throw e;
                }
            }
        }

        public long index() {
            if (this.buffered) {
                throw new IndexNotAvailableException("Index is unavailable when double buffering");
            }
            if (this.wire.headerNumber() == Long.MIN_VALUE) {
                try {
                    this.wire.headerNumber(StoreAppender.this.queue.rollCycle().toIndex(StoreAppender.this.cycle, StoreAppender.this.store.lastSequenceNumber(StoreAppender.this)));
                    long headerNumber0 = this.wire.headerNumber();
                    assert (((AbstractWire)this.wire).isInsideHeader());
                    return this.isMetaData() ? headerNumber0 : headerNumber0 + 1L;
                }
                catch (IOException e) {
                    throw new IORuntimeException((Throwable)e);
                }
            }
            return this.isMetaData() ? Long.MIN_VALUE : this.wire.headerNumber() + 1L;
        }

        public boolean isOpen() {
            return !this.isClosed;
        }

        public boolean isNotComplete() {
            return !this.isClosed;
        }

        public void start(boolean metaData) {
            throw new UnsupportedOperationException();
        }

        public void metaData(boolean metaData) {
            this.metaData = metaData;
        }

        public boolean chainedElement() {
            return this.chainedElement;
        }

        public void chainedElement(boolean chainedElement) {
            this.chainedElement = chainedElement;
        }
    }

    private class Finalizer {
        private Finalizer() {
        }

        protected void finalize() throws Throwable {
            super.finalize();
            StoreAppender.this.context.rollbackOnClose();
            StoreAppender.this.warnAndCloseIfNotClosed();
        }
    }
}

