/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.writer;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.List;
import net.openhft.chronicle.queue.ChronicleReaderMain;
import net.openhft.chronicle.queue.internal.writer.ChronicleWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class ChronicleWriterMain {
    public void run(@NotNull String[] args) throws IOException {
        Options options = this.options();
        CommandLine commandLine = this.parseCommandLine(args, options);
        ChronicleWriter writer = new ChronicleWriter();
        this.configure(writer, commandLine);
        writer.execute();
    }

    private CommandLine parseCommandLine(@NotNull String[] args, Options options) {
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
            if (commandLine.hasOption('h')) {
                this.printHelpAndExit(options, 0, null);
            }
            if (commandLine.getArgList().size() < 2) {
                this.printHelpAndExit(options, 1, "Need methodName and files...");
            }
        }
        catch (ParseException e) {
            this.printHelpAndExit(options, 1, e.getMessage());
        }
        return commandLine;
    }

    private void printHelpAndExit(Options options, int status, String message) {
        PrintWriter writer = new PrintWriter(System.out);
        new HelpFormatter().printHelp(writer, 180, this.getClass().getSimpleName() + " methodName files..", message, options, 1, 3, null, true);
        writer.flush();
        System.exit(status);
    }

    private void configure(ChronicleWriter writer, CommandLine commandLine) {
        writer.withBasePath(Paths.get(commandLine.getOptionValue('d'), new String[0]));
        if (commandLine.hasOption('r')) {
            String r = commandLine.getOptionValue('r');
            writer.asMethodWriter(r.equals("null") ? null : r);
        }
        List args = commandLine.getArgList();
        writer.withMethodName((String)args.get(0));
        writer.withFiles(args.subList(1, args.size()));
    }

    @NotNull
    private Options options() {
        Options options = new Options();
        ChronicleReaderMain.addOption(options, "d", "directory", true, "Directory containing chronicle queue files", true);
        ChronicleReaderMain.addOption(options, "i", "interface", true, "Interface to load up", false);
        return options;
    }
}

