/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import java.util.function.Consumer;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Mocker;
import net.openhft.chronicle.queue.internal.reader.QueueEntryHandler;
import net.openhft.chronicle.wire.WireIn;

public final class MethodReaderQueueEntryHandler
implements QueueEntryHandler {
    private final Class<?> mrInterface;

    public MethodReaderQueueEntryHandler(String methodReaderInterface) {
        try {
            this.mrInterface = Class.forName(methodReaderInterface);
        }
        catch (ClassNotFoundException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    public void accept(WireIn wireIn, Consumer<String> messageHandler) {
        MethodReader methodReader = wireIn.methodReader(new Object[]{Mocker.intercepting(this.mrInterface, (String)"", s -> {
            long hn = wireIn.headerNumber();
            messageHandler.accept("header: " + hn + "\n" + s);
        })});
        while (methodReader.readOne()) {
        }
    }

    @Override
    public void close() {
    }
}

