/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.File;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.threads.TimingPauser;

public abstract class AbstractTSQueueLock
extends AbstractCloseable
implements Closeable {
    protected static final long UNLOCKED = Long.MIN_VALUE;
    protected final boolean dontRecoverLockTimeout = Jvm.getBoolean((String)"queue.dont.recover.lock.timeout");
    protected final LongValue lock;
    protected final TimingPauser pauser;
    protected final File path;
    protected final TableStore tableStore;
    private final String lockKey;

    public AbstractTSQueueLock(String lockKey, TableStore<?> tableStore, Supplier<TimingPauser> pauser) {
        this.tableStore = tableStore;
        this.lock = tableStore.doWithExclusiveLock(ts -> ts.acquireValueFor(lockKey));
        this.pauser = pauser.get();
        this.path = tableStore.file();
        this.lockKey = lockKey;
    }

    protected void performClose() {
        Closeable.closeQuietly((Object)this.lock);
    }

    protected void forceUnlock(long value) {
        boolean unlocked = this.lock.compareAndSwapValue(value, Long.MIN_VALUE);
        Jvm.warn().on(((Object)((Object)this)).getClass(), "Forced unlock for the lock file:" + this.path + ", unlocked: " + unlocked, (Throwable)new StackTrace("Forced unlock"));
    }

    public void forceUnlockIfProcessIsDead() {
        long i = 0L;
        long pid;
        while ((pid = this.lock.getVolatileValue()) != Long.MIN_VALUE) {
            if (!Jvm.isProcessAlive((long)pid) || pid == (long)Jvm.getProcessId()) {
                if (Jvm.isDebugEnabled(((Object)((Object)this)).getClass())) {
                    Jvm.debug().on(((Object)((Object)this)).getClass(), String.format("Forced unlocking `%s` in lock file:%s, as this was locked by: %d", this.lockKey, this.path, pid), (Throwable)new StackTrace("Forced unlock"));
                }
                if (this.lock.compareAndSwapValue(pid, Long.MIN_VALUE)) {
                    return;
                }
            }
            if (++i % 1000L == 0L) {
                Jvm.warn().on(((Object)((Object)this)).getClass(), String.format("unable to release the lock=%s in the table store file=%s as it is being held by pid=%d, and this process is still running.", this.lockKey, this.path, pid));
            }
            Jvm.pause((long)1L);
            this.throwExceptionIfClosed();
        }
        return;
    }

    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }
}

