/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.BufferOverflowException;
import java.text.ParseException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.bytes.util.DecoratedBufferUnderflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.TailerState;
import net.openhft.chronicle.queue.batch.BatchAppender;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreComponentReferenceHandler;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.NoDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SourceContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueueExcerpts {
    private static final boolean CHECK_INDEX = Jvm.getBoolean((String)"queue.check.index");
    private static final Logger LOG = LoggerFactory.getLogger(SingleChronicleQueueExcerpts.class);
    private static final int MESSAGE_HISTORY_METHOD_ID = -1;
    private static final StringBuilderPool SBP = new StringBuilderPool();

    private static void releaseWireResources(Wire wire) {
        StoreComponentReferenceHandler.queueForRelease(wire);
    }

    private static void releaseIfNotNullAndReferenced(@Nullable Bytes bytesReference) {
        if (bytesReference != null) {
            bytesReference.release();
        }
    }

    public static class StoreTailer
    implements ExcerptTailer,
    SourceContext,
    ExcerptContext {
        static final int INDEXING_LINEAR_SCAN_THRESHOLD = 70;
        @NotNull
        private final SingleChronicleQueue queue;
        private final LongValue indexValue;
        private final StoreTailerContext context = new StoreTailerContext();
        private final MoveToState moveToState = new MoveToState();
        long index;
        @Nullable
        SingleChronicleQueueStore store;
        private int cycle;
        private TailerDirection direction = TailerDirection.FORWARD;
        private Wire wireForIndex;
        private boolean readAfterReplicaAcknowledged;
        @NotNull
        private TailerState state = TailerState.UNINITIALISED;
        private long indexAtCreation = Long.MIN_VALUE;
        private boolean readingDocumentFound = false;
        private long address = NoBytesStore.NO_PAGE;
        private boolean striding = false;
        private final AtomicBoolean isClosed = new AtomicBoolean();

        public StoreTailer(@NotNull SingleChronicleQueue queue) {
            this(queue, null);
        }

        public StoreTailer(@NotNull SingleChronicleQueue queue, LongValue indexValue) {
            this.queue = queue;
            this.indexValue = indexValue;
            this.setCycle(Integer.MIN_VALUE);
            this.index = 0L;
            queue.addCloseListener(this, StoreTailer::close);
            if (indexValue == null) {
                this.toStart();
            } else {
                this.moveToIndex(indexValue.getVolatileValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public static MessageHistory readHistory(@NotNull DocumentContext dc, MessageHistory history) {
            Wire wire = dc.wire();
            if (wire == null) {
                return null;
            }
            Object parent = wire.parent();
            wire.parent(null);
            try {
                Bytes bytes = wire.bytes();
                byte code = bytes.readByte(bytes.readPosition());
                history.reset();
                MessageHistory messageHistory = code == -70 ? StoreTailer.readHistoryFromBytes(wire, history) : StoreTailer.readHistoryFromWire(wire, history);
                return messageHistory;
            }
            finally {
                wire.parent(parent);
            }
        }

        @NotNull
        private static MessageHistory readHistoryFromBytes(@NotNull Wire wire, MessageHistory history) {
            Bytes bytes = wire.bytes();
            if (-1L != wire.readEventNumber()) {
                return null;
            }
            ((BytesMarshallable)history).readMarshallable((BytesIn)bytes);
            return history;
        }

        @Nullable
        private static MessageHistory readHistoryFromWire(@NotNull Wire wire, MessageHistory history) {
            StringBuilder sb = SBP.acquireStringBuilder();
            ValueIn valueIn = wire.read(sb);
            if (!"history".contentEquals(sb)) {
                return null;
            }
            valueIn.object((Object)history, MessageHistory.class);
            return history;
        }

        public boolean readDocument(@NotNull ReadMarshallable reader) {
            try (@NotNull DocumentContext dc = this.readingDocument(false);){
                if (!dc.isPresent()) {
                    boolean bl = false;
                    return bl;
                }
                reader.readMarshallable((WireIn)dc.wire());
            }
            return true;
        }

        @Override
        @NotNull
        public DocumentContext readingDocument() {
            long index = this.index();
            if (!(this.direction != TailerDirection.NONE || index != this.indexAtCreation && index != 0L || this.readingDocumentFound)) {
                return NoDocumentContext.INSTANCE;
            }
            return this.readingDocument(false);
        }

        private void close() {
            if (!this.isClosed.getAndSet(true)) {
                this.context.wire(null);
                Wire w0 = this.wireForIndex;
                if (w0 != null) {
                    SingleChronicleQueueExcerpts.releaseIfNotNullAndReferenced(w0.bytes());
                }
                this.wireForIndex = null;
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                this.store = null;
            }
        }

        @Override
        public Wire wire() {
            return this.context.wire();
        }

        @Override
        public Wire wireForIndex() {
            return this.wireForIndex;
        }

        @Override
        public long timeoutMS() {
            return this.queue.timeoutMS;
        }

        @Override
        public int sourceId() {
            return this.queue.sourceId;
        }

        @NotNull
        public String toString() {
            long index = this.index();
            return "StoreTailer{index sequence=" + this.queue.rollCycle().toSequenceNumber(index) + ", index cycle=" + this.queue.rollCycle().toCycle(index) + ", store=" + this.store + ", queue=" + this.queue + '}';
        }

        @Override
        @NotNull
        public DocumentContext readingDocument(boolean includeMetaData) {
            Jvm.optionalSafepoint();
            if (this.queue.isClosed.get()) {
                throw new IllegalStateException("Queue is closed");
            }
            try {
                Jvm.optionalSafepoint();
                boolean next = false;
                boolean tryAgain = true;
                if (this.state == TailerState.FOUND_CYCLE) {
                    try {
                        Jvm.optionalSafepoint();
                        next = this.inACycle(includeMetaData);
                        Jvm.optionalSafepoint();
                        tryAgain = false;
                    }
                    catch (EOFException eof) {
                        this.state = TailerState.END_OF_CYCLE;
                    }
                }
                Jvm.optionalSafepoint();
                if (tryAgain) {
                    next = this.next0(includeMetaData);
                }
                Jvm.optionalSafepoint();
                if (this.context.present(next)) {
                    Bytes bytes = this.context.wire().bytes();
                    this.context.setStart(bytes.readPosition() - 4L);
                    this.readingDocumentFound = true;
                    this.address = bytes.addressForRead(bytes.readPosition(), 4);
                    Jvm.optionalSafepoint();
                    return this.context;
                }
                Jvm.optionalSafepoint();
                RollCycle rollCycle = this.queue.rollCycle();
                if (this.state == TailerState.CYCLE_NOT_FOUND && this.direction == TailerDirection.FORWARD) {
                    int firstCycle = this.queue.firstCycle();
                    if (rollCycle.toCycle(this.index()) < firstCycle) {
                        this.toStart();
                    }
                } else if (!next && this.state == TailerState.CYCLE_NOT_FOUND && this.cycle != this.queue.cycle()) {
                    this.state = TailerState.END_OF_CYCLE;
                }
                this.setAddress(this.context.wire() != null);
            }
            catch (StreamCorruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (UnrecoverableTimeoutException e) {
            }
            catch (DecoratedBufferUnderflowException e) {
                if (this.queue.isReadOnly()) {
                    Jvm.warn().on(StoreTailer.class, "Tried to read past the end of a read-only view. Underlying data store may have grown since this tailer was created.", (Throwable)e);
                }
                throw e;
            }
            return NoDocumentContext.INSTANCE;
        }

        @Override
        public boolean peekDocument() {
            if (this.address == NoBytesStore.NO_PAGE || this.state != TailerState.FOUND_CYCLE || this.direction != TailerDirection.FORWARD) {
                return this.peekDocument0();
            }
            int header = UnsafeMemory.UNSAFE.getIntVolatile(null, this.address);
            if (header == -1073741824) {
                return this.peekDocument0();
            }
            return header > 0;
        }

        private boolean peekDocument0() {
            try (DocumentContext dc = this.readingDocument();){
                dc.rollbackOnClose();
                boolean bl = dc.isPresent();
                return bl;
            }
        }

        private boolean next0(boolean includeMetaData) throws UnrecoverableTimeoutException, StreamCorruptedException {
            block9: for (int i = 0; i < 1000; ++i) {
                switch (this.state) {
                    case UNINITIALISED: {
                        long firstIndex = this.queue.firstIndex();
                        if (firstIndex == Long.MAX_VALUE) {
                            return false;
                        }
                        if (this.moveToIndexInternal(firstIndex)) continue block9;
                        return false;
                    }
                    case FOUND_CYCLE: {
                        try {
                            return this.inACycle(includeMetaData);
                        }
                        catch (EOFException eof) {
                            this.state = TailerState.END_OF_CYCLE;
                            continue block9;
                        }
                    }
                    case END_OF_CYCLE: {
                        if (this.endOfCycle()) {
                            Jvm.optionalSafepoint();
                            continue block9;
                        }
                        return false;
                    }
                    case BEYOND_START_OF_CYCLE: {
                        if (this.beyondStartOfCycle()) continue block9;
                        return false;
                    }
                    case CYCLE_NOT_FOUND: {
                        if (this.nextCycleNotFound()) continue block9;
                        return false;
                    }
                    default: {
                        throw new AssertionError((Object)("state=" + (Object)((Object)this.state)));
                    }
                }
            }
            throw new IllegalStateException("Unable to progress to the next cycle, state=" + (Object)((Object)this.state));
        }

        private boolean endOfCycle() {
            long oldIndex = this.index();
            int currentCycle = this.queue.rollCycle().toCycle(oldIndex);
            long nextIndex = this.nextIndexWithNextAvailableCycle(currentCycle);
            if (nextIndex != Long.MIN_VALUE) {
                return this.nextEndOfCycle(nextIndex);
            }
            this.state = TailerState.END_OF_CYCLE;
            return false;
        }

        private boolean beyondStartOfCycle() throws StreamCorruptedException {
            if (this.direction == TailerDirection.FORWARD) {
                this.state = TailerState.UNINITIALISED;
                return true;
            }
            if (this.direction == TailerDirection.BACKWARD) {
                return this.beyondStartOfCycleBackward();
            }
            throw new AssertionError((Object)("direction not set, direction=" + (Object)((Object)this.direction)));
        }

        private boolean nextEndOfCycle(long nextIndex) {
            if (this.moveToIndexInternal(nextIndex)) {
                this.state = TailerState.FOUND_CYCLE;
                Jvm.optionalSafepoint();
                return true;
            }
            Jvm.optionalSafepoint();
            if (this.state == TailerState.END_OF_CYCLE) {
                Jvm.optionalSafepoint();
                return true;
            }
            if (this.cycle < this.queue.lastCycle()) {
                this.state = TailerState.END_OF_CYCLE;
                Jvm.optionalSafepoint();
                return true;
            }
            int nextCycle = this.queue.rollCycle().toCycle(nextIndex);
            this.cycle(nextCycle);
            this.state = TailerState.CYCLE_NOT_FOUND;
            return false;
        }

        private boolean beyondStartOfCycleBackward() throws StreamCorruptedException {
            boolean foundCycle = this.cycle(this.queue.rollCycle().toCycle(this.index()));
            if (foundCycle) {
                long lastSequenceNumberInThisCycle = this.store().sequenceForPosition(this, Long.MAX_VALUE, false);
                long nextIndex = this.queue.rollCycle().toIndex(this.cycle, lastSequenceNumberInThisCycle);
                this.moveToIndexInternal(nextIndex);
                this.state = TailerState.FOUND_CYCLE;
                return true;
            }
            int cycle = this.queue.rollCycle().toCycle(this.index());
            long nextIndex = this.nextIndexWithNextAvailableCycle(cycle);
            if (nextIndex != Long.MIN_VALUE) {
                this.moveToIndexInternal(nextIndex);
                this.state = TailerState.FOUND_CYCLE;
                return true;
            }
            this.state = TailerState.BEYOND_START_OF_CYCLE;
            return false;
        }

        private boolean nextCycleNotFound() {
            if (this.index() == Long.MIN_VALUE) {
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                this.store = null;
                return false;
            }
            if (this.moveToIndexInternal(this.index())) {
                this.state = TailerState.FOUND_CYCLE;
                return true;
            }
            return false;
        }

        private boolean inACycle(boolean includeMetaData) throws EOFException {
            Jvm.optionalSafepoint();
            if (this.readAfterReplicaAcknowledged && this.inACycleCheckRep()) {
                return false;
            }
            Jvm.optionalSafepoint();
            if (this.direction != TailerDirection.FORWARD && !this.inACycleNotForward()) {
                return false;
            }
            Jvm.optionalSafepoint();
            Wire wire = this.wire();
            Bytes bytes = wire.bytes();
            bytes.readLimit(bytes.capacity());
            switch (wire.readDataHeader(includeMetaData)) {
                case NONE: {
                    Jvm.optionalSafepoint();
                    return false;
                }
                case META_DATA: {
                    Jvm.optionalSafepoint();
                    this.context.metaData(true);
                    break;
                }
                case DATA: {
                    Jvm.optionalSafepoint();
                    this.context.metaData(false);
                }
            }
            Jvm.optionalSafepoint();
            this.inACycleFound(bytes);
            Jvm.optionalSafepoint();
            return true;
        }

        private boolean inACycleCheckRep() {
            long lastSequenceAck = this.queue.lastAcknowledgedIndexReplicated();
            long index = this.index();
            return index > lastSequenceAck;
        }

        private boolean inACycleNotForward() {
            Jvm.optionalSafepoint();
            if (!this.moveToIndexInternal(this.index())) {
                try {
                    Jvm.optionalSafepoint();
                    if ((int)this.queue.rollCycle().toSequenceNumber(this.index()) < 0) {
                        long lastSeqNum = this.store.lastSequenceNumber(this);
                        if (lastSeqNum == -1L) {
                            this.windBackCycle(this.cycle);
                            return this.moveToIndexInternal(this.index());
                        }
                        return this.moveToIndexInternal(this.queue.rollCycle().toIndex(this.cycle, lastSeqNum));
                    }
                    if (!this.moveToIndexInternal(this.index() - 1L)) {
                        Jvm.optionalSafepoint();
                        return false;
                    }
                }
                catch (Exception e) {
                    Jvm.optionalSafepoint();
                    return false;
                }
            }
            Jvm.optionalSafepoint();
            return true;
        }

        private void inACycleFound(@NotNull Bytes<?> bytes) {
            this.context.closeReadLimit(bytes.capacity());
            this.wire().readAndSetLength(bytes.readPosition());
            long end = bytes.readLimit();
            this.context.closeReadPosition(end);
            Jvm.optionalSafepoint();
        }

        private long nextIndexWithNextAvailableCycle(int cycle) {
            long nextIndex;
            assert (cycle != Integer.MIN_VALUE) : "cycle == Integer.MIN_VALUE";
            if (cycle > this.queue.lastCycle() || this.direction == TailerDirection.NONE) {
                return Long.MIN_VALUE;
            }
            int nextCycle = cycle + this.direction.add();
            boolean found = this.cycle(nextCycle);
            if (found) {
                nextIndex = this.nextIndexWithinFoundCycle(nextCycle);
            } else {
                try {
                    int nextCycle0 = this.queue.nextCycle(this.cycle, this.direction);
                    if (nextCycle0 == -1) {
                        return Long.MIN_VALUE;
                    }
                    nextIndex = this.nextIndexWithinFoundCycle(nextCycle0);
                }
                catch (ParseException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (LOG.isDebugEnabled()) {
                int nextIndexCycle = this.queue.rollCycle().toCycle(nextIndex);
                if (nextIndex != Long.MIN_VALUE && nextIndexCycle - 1 != cycle) {
                    LOG.debug("Rolled " + (nextIndexCycle - cycle) + " times to find the next cycle file. This can occur if your appenders have not written anything for a while, leaving the cycle files with a gap.");
                }
            }
            return nextIndex;
        }

        private long nextIndexWithinFoundCycle(int nextCycle) {
            this.state = TailerState.FOUND_CYCLE;
            if (this.direction == TailerDirection.FORWARD) {
                return this.queue.rollCycle().toIndex(nextCycle, 0L);
            }
            if (this.direction == TailerDirection.BACKWARD) {
                try {
                    long lastSequenceNumber0 = this.store().lastSequenceNumber(this);
                    return this.queue.rollCycle().toIndex(nextCycle, lastSequenceNumber0);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
            throw new IllegalStateException("direction=" + (Object)((Object)this.direction));
        }

        @Override
        public long index() {
            return this.indexValue == null ? this.index : this.indexValue.getValue();
        }

        @Override
        public int cycle() {
            return this.cycle;
        }

        @Override
        public boolean moveToIndex(long index) {
            if (this.moveToState.canReuseLastIndexMove(index, this.state, this.direction, this.queue, this.wire())) {
                return this.setAddress(true);
            }
            if (this.moveToState.indexIsCloseToAndAheadOfLastIndexMove(index, this.state, this.direction, this.queue)) {
                boolean found;
                long knownIndex = this.moveToState.lastMovedToIndex;
                boolean bl = found = this.store.linearScanTo(index, knownIndex, this, this.moveToState.readPositionAtLastMove) == ScanResult.FOUND;
                if (found) {
                    this.index(index);
                    this.moveToState.onSuccessfulScan(index, this.direction, this.wire().bytes().readPosition());
                }
                return this.setAddress(found);
            }
            return this.moveToIndexInternal(index);
        }

        private boolean setAddress(boolean found) {
            Wire wire = this.wire();
            if (wire == null) {
                this.address = NoBytesStore.NO_PAGE;
                return false;
            }
            Bytes bytes = wire.bytes();
            this.address = found ? bytes.addressForRead(bytes.readPosition(), 4) : NoBytesStore.NO_PAGE;
            return found;
        }

        private ScanResult moveToIndexResult0(long index) {
            int cycle = this.queue.rollCycle().toCycle(index);
            long sequenceNumber = this.queue.rollCycle().toSequenceNumber(index);
            if (LOG.isTraceEnabled()) {
                Jvm.debug().on(this.getClass(), "moveToIndex: " + Long.toHexString(cycle) + " " + Long.toHexString(sequenceNumber));
            }
            if (!(cycle == this.cycle && this.state == TailerState.FOUND_CYCLE || this.cycle(cycle))) {
                return ScanResult.NOT_REACHED;
            }
            this.index(index);
            ScanResult scanResult = this.store().moveToIndexForRead(this, sequenceNumber);
            Bytes bytes = this.wire().bytes();
            if (scanResult == ScanResult.FOUND) {
                this.state = TailerState.FOUND_CYCLE;
                this.moveToState.onSuccessfulLookup(index, this.direction, bytes.readPosition());
                return scanResult;
            }
            if (scanResult == ScanResult.END_OF_FILE) {
                this.state = TailerState.END_OF_CYCLE;
                return scanResult;
            }
            if (scanResult == ScanResult.NOT_FOUND && this.cycle < this.queue.lastCycle) {
                this.state = TailerState.END_OF_CYCLE;
                return ScanResult.END_OF_FILE;
            }
            return scanResult;
        }

        ScanResult moveToIndexResult(long index) {
            ScanResult scanResult = this.moveToIndexResult0(index);
            this.setAddress(scanResult == ScanResult.FOUND);
            return scanResult;
        }

        @Override
        @NotNull
        public final ExcerptTailer toStart() {
            assert (this.direction != TailerDirection.BACKWARD);
            int firstCycle = this.queue.firstCycle();
            if (firstCycle == Integer.MAX_VALUE) {
                this.state = TailerState.UNINITIALISED;
                this.address = NoBytesStore.NO_PAGE;
                return this;
            }
            if (firstCycle != this.cycle) {
                boolean found = this.cycle(firstCycle);
                assert (found || this.store == null);
                if (found) {
                    this.state = TailerState.FOUND_CYCLE;
                }
            }
            this.index(this.queue.rollCycle().toIndex(this.cycle, 0L));
            this.state = TailerState.FOUND_CYCLE;
            if (this.wire() != null) {
                this.wire().bytes().readPosition(0L);
                this.address = this.wire().bytes().addressForRead(0L);
            }
            return this;
        }

        private boolean moveToIndexInternal(long index) {
            this.moveToState.indexMoveCount++;
            Jvm.optionalSafepoint();
            ScanResult scanResult = this.moveToIndexResult(index);
            Jvm.optionalSafepoint();
            return scanResult == ScanResult.FOUND;
        }

        private long approximateLastIndex() {
            RollCycle rollCycle = this.queue.rollCycle();
            int lastCycle = this.queue.lastCycle();
            try {
                long sequenceNumber;
                if (lastCycle == Integer.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                SingleChronicleQueueStore wireStore = this.queue.storeForCycle(lastCycle, this.queue.epoch(), false);
                this.setCycle(lastCycle);
                if (wireStore == null) {
                    throw new IllegalStateException("Store not found for cycle " + Long.toHexString(lastCycle) + ". Probably the files were removed?");
                }
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                if (this.store != wireStore) {
                    this.store = wireStore;
                    this.resetWires();
                }
                if ((sequenceNumber = this.store.lastSequenceNumber(this)) == -1L) {
                    return rollCycle.toIndex(lastCycle, 0L);
                }
                return rollCycle.toIndex(lastCycle, sequenceNumber);
            }
            catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
                throw new IllegalStateException(e);
            }
        }

        private boolean headerNumberCheck(@NotNull AbstractWire wire) {
            wire.headNumberCheck((actual, position) -> {
                try {
                    long expecting = this.store.sequenceForPosition(this, position, false);
                    if (actual == expecting) {
                        return true;
                    }
                    LOG.error("", (Throwable)((Object)new AssertionError((Object)("header number check failed expecting=" + expecting + "  !=  actual=" + actual))));
                    return false;
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                    return false;
                }
            });
            return true;
        }

        private void resetWires() {
            WireType wireType = this.queue.wireType();
            AbstractWire wire = (AbstractWire)this.readAnywhere((Wire)wireType.apply((Object)this.store.bytes()));
            assert (!CHECK_INDEX || this.headerNumberCheck(wire));
            this.context.wire(wire);
            wire.parent((Object)this);
            Wire wireForIndexOld = this.wireForIndex;
            this.wireForIndex = this.readAnywhere((Wire)wireType.apply((Object)this.store().bytes()));
            assert (!CHECK_INDEX || this.headerNumberCheck((AbstractWire)this.wireForIndex));
            assert (wire != wireForIndexOld);
            if (wireForIndexOld != null) {
                SingleChronicleQueueExcerpts.releaseWireResources(wireForIndexOld);
            }
        }

        @NotNull
        private Wire readAnywhere(@NotNull Wire wire) {
            Bytes bytes = wire.bytes();
            bytes.readLimit(bytes.capacity());
            if (this.store.dataVersion() > 0) {
                wire.usePadding(true);
            }
            return wire;
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() {
            if (this.direction.equals((Object)TailerDirection.BACKWARD)) {
                return this.originalToEnd();
            }
            return this.optimizedToEnd();
        }

        @Override
        public ExcerptTailer striding(boolean striding) {
            this.striding = striding;
            return this;
        }

        @Override
        public boolean striding() {
            return this.striding;
        }

        @NotNull
        private ExcerptTailer optimizedToEnd() {
            RollCycle rollCycle = this.queue.rollCycle();
            int lastCycle = this.queue.lastCycle();
            try {
                long sequenceNumber;
                if (lastCycle == Integer.MIN_VALUE) {
                    if (this.state() == TailerState.CYCLE_NOT_FOUND) {
                        this.state = TailerState.UNINITIALISED;
                    }
                    this.setAddress(this.state == TailerState.FOUND_CYCLE);
                    return this;
                }
                SingleChronicleQueueStore wireStore = this.queue.storeForCycle(lastCycle, this.queue.epoch(), false);
                this.setCycle(lastCycle);
                if (wireStore == null) {
                    throw new IllegalStateException("Store not found for cycle " + Long.toHexString(lastCycle) + ". Probably the files were removed? lastCycle=" + lastCycle);
                }
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                if (this.store != wireStore) {
                    this.store = wireStore;
                    this.resetWires();
                }
                if ((sequenceNumber = this.store.moveToEndForRead(this.wire())) == -1L) {
                    return this.originalToEnd();
                }
                Bytes bytes = this.wire().bytes();
                this.state = Wires.isEndOfFile((int)bytes.readVolatileInt(bytes.readPosition())) ? TailerState.END_OF_CYCLE : TailerState.FOUND_CYCLE;
                this.index(rollCycle.toIndex(lastCycle, sequenceNumber));
                this.setAddress(this.state == TailerState.FOUND_CYCLE);
            }
            catch (UnrecoverableTimeoutException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        @NotNull
        public ExcerptTailer originalToEnd() {
            long index = this.approximateLastIndex();
            if (index == Long.MIN_VALUE) {
                if (this.state() == TailerState.CYCLE_NOT_FOUND) {
                    this.state = TailerState.UNINITIALISED;
                }
                return this;
            }
            ScanResult scanResult = this.moveToIndexResult(index);
            block0 : switch (scanResult) {
                case NOT_FOUND: {
                    if (this.moveToIndexResult(index - 1L) != ScanResult.FOUND) break;
                    this.state = TailerState.FOUND_CYCLE;
                    break;
                }
                case FOUND: {
                    if (this.direction != TailerDirection.FORWARD) break;
                    ScanResult result = this.moveToIndexResult(++index);
                    switch (result) {
                        case NOT_REACHED: {
                            throw new IllegalStateException("NOT_REACHED after FOUND");
                        }
                        case FOUND: 
                        case NOT_FOUND: {
                            this.state = TailerState.FOUND_CYCLE;
                            break block0;
                        }
                        case END_OF_FILE: {
                            this.state = TailerState.END_OF_CYCLE;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unknown ScanResult: " + (Object)((Object)result));
                }
                case NOT_REACHED: {
                    throw new IllegalStateException("NOT_REACHED index: " + Long.toHexString(index));
                }
                case END_OF_FILE: {
                    this.state = TailerState.END_OF_CYCLE;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown ScanResult: " + (Object)((Object)scanResult));
                }
            }
            return this;
        }

        @Override
        public TailerDirection direction() {
            return this.direction;
        }

        @Override
        @NotNull
        public ExcerptTailer direction(@NotNull TailerDirection direction) {
            TailerDirection oldDirection = this.direction();
            this.direction = direction;
            if (oldDirection == TailerDirection.BACKWARD && direction == TailerDirection.FORWARD) {
                this.moveToIndexInternal(this.index());
            }
            return this;
        }

        @Override
        @NotNull
        public ChronicleQueue queue() {
            return this.queue;
        }

        @Override
        public Runnable getCloserJob() {
            return this::close;
        }

        public void releaseResources() {
            this.queue.removeCloseListener(this);
            this.getCloserJob().run();
        }

        void incrementIndex() {
            RollCycle rollCycle = this.queue.rollCycle();
            long index = this.index();
            long seq = rollCycle.toSequenceNumber(index);
            int cycle = rollCycle.toCycle(index);
            seq += (long)this.direction.add();
            switch (this.direction) {
                case NONE: {
                    break;
                }
                case FORWARD: {
                    if (rollCycle.toSequenceNumber(seq) >= seq) break;
                    this.cycle(cycle + 1);
                    LOG.warn("we have run out of sequence numbers, so will start to write to the next .cq4 file, the new cycle=" + cycle);
                    seq = 0L;
                    break;
                }
                case BACKWARD: {
                    if (seq < 0L) {
                        this.windBackCycle(cycle);
                        return;
                    }
                    if (seq <= 0L || !this.striding) break;
                    seq -= seq % (long)rollCycle.defaultIndexSpacing();
                }
            }
            this.index0(rollCycle.toIndex(cycle, seq));
        }

        private void windBackCycle(int cycle) {
            long first = this.queue.firstCycle();
            while ((long)(--cycle) >= first) {
                if (!this.tryWindBack(cycle)) continue;
                return;
            }
            this.index(this.queue.rollCycle().toIndex(cycle, -1L));
            this.state = TailerState.BEYOND_START_OF_CYCLE;
        }

        private boolean tryWindBack(int cycle) {
            long count = this.queue.exceptsPerCycle(cycle);
            if (count <= 0L) {
                return false;
            }
            RollCycle rollCycle = this.queue.rollCycle();
            this.moveToIndexInternal(rollCycle.toIndex(cycle, count - 1L));
            this.state = TailerState.FOUND_CYCLE;
            return true;
        }

        void index0(long index) {
            if (this.indexValue == null) {
                this.index = index;
            } else {
                this.indexValue.setValue(index);
            }
        }

        void index(long index) {
            this.index0(index);
            if (this.indexAtCreation == Long.MIN_VALUE) {
                this.indexAtCreation = index;
            }
            this.moveToState.reset();
        }

        private boolean cycle(int cycle) {
            if (this.cycle == cycle && this.state == TailerState.FOUND_CYCLE) {
                return true;
            }
            SingleChronicleQueueStore nextStore = this.queue.storeForCycle(cycle, this.queue.epoch(), false);
            if (nextStore == null && this.store == null) {
                return false;
            }
            if (nextStore == null) {
                this.state = this.direction == TailerDirection.BACKWARD ? TailerState.BEYOND_START_OF_CYCLE : TailerState.CYCLE_NOT_FOUND;
                return false;
            }
            if (this.store != null) {
                this.queue.release(this.store);
            }
            if (nextStore == this.store) {
                return true;
            }
            this.context.wire(null);
            this.store = nextStore;
            this.state = TailerState.FOUND_CYCLE;
            this.setCycle(cycle);
            this.resetWires();
            Wire wire = this.wire();
            wire.parent((Object)this);
            wire.pauser((Pauser)this.queue.pauserSupplier.get());
            return true;
        }

        void release() {
            if (this.store != null) {
                this.queue.release(this.store);
                this.store = null;
            }
            this.state = TailerState.UNINITIALISED;
        }

        @Override
        public void readAfterReplicaAcknowledged(boolean readAfterReplicaAcknowledged) {
            this.readAfterReplicaAcknowledged = readAfterReplicaAcknowledged;
        }

        @Override
        public boolean readAfterReplicaAcknowledged() {
            return this.readAfterReplicaAcknowledged;
        }

        @Override
        @NotNull
        public TailerState state() {
            return this.state;
        }

        @Override
        @NotNull
        public ExcerptTailer afterLastWritten(@NotNull ChronicleQueue queue) {
            if (queue == this.queue) {
                throw new IllegalArgumentException("You must pass the queue written to, not the queue read");
            }
            @NotNull ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
            @NotNull VanillaMessageHistory messageHistory = new VanillaMessageHistory();
            while (true) {
                DocumentContext context = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    int i;
                    if (!context.isPresent()) {
                        this.toStart();
                        StoreTailer storeTailer = this;
                        return storeTailer;
                    }
                    MessageHistory veh = StoreTailer.readHistory(context, (MessageHistory)messageHistory);
                    if (veh == null || (i = veh.sources() - 1) < 0 || veh.sourceId(i) != this.sourceId()) continue;
                    long sourceIndex = veh.sourceIndex(i);
                    if (!this.moveToIndexInternal(sourceIndex)) {
                        String errorMessage = String.format("Unable to move to sourceIndex %s in queue %s", Long.toHexString(sourceIndex), this.queue.fileAbsolutePath());
                        throw new IORuntimeException(errorMessage + this.extraInfo(tailer, messageHistory));
                    }
                    try (DocumentContext content = this.readingDocument();){
                        if (!content.isPresent()) {
                            String errorMessage = String.format("No readable document found at sourceIndex %s in queue %s", Long.toHexString(sourceIndex + 1L), this.queue.fileAbsolutePath());
                            throw new IORuntimeException(errorMessage + this.extraInfo(tailer, messageHistory));
                        }
                    }
                    StoreTailer storeTailer = this;
                    return storeTailer;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    context.close();
                    continue;
                }
                break;
            }
        }

        private String extraInfo(@NotNull ExcerptTailer tailer, @NotNull VanillaMessageHistory messageHistory) {
            return String.format(". That sourceIndex was determined fom the last entry written to queue %s (message index %s, message history %s). If source queue is replicated then sourceIndex may not have been replicated yet", tailer.queue().fileAbsolutePath(), Long.toHexString(tailer.index()), WireType.TEXT.asString((Object)messageHistory));
        }

        public void setCycle(int cycle) {
            this.cycle = cycle;
        }

        int getIndexMoveCount() {
            return this.moveToState.indexMoveCount;
        }

        @Deprecated
        @NotNull
        WireStore store() {
            if (this.store == null) {
                this.setCycle(this.cycle());
            }
            return this.store;
        }

        class StoreTailerContext
        extends BinaryReadDocumentContext {
            boolean rollbackOnClose;

            StoreTailerContext() {
                super(null);
                this.rollbackOnClose = false;
            }

            public void rollbackOnClose() {
                this.rollbackOnClose = true;
            }

            public long index() {
                return StoreTailer.this.index();
            }

            public int sourceId() {
                return StoreTailer.this.sourceId();
            }

            public void close() {
                try {
                    if (this.rollbackOnClose) {
                        this.present = false;
                        if (this.start != -1L) {
                            ((Bytes)this.wire.bytes().readPosition(this.start)).readLimit(this.readLimit);
                        }
                        this.start = -1L;
                        return;
                    }
                    if (this.isPresent() && !this.isMetaData()) {
                        StoreTailer.this.incrementIndex();
                    }
                    super.close();
                    if (StoreTailer.this.direction == TailerDirection.FORWARD) {
                        StoreTailer.this.setAddress(StoreTailer.this.context.wire() != null);
                    } else if (StoreTailer.this.direction == TailerDirection.BACKWARD) {
                        StoreTailer.this.setAddress(false);
                    }
                }
                finally {
                    this.rollbackOnClose = false;
                }
            }

            boolean present(boolean present) {
                this.present = present;
                return this.present;
            }

            public void wire(@Nullable AbstractWire wire) {
                if (wire == this.wire) {
                    return;
                }
                AbstractWire oldWire = this.wire;
                this.wire = wire;
                if (oldWire != null) {
                    SingleChronicleQueueExcerpts.releaseWireResources((Wire)oldWire);
                }
            }
        }

        private static final class MoveToState {
            private long lastMovedToIndex = Long.MIN_VALUE;
            private TailerDirection directionAtLastMoveTo = TailerDirection.NONE;
            private long readPositionAtLastMove = Long.MIN_VALUE;
            private int indexMoveCount = 0;

            private MoveToState() {
            }

            void onSuccessfulLookup(long movedToIndex, TailerDirection direction, long readPosition) {
                this.lastMovedToIndex = movedToIndex;
                this.directionAtLastMoveTo = direction;
                this.readPositionAtLastMove = readPosition;
            }

            void onSuccessfulScan(long movedToIndex, TailerDirection direction, long readPosition) {
                this.lastMovedToIndex = movedToIndex;
                this.directionAtLastMoveTo = direction;
                this.readPositionAtLastMove = readPosition;
            }

            void reset() {
                this.lastMovedToIndex = Long.MIN_VALUE;
                this.directionAtLastMoveTo = TailerDirection.NONE;
                this.readPositionAtLastMove = Long.MIN_VALUE;
            }

            private boolean indexIsCloseToAndAheadOfLastIndexMove(long index, TailerState state, TailerDirection direction, ChronicleQueue queue) {
                return this.lastMovedToIndex != Long.MIN_VALUE && index - this.lastMovedToIndex < 70L && state == TailerState.FOUND_CYCLE && direction == this.directionAtLastMoveTo && queue.rollCycle().toCycle(index) == queue.rollCycle().toCycle(this.lastMovedToIndex) && index > this.lastMovedToIndex;
            }

            private boolean canReuseLastIndexMove(long index, TailerState state, TailerDirection direction, ChronicleQueue queue, Wire wire) {
                return (wire == null || wire.bytes().readPosition() == this.readPositionAtLastMove) && index == this.lastMovedToIndex && index != 0L && state == TailerState.FOUND_CYCLE && direction == this.directionAtLastMoveTo && queue.rollCycle().toCycle(index) == queue.rollCycle().toCycle(this.lastMovedToIndex);
            }
        }
    }

    static class StoreAppender
    extends AbstractCloseable
    implements ExcerptAppender,
    ExcerptContext,
    InternalAppender {
        @NotNull
        private final SingleChronicleQueue queue;
        @NotNull
        private final WriteLock writeLock;
        @NotNull
        private final StoreAppenderContext context;
        private final WireStorePool storePool;
        private final boolean checkInterrupts;
        @Nullable
        SingleChronicleQueueStore store;
        private int cycle = Integer.MIN_VALUE;
        @Nullable
        private Wire wire;
        @Nullable
        private Wire wireForIndex;
        private long positionOfHeader = 0L;
        private long lastIndex = Long.MIN_VALUE;
        private long lastPosition;
        private int lastCycle;
        @Nullable
        private Pretoucher pretoucher = null;
        private NativeBytesStore<Void> batchTmp;
        private final ThreadLocal<Bytes<?>> bufferBytes = ThreadLocal.withInitial(Bytes::allocateElasticDirect);
        private final ThreadLocal<Wire> bufferWire = new ThreadLocal<Wire>(){

            @Override
            protected Wire initialValue() {
                return (Wire)this.queue().wireType().apply(bufferBytes.get());
            }

            @Override
            public Wire get() {
                Wire wire = (Wire)super.get();
                ((Bytes)bufferBytes.get()).clear();
                return wire;
            }
        };

        StoreAppender(@NotNull SingleChronicleQueue queue, @NotNull WireStorePool storePool, boolean checkInterrupts) {
            this.queue = queue;
            this.storePool = storePool;
            this.checkInterrupts = checkInterrupts;
            this.writeLock = queue.writeLock();
            this.context = new StoreAppenderContext();
            queue.addCloseListener(this, AbstractCloseable::close);
            queue.cleanupStoreFilesWithNoData();
            int cycle = queue.cycle();
            int lastCycle = queue.lastCycle();
            if (lastCycle != cycle && lastCycle >= 0) {
                this.setCycle2(lastCycle, false);
            }
        }

        @Deprecated
        @NotNull
        WireStore store() {
            if (this.store == null) {
                this.setCycle(this.cycle());
            }
            return this.store;
        }

        public void writeBytes(@NotNull WriteBytesMarshallable marshallable) throws UnrecoverableTimeoutException {
            try (DocumentContext dc = this.writingDocument();){
                Bytes bytes = dc.wire().bytes();
                long wp = bytes.writePosition();
                marshallable.writeMarshallable((BytesOut)bytes);
                if (wp == bytes.writePosition()) {
                    dc.rollbackOnClose();
                }
            }
        }

        protected void performClose() {
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), "Closing store append for " + this.queue.file().getAbsolutePath());
            }
            Wire w0 = this.wireForIndex;
            this.wireForIndex = null;
            if (w0 != null) {
                SingleChronicleQueueExcerpts.releaseIfNotNullAndReferenced(w0.bytes());
            }
            Wire w = this.wire;
            this.wire = null;
            if (w != null) {
                SingleChronicleQueueExcerpts.releaseIfNotNullAndReferenced(w.bytes());
            }
            if (this.pretoucher != null) {
                this.pretoucher.close();
            }
            if (this.store != null) {
                this.storePool.release(this.store);
            }
            this.store = null;
            this.storePool.close();
        }

        @Override
        public void pretouch() {
            if (this.queue.isClosed()) {
                throw new RuntimeException("Queue Closed");
            }
            try {
                if (this.pretoucher == null) {
                    this.pretoucher = new Pretoucher(this.queue());
                }
                this.pretoucher.execute();
            }
            catch (Throwable e) {
                Jvm.warn().on(this.getClass(), e);
                Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        @Nullable
        public Wire wire() {
            return this.wire;
        }

        @Override
        public long batchAppend(int timeoutMS, BatchAppender batchAppender) {
            long maxMsgSize = this.queue.blockSize() / 4L;
            long startTime = System.currentTimeMillis();
            long count = 0L;
            long lastIndex = -1L;
            do {
                int defaultIndexSpacing = this.queue.rollCycle().defaultIndexSpacing();
                Wire wire = this.wire();
                int writeCount = Math.min(131072, (int)((long)defaultIndexSpacing - (lastIndex & (long)(defaultIndexSpacing - 1)) - 1L));
                if (wire != null && writeCount > 0) {
                    MappedBytes bytes = (MappedBytes)wire.bytes();
                    long address = bytes.addressForWrite(bytes.writePosition());
                    long bstart = bytes.start();
                    long bcap = bytes.realCapacity();
                    long canWrite = bcap - (bytes.writePosition() - bstart);
                    long lengthCount = batchAppender.writeMessages(address, canWrite, writeCount);
                    bytes.writeSkip((long)((int)lengthCount));
                    lastIndex += lengthCount >> 32;
                    count += lengthCount >> 32;
                    continue;
                }
                if (this.batchTmp == null) {
                    this.batchTmp = NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity((long)maxMsgSize);
                }
                try (DocumentContext dc = this.writingDocument();){
                    long lengthCount = batchAppender.writeMessages(this.batchTmp.addressForWrite(0L), maxMsgSize, 1);
                    int len = (int)lengthCount;
                    dc.wire().bytes().write(this.batchTmp, 4L, (long)(len - 4));
                }
                lastIndex = this.lastIndexAppended();
                ++count;
            } while (startTime + (long)timeoutMS > System.currentTimeMillis());
            return count;
        }

        @Override
        @Nullable
        public Wire wireForIndex() {
            return this.wireForIndex;
        }

        @Override
        public long timeoutMS() {
            return this.queue.timeoutMS;
        }

        void lastIndex(long index) {
            this.lastIndex = index;
        }

        public boolean recordHistory() {
            return this.sourceId() != 0;
        }

        void setCycle(int cycle) {
            if (cycle != this.cycle) {
                this.setCycle2(cycle, true);
            }
        }

        private void setCycle2(int cycle, boolean createIfAbsent) {
            if (cycle < 0) {
                throw new IllegalArgumentException("You can not have a cycle that starts before Epoch. cycle=" + cycle);
            }
            SingleChronicleQueue queue = this.queue;
            SingleChronicleQueueStore store = this.store;
            this.store = this.storePool.acquire(cycle, queue.epoch(), createIfAbsent);
            if (store != null) {
                this.storePool.release(store);
            }
            this.resetWires(queue);
            this.cycle = cycle;
            if (this.store == null) {
                return;
            }
            assert (this.store.refCount() > 0L);
            assert (this.wire.startUse());
            this.wire.parent((Object)this);
            this.wire.pauser((Pauser)queue.pauserSupplier.get());
            this.resetPosition();
            queue.onRoll(cycle);
        }

        private void resetWires(@NotNull ChronicleQueue queue) {
            WireType wireType = queue.wireType();
            Wire oldw = this.wire;
            Wire wire = this.wire = this.store == null ? null : this.createWire(wireType);
            assert (this.wire != oldw || this.wire == null);
            if (oldw != null) {
                SingleChronicleQueueExcerpts.releaseWireResources(oldw);
            }
            Wire old = this.wireForIndex;
            Wire wire2 = this.wireForIndex = this.store == null ? null : this.createWire(wireType);
            assert (this.wire != old || this.wire == null);
            if (old != null) {
                SingleChronicleQueueExcerpts.releaseWireResources(old);
            }
        }

        private Wire createWire(@NotNull WireType wireType) {
            Wire w = (Wire)wireType.apply((Object)this.store.bytes());
            if (this.store.dataVersion() > 0) {
                w.usePadding(true);
            }
            return w;
        }

        private void resetPosition() throws UnrecoverableTimeoutException {
            try {
                if (this.store == null || this.wire == null) {
                    return;
                }
                long position = this.store.writePosition();
                this.position(position, position);
                Bytes bytes = this.wire.bytes();
                assert (!CHECK_INDEX || this.checkPositionOfHeader(bytes));
                long headerNumber = this.store.lastSequenceNumber(this);
                this.wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, headerNumber + 1L) - 1L);
                assert (!CHECK_INDEX || this.wire.headerNumber() != -1L || this.checkIndex(this.wire.headerNumber(), this.positionOfHeader));
                bytes.writeLimit(bytes.capacity());
            }
            catch (StreamCorruptedException | BufferOverflowException e) {
                throw new AssertionError((Object)e);
            }
            assert (!CHECK_INDEX || this.checkWritePositionHeaderNumber());
        }

        private boolean checkPositionOfHeader(Bytes<?> bytes) {
            if (this.positionOfHeader == 0L) {
                return true;
            }
            int header = bytes.readVolatileInt(this.positionOfHeader);
            if (Wires.isReadyData((int)header)) {
                return true;
            }
            return header == Integer.MIN_VALUE;
        }

        @NotNull
        public DocumentContext writingDocument() throws UnrecoverableTimeoutException {
            return this.writingDocument(false);
        }

        @NotNull
        public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
            if (this.queue.isClosed.get()) {
                throw new IllegalStateException("Queue is closed");
            }
            if (this.queue.doubleBuffer && this.writeLock.locked() && !metaData) {
                this.context.isClosed = false;
                this.context.rollbackOnClose = false;
                this.context.buffered = true;
                this.context.wire = this.bufferWire.get();
                this.context.metaData(false);
            } else {
                this.writeLock.lock();
                int cycle = this.queue.cycle();
                if (this.wire == null) {
                    this.setWireIfNull(cycle);
                }
                if (this.cycle != cycle) {
                    this.rollCycleTo(cycle);
                }
                int safeLength = (int)this.queue.overlapSize();
                this.resetPosition();
                assert (!CHECK_INDEX || this.checkWritePositionHeaderNumber());
                this.openContext(metaData, safeLength);
            }
            return this.context;
        }

        private void setWireIfNull(int cycle) {
            int lastCycle = this.queue.lastCycle();
            if (lastCycle == Integer.MIN_VALUE) {
                lastCycle = cycle;
            } else {
                int firstCycle = this.queue.firstCycle();
                for (int cur = lastCycle - 1; cur >= firstCycle; --cur) {
                    this.setCycle2(cur, false);
                    if (this.wire != null && !this.store.writeEOF(this.wire, this.timeoutMS())) break;
                }
            }
            this.setCycle2(lastCycle, true);
        }

        private long writeHeader(@NotNull Wire wire, int safeLength) {
            Bytes bytes = wire.bytes();
            long pos = this.positionOfHeader;
            long lastPos = this.store.writePosition();
            if (pos < lastPos) {
                try {
                    wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, this.store.lastSequenceNumber(this)));
                }
                catch (StreamCorruptedException ex) {
                    Jvm.warn().on(this.getClass(), "Couldn't find last sequence", (Throwable)ex);
                }
            }
            int header = bytes.readVolatileInt(lastPos);
            assert (header != 0);
            lastPos += (long)(Wires.lengthOf((int)bytes.readVolatileInt(lastPos)) + 4);
            bytes.writePosition(lastPos);
            return wire.enterHeader(safeLength);
        }

        private void openContext(boolean metaData, int safeLength) {
            assert (this.wire != null);
            this.positionOfHeader = this.writeHeader(this.wire, safeLength);
            this.context.isClosed = false;
            this.context.rollbackOnClose = false;
            this.context.buffered = false;
            this.context.wire = this.wire;
            this.context.metaData(metaData);
        }

        boolean checkWritePositionHeaderNumber() {
            if (this.wire == null || this.wire.headerNumber() == Long.MIN_VALUE) {
                return true;
            }
            try {
                long pos = this.positionOfHeader;
                long seq1 = this.queue.rollCycle().toSequenceNumber(this.wire.headerNumber() + 1L) - 1L;
                long seq2 = this.store.sequenceForPosition(this, pos, true);
                if (seq1 != seq2) {
                    String message = "~~~~~~~~~~~~~~ thread: " + Thread.currentThread().getName() + " pos: " + pos + " header: " + this.wire.headerNumber() + " seq1: " + seq1 + " seq2: " + seq2;
                    AssertionError ae = new AssertionError((Object)message);
                    ((Throwable)((Object)ae)).printStackTrace();
                    throw ae;
                }
            }
            catch (Exception e) {
                Jvm.fatal().on(this.getClass(), (Throwable)e);
                throw Jvm.rethrow((Throwable)e);
            }
            return true;
        }

        @Override
        public int sourceId() {
            return this.queue.sourceId;
        }

        @Override
        public void writeBytes(@NotNull BytesStore bytes) throws UnrecoverableTimeoutException {
            this.writeLock.lock();
            try {
                int cycle = this.queue.cycle();
                if (this.wire == null) {
                    this.setWireIfNull(cycle);
                }
                if (this.cycle != cycle) {
                    this.rollCycleTo(cycle);
                }
                this.positionOfHeader = this.writeHeader(this.wire, (int)this.queue.overlapSize());
                assert (((AbstractWire)this.wire).isInsideHeader());
                this.beforeAppend(this.wire, this.wire.headerNumber() + 1L);
                Bytes wireBytes = this.wire.bytes();
                wireBytes.write(bytes);
                this.wire.updateHeader(this.positionOfHeader, false, 0);
                this.lastIndex(this.wire.headerNumber());
                this.lastPosition = this.positionOfHeader;
                this.lastCycle = cycle;
                this.store.writePosition(this.positionOfHeader);
                this.writeIndexForPosition(this.lastIndex, this.positionOfHeader);
            }
            catch (StreamCorruptedException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeBytes(long index, @NotNull BytesStore bytes) {
            if (this.queue.isClosed.get()) {
                throw new IllegalStateException("Queue is closed");
            }
            this.writeLock.lock();
            try {
                this.writeBytesInternal(index, bytes);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        protected void writeBytesInternal(long index, @NotNull BytesStore bytes) {
            this.writeBytesInternal(index, bytes, false);
        }

        protected void writeBytesInternal(long index, @NotNull BytesStore bytes, boolean metadata) {
            boolean rollbackDontClose;
            int cycle = this.queue.rollCycle().toCycle(index);
            if (this.wire == null) {
                this.setCycle2(cycle, true);
            } else if (this.cycle < cycle) {
                this.rollCycleTo(cycle);
            }
            boolean bl = rollbackDontClose = index != this.wire.headerNumber() + 1L;
            if (rollbackDontClose) {
                if (index > this.wire.headerNumber() + 1L) {
                    throw new IllegalStateException("Unable to move to index " + Long.toHexString(index) + " beyond the end of the queue, current: " + Long.toHexString(this.wire.headerNumber()));
                }
                LOG.warn("Trying to overwrite index {} which is before the end of the queue", (Object)Long.toHexString(index), (Object)new StackTrace());
                return;
            }
            this.writeBytesInternal(bytes, metadata);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeBytesInternal(@NotNull BytesStore bytes, boolean metadata) {
            assert (this.writeLock.locked());
            try {
                int safeLength = (int)this.queue.overlapSize();
                this.openContext(metadata, safeLength);
                try {
                    this.context.wire().bytes().write(bytes);
                }
                finally {
                    this.context.close(false);
                }
            }
            finally {
                this.context.isClosed = true;
            }
        }

        private void position(long position, long startOfMessage) {
            if (position > this.store.writePosition() + this.queue.blockSize()) {
                throw new IllegalArgumentException("pos: " + position + ", store.writePosition()=" + this.store.writePosition() + " queue.blockSize()=" + this.queue.blockSize());
            }
            this.position0(position, startOfMessage);
        }

        @Override
        public long lastIndexAppended() {
            if (this.lastIndex != Long.MIN_VALUE) {
                return this.lastIndex;
            }
            if (this.lastPosition == Long.MIN_VALUE || this.wire == null) {
                throw new IllegalStateException("nothing has been appended, so there is no last index");
            }
            try {
                long sequenceNumber = this.store.sequenceForPosition(this, this.lastPosition, true);
                long index = this.queue.rollCycle().toIndex(this.lastCycle, sequenceNumber);
                this.lastIndex(index);
                return index;
            }
            catch (Exception e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public int cycle() {
            if (this.cycle == Integer.MIN_VALUE) {
                int cycle = this.queue.lastCycle();
                if (cycle < 0) {
                    cycle = this.queue.cycle();
                }
                return cycle;
            }
            return this.cycle;
        }

        @Override
        @NotNull
        public SingleChronicleQueue queue() {
            return this.queue;
        }

        @Override
        public Runnable getCloserJob() {
            return () -> ((StoreAppender)this).close();
        }

        void beforeAppend(Wire wire, long index) {
        }

        private void rollCycleTo(int cycle) throws UnrecoverableTimeoutException {
            if (this.cycle == cycle) {
                throw new AssertionError();
            }
            this.store.writeEOF(this.wire, this.timeoutMS());
            int lastCycle = this.queue.lastCycle();
            if (lastCycle < cycle && lastCycle != this.cycle) {
                this.setCycle2(lastCycle, false);
                this.rollCycleTo(cycle);
            } else {
                this.setCycle2(cycle, true);
            }
        }

        void writeEndOfCycleIfRequired() {
            if (this.wire != null && this.queue.cycle() != this.cycle) {
                this.store.writeEOF(this.wire, this.timeoutMS());
            }
        }

        void writeIndexForPosition(long index, long position) throws UnrecoverableTimeoutException, StreamCorruptedException {
            long sequenceNumber = this.queue.rollCycle().toSequenceNumber(index);
            this.store.setPositionForSequenceNumber(this, sequenceNumber, position);
        }

        boolean checkIndex(long index, long position) {
            try {
                long seq1 = this.queue.rollCycle().toSequenceNumber(index + 1L) - 1L;
                long seq2 = this.store.sequenceForPosition(this, position, true);
                if (seq1 != seq2) {
                    long seq3 = this.store.indexing.linearScanByPosition(this.wireForIndex(), position, 0L, 0L, true);
                    System.out.println("Thread=" + Thread.currentThread().getName() + " pos: " + position + " seq1: " + Long.toHexString(seq1) + " seq2: " + Long.toHexString(seq2) + " seq3: " + Long.toHexString(seq3));
                    System.out.println(this.store.dump());
                    assert (seq1 == seq3) : "seq1=" + seq1 + ", seq3=" + seq3;
                    assert (seq1 == seq2) : "seq1=" + seq1 + ", seq2=" + seq2;
                }
            }
            catch (EOFException | StreamCorruptedException | UnrecoverableTimeoutException e) {
                throw new AssertionError((Object)e);
            }
            return true;
        }

        public String toString() {
            return "StoreAppender{queue=" + this.queue + ", cycle=" + this.cycle + ", position=" + this.positionOfHeader + ", lastIndex=" + this.lastIndex + ", lastPosition=" + this.lastPosition + ", lastCycle=" + this.lastCycle + '}';
        }

        void position0(long position, long startOfMessage) {
            this.positionOfHeader = position;
            this.wire.bytes().writePosition(startOfMessage);
        }

        class StoreAppenderContext
        implements DocumentContext {
            boolean isClosed;
            private boolean metaData = false;
            private boolean rollbackOnClose = false;
            private boolean buffered = false;
            @Nullable
            private Wire wire;

            StoreAppenderContext() {
            }

            public int sourceId() {
                return StoreAppender.this.sourceId();
            }

            public boolean isPresent() {
                return false;
            }

            public Wire wire() {
                return this.wire;
            }

            public boolean isMetaData() {
                return this.metaData;
            }

            public void metaData(boolean metaData) {
                this.metaData = metaData;
            }

            public boolean isClosed() {
                return this.isClosed;
            }

            public void rollbackOnClose() {
                this.rollbackOnClose = true;
            }

            public void close() {
                this.close(true);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void close(boolean unlock) {
                block25: {
                    block24: {
                        if (this.isClosed) {
                            LOG.warn("Already Closed, close was called twice.");
                            return;
                        }
                        try {
                            boolean interrupted;
                            boolean bl = interrupted = StoreAppender.this.checkInterrupts && Thread.currentThread().isInterrupted();
                            if (this.rollbackOnClose || interrupted) {
                                this.doRollback(interrupted);
                                return;
                            }
                            if (this.wire == StoreAppender.this.wire) {
                                try {
                                    this.wire.updateHeader(StoreAppender.this.positionOfHeader, this.metaData, 0);
                                }
                                catch (IllegalStateException e) {
                                    if (!StoreAppender.this.queue.isClosed()) throw e;
                                    if (!unlock) return;
                                    try {
                                        StoreAppender.this.writeLock.unlock();
                                        return;
                                    }
                                    catch (Exception ex) {
                                        Jvm.warn().on(this.getClass(), "Exception while unlocking: ", (Throwable)ex);
                                    }
                                    return;
                                }
                                StoreAppender.this.lastPosition = StoreAppender.this.positionOfHeader;
                                break block24;
                            }
                            if (this.wire == null) return;
                            break block25;
                        }
                        catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    StoreAppender.this.lastCycle = StoreAppender.this.cycle;
                    if (!this.metaData) {
                        StoreAppender.this.lastIndex(this.wire.headerNumber());
                        StoreAppender.this.store.writePosition(StoreAppender.this.positionOfHeader);
                        if (StoreAppender.this.lastIndex != Long.MIN_VALUE) {
                            StoreAppender.this.writeIndexForPosition(StoreAppender.this.lastIndex, StoreAppender.this.positionOfHeader);
                        }
                    }
                    if ($assertionsDisabled) return;
                    if (!CHECK_INDEX) return;
                    if (StoreAppender.this.checkWritePositionHeaderNumber()) return;
                    throw new AssertionError();
                }
                if (this.buffered) {
                    StoreAppender.this.writeBytes(this.wire.bytes());
                    return;
                }
                this.isClosed = true;
                StoreAppender.this.writeBytesInternal((BytesStore)this.wire.bytes(), this.metaData);
                this.wire = StoreAppender.this.wire;
                return;
                finally {
                    if (unlock) {
                        try {
                            StoreAppender.this.writeLock.unlock();
                        }
                        catch (Exception ex) {
                            Jvm.warn().on(this.getClass(), "Exception while unlocking: ", (Throwable)ex);
                        }
                    }
                }
            }

            private void doRollback(boolean interrupted) {
                if (interrupted) {
                    LOG.warn("Thread is interrupted. Can't guarantee complete message, so not committing");
                }
                for (long i = StoreAppender.this.positionOfHeader; i <= this.wire.bytes().writePosition(); ++i) {
                    this.wire.bytes().writeByte(i, (byte)0);
                }
                long lastPosition = StoreAppender.this.lastPosition;
                StoreAppender.this.position0(lastPosition, lastPosition);
                ((AbstractWire)this.wire).forceNotInsideHeader();
            }

            public long index() throws IORuntimeException {
                if (this.wire.headerNumber() == Long.MIN_VALUE) {
                    try {
                        this.wire.headerNumber(StoreAppender.this.queue.rollCycle().toIndex(StoreAppender.this.cycle, StoreAppender.this.store.lastSequenceNumber(StoreAppender.this)));
                        long headerNumber0 = this.wire.headerNumber();
                        assert (((AbstractWire)this.wire).isInsideHeader());
                        return this.isMetaData() ? headerNumber0 : headerNumber0 + 1L;
                    }
                    catch (IOException e) {
                        throw new IORuntimeException((Throwable)e);
                    }
                }
                return this.isMetaData() ? Long.MIN_VALUE : this.wire.headerNumber() + 1L;
            }

            public boolean isNotComplete() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface InternalAppender
    extends ExcerptAppender {
        public void writeBytes(long var1, BytesStore var3);
    }
}

