/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.ExecutorService;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.threads.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QueueFileShrinkManager {

    public static final String THREAD_NAME = "queue-file-shrink-daemon";
    public static boolean RUN_SYNCHRONOUSLY = Boolean.getBoolean("chronicle.queue.synchronousFileShrinking");
    public static boolean DISABLE_QUEUE_FILE_SHRINKING = OS.isWindows() || Boolean.getBoolean("chronicle.queue.disableFileShrinking");
    private static final Logger LOG = LoggerFactory.getLogger(QueueFileShrinkManager.class);
    private static final ExecutorService executor = Threads.acquireExecutorService((String)"queue-file-shrink-daemon", (int)1, (boolean)true);

    public static void scheduleShrinking(File queueFile, long writePos) {
        if (DISABLE_QUEUE_FILE_SHRINKING) {
            return;
        }
        Runnable task = () -> {
            int i;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shrinking {} to {}", (Object)queueFile, (Object)writePos);
            }
            int timeout = 50;
            int n = i = OS.isWindows() ? 1 : 3;
            while (i >= 0) {
                try (RandomAccessFile raf = new RandomAccessFile(queueFile, "rw");){
                    raf.setLength(writePos);
                    break;
                }
                catch (IOException ex) {
                    if (ex.getMessage().contains("The requested operation cannot be performed on a file with a user-mapped section open")) {
                        LOG.debug("Failed to shrinking {} to {}, {}", new Object[]{queueFile, writePos, i == 0 ? "giving up" : "retrying"});
                        Jvm.pause((long)timeout);
                        timeout *= 2;
                    } else {
                        LOG.warn("Failed to shrink file " + queueFile, (Throwable)ex);
                        break;
                    }
                    --i;
                }
            }
        };
        if (RUN_SYNCHRONOUSLY) {
            task.run();
        } else {
            executor.submit(task);
        }
    }
}

