/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.queue.impl.table.AbstractTSQueueLock;
import net.openhft.chronicle.threads.Pauser;

public class TableStoreWriteLock
extends AbstractTSQueueLock
implements WriteLock {
    private static final String LOCK_KEY = "chronicle.write.lock";
    private static final long PID = Jvm.getProcessId();
    private final long timeout;

    public TableStoreWriteLock(File queueDirectoryPath, Supplier<Pauser> pauser, Long timeoutMs) {
        super(LOCK_KEY, queueDirectoryPath, pauser);
        this.timeout = timeoutMs;
    }

    @Override
    public void lock() {
        this.closeCheck();
        try {
            while (!this.lock.compareAndSwapValue(Long.MIN_VALUE, PID)) {
                if (Thread.interrupted()) {
                    throw new IllegalStateException("Interrupted");
                }
                this.pauser.pause(this.timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (TimeoutException e) {
            Jvm.warn().on(this.getClass(), "Couldn't acquire write lock after " + this.timeout + "ms for the lock file:" + this.path + ", overriding the lock. Lock was held by PID " + this.lock.getVolatileValue());
            this.forceUnlock();
            this.lock();
        }
        finally {
            this.pauser.reset();
        }
    }

    @Override
    public void unlock() {
        this.closeCheck();
        if (!this.lock.compareAndSwapValue(PID, Long.MIN_VALUE)) {
            Jvm.warn().on(this.getClass(), "Write lock was unlocked by someone else!");
        }
    }

    @Override
    public boolean locked() {
        return this.lock.getVolatileValue() != Long.MIN_VALUE;
    }
}

