/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.reader;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.reader.MessageToTextQueueEntryHandler;
import net.openhft.chronicle.queue.reader.MethodReaderQueueEntryHandler;
import net.openhft.chronicle.queue.reader.QueueEntryHandler;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;

public final class ChronicleReader {
    private static final long UNSET_VALUE = Long.MIN_VALUE;
    private final List<Pattern> inclusionRegex = new ArrayList<Pattern>();
    private final List<Pattern> exclusionRegex = new ArrayList<Pattern>();
    private final Pauser pauser = Pauser.balanced();
    private Path basePath;
    private long startIndex = Long.MIN_VALUE;
    private boolean tailInputSource = false;
    private long maxHistoryRecords = Long.MIN_VALUE;
    private boolean readOnly = true;
    private Consumer<String> messageSink;
    private Function<ExcerptTailer, DocumentContext> pollMethod = ExcerptTailer::readingDocument;
    private Supplier<QueueEntryHandler> entryHandlerFactory = MessageToTextQueueEntryHandler::new;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            long lastObservedTailIndex;
            long highestReachedIndex = 0L;
            boolean isFirstIteration = true;
            block35: do {
                try (SingleChronicleQueue queue = this.createQueue();
                     QueueEntryHandler messageConverter = this.entryHandlerFactory.get();){
                    ExcerptTailer tailer = queue.createTailer();
                    if (highestReachedIndex != 0L) {
                        tailer.moveToIndex(highestReachedIndex);
                    }
                    Bytes textConversionTarget = Bytes.elasticByteBuffer();
                    try {
                        this.moveToSpecifiedPosition(queue, tailer, isFirstIteration);
                        lastObservedTailIndex = tailer.index();
                        while (!Thread.currentThread().isInterrupted()) {
                            DocumentContext dc = this.pollMethod.apply(tailer);
                            Throwable throwable = null;
                            try {
                                if (!dc.isPresent()) {
                                    if (this.tailInputSource) {
                                        this.pauser.pause();
                                    }
                                    continue block35;
                                }
                                this.pauser.reset();
                                messageConverter.accept(dc.wire(), text -> this.applyFiltersAndLog((String)text, tailer.index()));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (dc == null) continue;
                                if (throwable != null) {
                                    try {
                                        dc.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                dc.close();
                            }
                        }
                    }
                    finally {
                        textConversionTarget.release();
                        highestReachedIndex = tailer.index();
                        isFirstIteration = false;
                    }
                }
            } while (this.tailInputSource || this.queueHasBeenModifiedSinceLastCheck(lastObservedTailIndex));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    ChronicleReader withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public ChronicleReader withMessageSink(Consumer<String> messageSink) {
        this.messageSink = messageSink;
        return this;
    }

    public ChronicleReader withBasePath(Path path) {
        this.basePath = path;
        return this;
    }

    public ChronicleReader withInclusionRegex(String regex) {
        this.inclusionRegex.add(Pattern.compile(regex));
        return this;
    }

    public ChronicleReader withExclusionRegex(String regex) {
        this.exclusionRegex.add(Pattern.compile(regex));
        return this;
    }

    public ChronicleReader withStartIndex(long index) {
        this.startIndex = index;
        return this;
    }

    public ChronicleReader tail() {
        this.tailInputSource = true;
        return this;
    }

    public ChronicleReader historyRecords(long maxHistoryRecords) {
        this.maxHistoryRecords = maxHistoryRecords;
        return this;
    }

    public ChronicleReader asMethodReader() {
        this.entryHandlerFactory = MethodReaderQueueEntryHandler::new;
        return this;
    }

    ChronicleReader withDocumentPollMethod(Function<ExcerptTailer, DocumentContext> pollMethod) {
        this.pollMethod = pollMethod;
        return this;
    }

    private boolean queueHasBeenModifiedSinceLastCheck(long lastObservedTailIndex) {
        long currentTailIndex = this.getCurrentTailIndex();
        return currentTailIndex > lastObservedTailIndex;
    }

    private void moveToSpecifiedPosition(ChronicleQueue ic, ExcerptTailer tailer, boolean isFirstIteration) {
        if (ChronicleReader.isSet(this.startIndex) && isFirstIteration) {
            if (this.startIndex < ic.firstIndex()) {
                throw new IllegalArgumentException(String.format("startIndex %d is less than first index %d", this.startIndex, ic.firstIndex()));
            }
            this.messageSink.accept("Waiting for startIndex " + this.startIndex);
            while (!tailer.moveToIndex(this.startIndex)) {
                Jvm.pause((long)100L);
            }
        }
        if (ChronicleReader.isSet(this.maxHistoryRecords) && isFirstIteration) {
            tailer.toEnd();
            tailer.moveToIndex(Math.max(ic.firstIndex(), tailer.index() - this.maxHistoryRecords));
        } else if (this.tailInputSource && isFirstIteration) {
            tailer.toEnd();
        }
    }

    private long getCurrentTailIndex() {
        try (SingleChronicleQueue queue = this.createQueue();){
            long l = queue.createTailer().toEnd().index();
            return l;
        }
    }

    @NotNull
    private SingleChronicleQueue createQueue() {
        if (!Files.exists(this.basePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path %s does not exist", this.basePath));
        }
        return ((SingleChronicleQueueBuilder)((SingleChronicleQueueBuilder)SingleChronicleQueueBuilder.binary(this.basePath.toFile()).testBlockSize()).readOnly(this.readOnly)).build();
    }

    private void applyFiltersAndLog(String text, long index) {
        if ((this.inclusionRegex.isEmpty() || ChronicleReader.checkForMatches(this.inclusionRegex, text, true)) && (this.exclusionRegex.isEmpty() || ChronicleReader.checkForMatches(this.exclusionRegex, text, false))) {
            this.messageSink.accept("0x" + Long.toHexString(index) + ": ");
            this.messageSink.accept(text);
        }
    }

    private static boolean checkForMatches(List<Pattern> patterns, String text, boolean shouldBePresent) {
        for (Pattern pattern : patterns) {
            if (!shouldBePresent != pattern.matcher(text).find()) continue;
            return false;
        }
        return true;
    }

    private static boolean isSet(long configValue) {
        return configValue != Long.MIN_VALUE;
    }

    private static boolean isBinaryFormat(byte dataFormatIndicator) {
        return dataFormatIndicator < 0;
    }
}

