/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.BufferOverflowException;
import java.text.ParseException;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.bytes.util.DecoratedBufferUnderflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.TailerState;
import net.openhft.chronicle.queue.impl.CommonStore;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.NoDocumentContext;
import net.openhft.chronicle.queue.impl.single.PretoucherState;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreComponentReferenceHandler;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SourceContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueueExcerpts {
    private static final Logger LOG = LoggerFactory.getLogger(SingleChronicleQueueExcerpts.class);
    private static final long RELEASE_WARNING_THRESHOLD_NS = TimeUnit.MILLISECONDS.toNanos(300L);

    private static void releaseWireResources(Wire wire) {
        StoreComponentReferenceHandler.queueForRelease(wire);
    }

    public static class StoreTailer
    implements ExcerptTailer,
    SourceContext,
    ExcerptContext {
        static final int INDEXING_LINEAR_SCAN_THRESHOLD = 70;
        @NotNull
        private final SingleChronicleQueue queue;
        private final StoreTailerContext context = new StoreTailerContext();
        private final int indexSpacingMask;
        private final ClosableResources closableResources;
        long index;
        @Nullable
        WireStore store;
        private int cycle;
        private long timeForNextCycle = Long.MAX_VALUE;
        private TailerDirection direction = TailerDirection.FORWARD;
        private boolean lazyIndexing = false;
        private Wire wireForIndex;
        private boolean readAfterReplicaAcknowledged;
        @NotNull
        private TailerState state = TailerState.UNINITIALISED;
        private long indexAtCreation = Long.MIN_VALUE;
        private boolean readingDocumentFound = false;
        private final MoveToState moveToState = new MoveToState();

        public StoreTailer(@NotNull SingleChronicleQueue queue) {
            this.queue = queue;
            this.setCycle(Integer.MIN_VALUE);
            this.index = 0L;
            queue.addCloseListener(this, StoreTailer::close);
            this.indexSpacingMask = queue.rollCycle().defaultIndexSpacing() - 1;
            this.closableResources = new ClosableResources(queue);
            queue.ensureThatRollCycleDoesNotConflictWithExistingQueueFiles();
        }

        private static boolean isReadOnly(Bytes bytes) {
            return bytes instanceof MappedBytes && ((MappedBytes)bytes).isBackingFileReadOnly();
        }

        public boolean readDocument(@NotNull ReadMarshallable reader) {
            try (DocumentContext dc = this.readingDocument(false);){
                if (!dc.isPresent()) {
                    boolean bl = false;
                    return bl;
                }
                reader.readMarshallable((WireIn)dc.wire());
            }
            return true;
        }

        @Override
        @NotNull
        public DocumentContext readingDocument() {
            if (!(this.direction != TailerDirection.NONE || this.index != this.indexAtCreation && this.index != 0L || this.readingDocumentFound)) {
                return NoDocumentContext.INSTANCE;
            }
            return this.readingDocument(false);
        }

        private void close() {
            Wire wire = this.context.wire();
            if (wire != null) {
                wire.bytes().release();
            }
            this.context.wire(null);
            Wire w0 = this.wireForIndex;
            if (w0 != null) {
                w0.bytes().release();
            }
            this.wireForIndex = null;
            if (this.store != null) {
                this.queue.release(this.store);
            }
            this.store = null;
        }

        @Override
        public Wire wire() {
            return this.context.wire();
        }

        @Override
        public Wire wireForIndex() {
            return this.wireForIndex;
        }

        @Override
        public long timeoutMS() {
            return this.queue.timeoutMS;
        }

        @Override
        public int sourceId() {
            return this.queue.sourceId;
        }

        @NotNull
        public String toString() {
            return "StoreTailer{index sequence=" + this.queue.rollCycle().toSequenceNumber(this.index) + ", index cycle=" + this.queue.rollCycle().toCycle(this.index) + ", store=" + this.store + ", queue=" + this.queue + '}';
        }

        @Override
        @NotNull
        public DocumentContext readingDocument(boolean includeMetaData) {
            if (this.queue.isClosed.get()) {
                throw new IllegalStateException("Queue is closed");
            }
            try {
                boolean next = false;
                boolean tryAgain = true;
                if (this.state == TailerState.FOUND_CYCLE) {
                    try {
                        next = this.inACycle(includeMetaData, true);
                        tryAgain = false;
                    }
                    catch (EOFException eof) {
                        this.state = TailerState.END_OF_CYCLE;
                    }
                }
                if (tryAgain) {
                    next = this.next0(includeMetaData);
                }
                if (this.context.present(next)) {
                    this.context.setStart(this.context.wire().bytes().readPosition() - 4L);
                    this.readingDocumentFound = true;
                    return this.context;
                }
                RollCycle rollCycle = this.queue.rollCycle();
                if (this.state == TailerState.CYCLE_NOT_FOUND && this.direction == TailerDirection.FORWARD) {
                    int firstCycle = this.queue.firstCycle();
                    if (rollCycle.toCycle(this.index) < firstCycle) {
                        this.toStart();
                    }
                } else if (!next && this.state == TailerState.CYCLE_NOT_FOUND && this.cycle != this.queue.cycle()) {
                    this.state = TailerState.END_OF_CYCLE;
                }
            }
            catch (StreamCorruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (UnrecoverableTimeoutException e) {
            }
            catch (DecoratedBufferUnderflowException e) {
                if (this.queue.isReadOnly()) {
                    Jvm.warn().on(StoreTailer.class, "Tried to read past the end of a read-only view. Underlying data store may have grown since this tailer was created.", (Throwable)e);
                }
                throw e;
            }
            return NoDocumentContext.INSTANCE;
        }

        private boolean next0(boolean includeMetaData) throws UnrecoverableTimeoutException, StreamCorruptedException {
            block9: for (int i = 0; i < 1000; ++i) {
                switch (this.state) {
                    case UNINITIALISED: {
                        long firstIndex = this.queue.firstIndex();
                        if (firstIndex == Long.MAX_VALUE) {
                            return false;
                        }
                        if (this.moveToIndexInternal(firstIndex)) continue block9;
                        return false;
                    }
                    case FOUND_CYCLE: {
                        try {
                            return this.inACycle(includeMetaData, true);
                        }
                        catch (EOFException eof) {
                            this.state = TailerState.END_OF_CYCLE;
                            continue block9;
                        }
                    }
                    case END_OF_CYCLE: {
                        long oldIndex = this.index;
                        int currentCycle = this.queue.rollCycle().toCycle(oldIndex);
                        long nextIndex = this.nextIndexWithNextAvailableCycle(currentCycle);
                        if (nextIndex != Long.MIN_VALUE) {
                            if (this.moveToIndexInternal(nextIndex)) {
                                this.state = TailerState.FOUND_CYCLE;
                                continue block9;
                            }
                            if (this.state == TailerState.END_OF_CYCLE) continue block9;
                            if (this.cycle < this.queue.lastCycle()) {
                                this.state = TailerState.END_OF_CYCLE;
                                continue block9;
                            }
                            int nextCycle = this.queue.rollCycle().toCycle(nextIndex);
                            this.cycle(nextCycle, false);
                            this.state = TailerState.CYCLE_NOT_FOUND;
                        } else {
                            this.state = TailerState.END_OF_CYCLE;
                        }
                        return false;
                    }
                    case BEYOND_START_OF_CYCLE: {
                        long nextIndex;
                        if (this.direction == TailerDirection.FORWARD) {
                            this.state = TailerState.UNINITIALISED;
                            continue block9;
                        }
                        if (this.direction == TailerDirection.BACKWARD) {
                            boolean foundCycle = this.cycle(this.queue.rollCycle().toCycle(this.index), false);
                            if (foundCycle) {
                                long lastSequenceNumberInThisCycle = this.store.sequenceForPosition(this, Long.MAX_VALUE, false);
                                nextIndex = this.queue.rollCycle().toIndex(this.cycle, lastSequenceNumberInThisCycle);
                                this.moveToIndexInternal(nextIndex);
                                this.state = TailerState.FOUND_CYCLE;
                                continue block9;
                            }
                            int cycle = this.queue.rollCycle().toCycle(this.index);
                            long nextIndex2 = this.nextIndexWithNextAvailableCycle(cycle);
                            if (nextIndex2 != Long.MIN_VALUE) {
                                this.moveToIndexInternal(nextIndex2);
                                this.state = TailerState.FOUND_CYCLE;
                                continue block9;
                            }
                            this.state = TailerState.BEYOND_START_OF_CYCLE;
                            return false;
                        }
                        throw new AssertionError((Object)("direction not set, direction=" + (Object)((Object)this.direction)));
                    }
                    case CYCLE_NOT_FOUND: {
                        if (this.index == Long.MIN_VALUE) {
                            if (this.store != null) {
                                this.queue.release(this.store);
                            }
                            this.store = null;
                            this.closableResources.storeReference = null;
                            return false;
                        }
                        if (this.moveToIndexInternal(this.index)) {
                            this.state = TailerState.FOUND_CYCLE;
                            continue block9;
                        }
                        return false;
                    }
                    default: {
                        throw new AssertionError((Object)("state=" + (Object)((Object)this.state)));
                    }
                }
            }
            throw new IllegalStateException("Unable to progress to the next cycle, state=" + (Object)((Object)this.state));
        }

        private boolean inACycle(boolean includeMetaData, boolean first) throws EOFException, StreamCorruptedException {
            Wire wire = this.wire();
            Bytes bytes = wire.bytes();
            bytes.readLimit(bytes.capacity());
            if (this.readAfterReplicaAcknowledged && this.inACycleCheckRep()) {
                return false;
            }
            if (this.direction != TailerDirection.FORWARD && this.inACycleNotForward()) {
                return false;
            }
            switch (wire.readDataHeader(includeMetaData)) {
                case NONE: {
                    return this.inACycleNone(includeMetaData, first, bytes);
                }
                case META_DATA: {
                    this.context.metaData(true);
                    break;
                }
                case DATA: {
                    this.context.metaData(false);
                }
            }
            this.inACycleFound(bytes);
            return true;
        }

        private boolean inACycleCheckRep() {
            long lastSequenceAck = this.store.lastAcknowledgedIndexReplicated();
            long seq = this.queue.rollCycle().toSequenceNumber(this.index);
            return seq > lastSequenceAck;
        }

        private boolean inACycleNotForward() {
            if (!this.moveToIndexInternal(this.index)) {
                try {
                    if (!this.moveToIndexInternal(this.index - 1L)) {
                        return true;
                    }
                }
                catch (RuntimeException e) {
                    return true;
                }
            }
            return false;
        }

        private void inACycleFound(Bytes<?> bytes) throws StreamCorruptedException {
            if ((this.index & (long)this.indexSpacingMask) == 0L) {
                this.indexEntry(bytes);
            }
            this.context.closeReadLimit(bytes.capacity());
            this.wire().readAndSetLength(bytes.readPosition());
            long end = bytes.readLimit();
            this.context.closeReadPosition(end);
        }

        private boolean inACycleNone(boolean includeMetaData, boolean first, Bytes<?> bytes) throws EOFException, StreamCorruptedException {
            long now = this.queue.time().currentTimeMillis();
            boolean cycleChange2 = now >= this.timeForNextCycle;
            return first && cycleChange2 && !StoreTailer.isReadOnly(bytes) && this.checkMoveToNextCycle(includeMetaData, bytes);
        }

        private void indexEntry(@NotNull Bytes<?> bytes) throws StreamCorruptedException {
            if (this.store.indexable(this.index) && !this.lazyIndexing && this.direction == TailerDirection.FORWARD && !this.context.isMetaData()) {
                this.store.setPositionForSequenceNumber(this, this.queue.rollCycle().toSequenceNumber(this.index), bytes.readPosition());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkMoveToNextCycle(boolean includeMetaData, @NotNull Bytes<?> bytes) throws EOFException, StreamCorruptedException {
            if (bytes.readWrite()) {
                long pos = bytes.readPosition();
                long lim = bytes.readLimit();
                long wlim = bytes.writeLimit();
                try {
                    bytes.writePosition(pos);
                    this.store.writeEOF(this.wire(), this.timeoutMS());
                }
                finally {
                    bytes.writeLimit(wlim);
                    bytes.readLimit(lim);
                    bytes.readPosition(pos);
                }
            } else {
                Jvm.debug().on(this.getClass(), "Unable to append EOF to ReadOnly store, skipping");
                long now = this.queue.time().currentTimeMillis();
                if (now >= this.timeForNextCycle + this.timeoutMS() * 2L) {
                    throw new EOFException();
                }
            }
            return this.inACycle(includeMetaData, false);
        }

        private long nextIndexWithNextAvailableCycle(int cycle) {
            long doubleCheck;
            long nextIndex;
            if (cycle == Integer.MIN_VALUE) {
                throw new AssertionError((Object)"cycle == Integer.MIN_VALUE");
            }
            do {
                int nextCycle;
                if ((nextIndex = this.nextIndexWithNextAvailableCycle0(cycle)) == Long.MIN_VALUE || (nextCycle = this.queue.rollCycle().toCycle(nextIndex)) != cycle + 1) continue;
                return nextIndex;
            } while (nextIndex != (doubleCheck = this.nextIndexWithNextAvailableCycle0(cycle)));
            if (nextIndex != Long.MIN_VALUE && this.queue.rollCycle().toCycle(nextIndex) - 1 != cycle) {
                LOG.debug("Rolled " + (this.queue.rollCycle().toCycle(nextIndex) - cycle) + " times to find the next cycle file. This can occur if your appenders have not written anything for a while, leaving the cycle files with a gap.");
            }
            return nextIndex;
        }

        private long nextIndexWithNextAvailableCycle0(int cycle) {
            if (cycle > this.queue.lastCycle() || this.direction == TailerDirection.NONE) {
                return Long.MIN_VALUE;
            }
            int nextCycle = cycle + this.direction.add();
            boolean found = this.cycle(nextCycle, false);
            if (found) {
                return this.nextIndexWithinFoundCycle(nextCycle);
            }
            try {
                int nextCycle0 = this.queue.nextCycle(this.cycle, this.direction);
                if (nextCycle0 == -1) {
                    return Long.MIN_VALUE;
                }
                return this.nextIndexWithinFoundCycle(nextCycle0);
            }
            catch (ParseException e) {
                throw new IllegalStateException(e);
            }
        }

        private long nextIndexWithinFoundCycle(int nextCycle) {
            this.state = TailerState.FOUND_CYCLE;
            if (this.direction == TailerDirection.FORWARD) {
                return this.queue.rollCycle().toIndex(nextCycle, 0L);
            }
            if (this.direction == TailerDirection.BACKWARD) {
                try {
                    long lastSequenceNumber0 = this.store.lastSequenceNumber(this);
                    return this.queue.rollCycle().toIndex(nextCycle, lastSequenceNumber0);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
            throw new IllegalStateException("direction=" + (Object)((Object)this.direction));
        }

        @Override
        public long index() {
            return this.index;
        }

        @Override
        public int cycle() {
            return this.cycle;
        }

        @Override
        public boolean moveToIndex(long index) {
            if (this.moveToState.canReuseLastIndexMove(index, this.state, this.direction, this.queue, this.wire())) {
                return true;
            }
            if (this.moveToState.indexIsCloseToAndAheadOfLastIndexMove(index, this.state, this.direction, this.queue)) {
                boolean found;
                long knownIndex = this.moveToState.lastMovedToIndex;
                boolean bl = found = this.store.linearScanTo(index, knownIndex, this, this.moveToState.readPositionAtLastMove) == ScanResult.FOUND;
                if (found) {
                    this.index(index);
                    this.moveToState.onSuccessfulScan(index, this.direction, this.wire().bytes().readPosition());
                }
                return found;
            }
            return this.moveToIndexInternal(index);
        }

        ScanResult moveToIndexResult(long index) {
            int cycle = this.queue.rollCycle().toCycle(index);
            long sequenceNumber = this.queue.rollCycle().toSequenceNumber(index);
            if (LOG.isTraceEnabled()) {
                Jvm.debug().on(this.getClass(), "moveToIndex: " + Long.toHexString(cycle) + " " + Long.toHexString(sequenceNumber));
            }
            if (!(cycle == this.cycle && this.state == TailerState.FOUND_CYCLE || this.cycle(cycle, false))) {
                return ScanResult.NOT_REACHED;
            }
            this.index(index);
            ScanResult scanResult = this.store.moveToIndexForRead(this, sequenceNumber);
            Bytes bytes = this.wire().bytes();
            if (scanResult == ScanResult.FOUND) {
                this.state = TailerState.FOUND_CYCLE;
                this.moveToState.onSuccessfulLookup(index, this.direction, bytes.readPosition());
                return scanResult;
            }
            if (scanResult == ScanResult.END_OF_FILE) {
                this.state = TailerState.END_OF_CYCLE;
                return scanResult;
            }
            bytes.readLimit(bytes.readPosition());
            return scanResult;
        }

        @Override
        @NotNull
        public final ExcerptTailer toStart() {
            assert (this.direction != TailerDirection.BACKWARD);
            int firstCycle = this.queue.firstCycle();
            if (firstCycle == Integer.MAX_VALUE) {
                this.state = TailerState.UNINITIALISED;
                return this;
            }
            if (firstCycle != this.cycle) {
                boolean found = this.cycle(firstCycle, false);
                assert (found || this.store == null);
                if (found) {
                    this.state = TailerState.FOUND_CYCLE;
                }
            }
            this.index(this.queue.rollCycle().toIndex(this.cycle, 0L));
            this.state = TailerState.FOUND_CYCLE;
            if (this.wire() != null) {
                this.wire().bytes().readPosition(0L);
            }
            return this;
        }

        private boolean moveToIndexInternal(long index) {
            this.moveToState.indexMoveCount++;
            ScanResult scanResult = this.moveToIndexResult(index);
            return scanResult == ScanResult.FOUND;
        }

        private long approximateLastIndex() {
            RollCycle rollCycle = this.queue.rollCycle();
            int lastCycle = this.queue.lastCycle();
            try {
                long sequenceNumber;
                if (lastCycle == Integer.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                WireStore wireStore = this.queue.storeForCycle(lastCycle, this.queue.epoch(), false);
                this.setCycle(lastCycle);
                assert (wireStore != null);
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                if (this.store != wireStore) {
                    this.store = wireStore;
                    this.closableResources.storeReference = wireStore;
                    this.resetWires();
                }
                if ((sequenceNumber = this.store.lastSequenceNumber(this)) == -1L) {
                    return rollCycle.toIndex(lastCycle, 0L);
                }
                return rollCycle.toIndex(lastCycle, sequenceNumber);
            }
            catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
                throw new IllegalStateException(e);
            }
        }

        private boolean headerNumberCheck(@NotNull AbstractWire wire) {
            wire.headNumberCheck((actual, position) -> {
                try {
                    long expecting = this.store.sequenceForPosition(this, position, false);
                    if (actual == expecting) {
                        return true;
                    }
                    LOG.error("", (Throwable)((Object)new AssertionError((Object)("header number check failed expecting=" + expecting + "  !=  actual=" + actual))));
                    return false;
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                    return false;
                }
            });
            return true;
        }

        private void resetWires() {
            WireType wireType = this.queue.wireType();
            AbstractWire wire = (AbstractWire)this.readAnywhere((Wire)wireType.apply((Object)this.store.bytes()));
            assert (this.headerNumberCheck(wire));
            this.context.wire(wire);
            wire.parent((Object)this);
            Wire wireForIndexOld = this.wireForIndex;
            this.wireForIndex = this.readAnywhere((Wire)wireType.apply((Object)this.store.bytes()));
            this.closableResources.wireForIndexReference = this.wireForIndex.bytes();
            this.closableResources.wireReference = wire.bytes();
            assert (this.headerNumberCheck((AbstractWire)this.wireForIndex));
            if (wireForIndexOld != null) {
                SingleChronicleQueueExcerpts.releaseWireResources(wireForIndexOld);
            }
        }

        @NotNull
        private Wire readAnywhere(@NotNull Wire wire) {
            Bytes bytes = wire.bytes();
            bytes.readLimit(bytes.capacity());
            return wire;
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() {
            long index = this.approximateLastIndex();
            if (index == Long.MIN_VALUE) {
                if (this.state() == TailerState.CYCLE_NOT_FOUND) {
                    this.state = TailerState.UNINITIALISED;
                }
                return this;
            }
            ScanResult scanResult = this.moveToIndexResult(index);
            block0 : switch (scanResult) {
                case NOT_FOUND: {
                    if (this.moveToIndexResult(index - 1L) != ScanResult.FOUND) break;
                    this.state = TailerState.FOUND_CYCLE;
                    break;
                }
                case FOUND: {
                    if (this.direction != TailerDirection.FORWARD) break;
                    ScanResult result = this.moveToIndexResult(++index);
                    switch (result) {
                        case FOUND: {
                            this.state = TailerState.FOUND_CYCLE;
                            break block0;
                        }
                        case NOT_REACHED: {
                            throw new IllegalStateException("NOT_REACHED after FOUND");
                        }
                        case NOT_FOUND: {
                            this.state = TailerState.FOUND_CYCLE;
                            break block0;
                        }
                        case END_OF_FILE: {
                            this.state = TailerState.END_OF_CYCLE;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unknown ScanResult: " + (Object)((Object)result));
                }
                case NOT_REACHED: {
                    this.approximateLastIndex();
                    throw new IllegalStateException("NOT_REACHED index: " + Long.toHexString(index));
                }
                case END_OF_FILE: {
                    this.state = TailerState.END_OF_CYCLE;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown ScanResult: " + (Object)((Object)scanResult));
                }
            }
            return this;
        }

        @Override
        public TailerDirection direction() {
            return this.direction;
        }

        @Override
        @NotNull
        public ExcerptTailer direction(TailerDirection direction) {
            TailerDirection oldDirection = this.direction();
            this.direction = direction;
            if (oldDirection == TailerDirection.BACKWARD && direction == TailerDirection.FORWARD) {
                this.moveToIndexInternal(this.index);
            }
            return this;
        }

        @Override
        @NotNull
        public RollingChronicleQueue queue() {
            return this.queue;
        }

        @Override
        public Runnable getCloserJob() {
            return () -> this.closableResources.releaseResources();
        }

        public void releaseResources() {
            this.queue.removeCloseListener(this);
            this.getCloserJob().run();
        }

        private void incrementIndex() {
            RollCycle rollCycle = this.queue.rollCycle();
            long seq = rollCycle.toSequenceNumber(this.index);
            int cycle = rollCycle.toCycle(this.index);
            seq += (long)this.direction.add();
            switch (this.direction) {
                case NONE: {
                    break;
                }
                case FORWARD: {
                    if (rollCycle.toSequenceNumber(seq) >= seq) break;
                    this.cycle(cycle + 1, false);
                    seq = 0L;
                    break;
                }
                case BACKWARD: {
                    if (seq >= 0L) break;
                    this.windBackCycle(cycle);
                    return;
                }
            }
            this.index = rollCycle.toIndex(cycle, seq);
        }

        private void windBackCycle(int cycle) {
            if (this.tryWindBack(cycle - 1)) {
                return;
            }
            --cycle;
            long first = this.queue.firstCycle();
            while ((long)cycle >= first) {
                if (this.tryWindBack(cycle)) {
                    return;
                }
                --cycle;
            }
            this.index(this.queue.rollCycle().toIndex(cycle, -1L));
            this.state = TailerState.BEYOND_START_OF_CYCLE;
        }

        private boolean tryWindBack(int cycle) {
            long count = this.queue.exceptsPerCycle(cycle);
            if (count <= 0L) {
                return false;
            }
            RollCycle rollCycle = this.queue.rollCycle();
            this.moveToIndexInternal(rollCycle.toIndex(cycle, count - 1L));
            this.state = TailerState.FOUND_CYCLE;
            return true;
        }

        void index(long index) {
            this.index = index;
            if (this.indexAtCreation == Long.MIN_VALUE) {
                this.indexAtCreation = index;
            }
            this.moveToState.reset();
        }

        private boolean cycle(int cycle, boolean createIfAbsent) {
            if (this.cycle == cycle && this.state == TailerState.FOUND_CYCLE) {
                return true;
            }
            WireStore nextStore = this.queue.storeForCycle(cycle, this.queue.epoch(), createIfAbsent);
            if (nextStore == null && this.store == null) {
                return false;
            }
            if (nextStore == null) {
                this.state = this.direction == TailerDirection.BACKWARD ? TailerState.BEYOND_START_OF_CYCLE : TailerState.CYCLE_NOT_FOUND;
                return false;
            }
            if (this.store != null) {
                this.queue.release(this.store);
            }
            if (nextStore == this.store) {
                return true;
            }
            this.context.wire(null);
            this.store = nextStore;
            this.closableResources.storeReference = nextStore;
            this.state = TailerState.FOUND_CYCLE;
            this.setCycle(cycle);
            this.resetWires();
            Wire wire = this.wire();
            wire.parent((Object)this);
            wire.pauser(this.queue.pauserSupplier.get());
            return true;
        }

        void release() {
            if (this.store != null) {
                this.queue.release(this.store);
                this.store = null;
                this.closableResources.storeReference = null;
            }
            this.state = TailerState.UNINITIALISED;
        }

        @Override
        public void readAfterReplicaAcknowledged(boolean readAfterReplicaAcknowledged) {
            this.readAfterReplicaAcknowledged = readAfterReplicaAcknowledged;
        }

        @Override
        public boolean readAfterReplicaAcknowledged() {
            return this.readAfterReplicaAcknowledged;
        }

        @Override
        @NotNull
        public TailerState state() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ExcerptTailer afterLastWritten(@NotNull ChronicleQueue queue) {
            if (queue == this.queue) {
                throw new IllegalArgumentException("You must pass the queue written to, not the queue read");
            }
            ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
            StringBuilder sb = new StringBuilder();
            VanillaMessageHistory veh = new VanillaMessageHistory();
            veh.addSourceDetails(false);
            while (true) {
                DocumentContext context = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    if (!context.isData()) {
                        this.toStart();
                        StoreTailer storeTailer = this;
                        return storeTailer;
                    }
                    ValueIn valueIn = context.wire().readEventName(sb);
                    if (!StringUtils.isEqual((CharSequence)"history", (CharSequence)sb)) continue;
                    Wire wire = context.wire();
                    Object parent = wire.parent();
                    try {
                        wire.parent(null);
                        valueIn.marshallable((ReadMarshallable)veh);
                    }
                    finally {
                        wire.parent(parent);
                    }
                    int i = veh.sources() - 1;
                    if (i < 0 || veh.sourceId(i) != this.sourceId()) continue;
                    long sourceIndex = veh.sourceIndex(i);
                    if (!this.moveToIndexInternal(sourceIndex)) {
                        String errorMessage = String.format("Unable to move to sourceIndex %d, which was determined to be the last entry written to queue %s", sourceIndex, queue);
                        throw new IORuntimeException(errorMessage);
                    }
                    try (DocumentContext content = this.readingDocument();){
                        if (!content.isPresent()) {
                            String errorMessage = String.format("No readable document found at sourceIndex %d", sourceIndex + 1L);
                            throw new IORuntimeException(errorMessage);
                        }
                    }
                    StoreTailer storeTailer = this;
                    return storeTailer;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    context.close();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @UsedViaReflection
        public void lastAcknowledgedIndexReplicated(long acknowledgeIndex) {
            Jvm.debug().on(this.getClass(), "received lastAcknowledgedIndexReplicated=" + Long.toHexString(acknowledgeIndex) + " ,file=" + this.queue().file().getAbsolutePath());
            StoreTailer temp = this.queue.acquireTailer();
            try {
                RollCycle rollCycle = this.queue.rollCycle();
                int cycle0 = rollCycle.toCycle(acknowledgeIndex);
                if (!temp.cycle(cycle0, false)) {
                    Jvm.warn().on(this.getClass(), "Got an acknowledge index " + Long.toHexString(acknowledgeIndex) + " for a cycle which could not found");
                    return;
                }
                if (temp.store == null) {
                    Jvm.warn().on(this.getClass(), "Got an acknowledge index " + Long.toHexString(acknowledgeIndex) + " discarded.");
                    return;
                }
                temp.store.lastAcknowledgedIndexReplicated(acknowledgeIndex);
            }
            finally {
                temp.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @UsedViaReflection
        public void lasIndexReplicated(long lastIndexReplicated) {
            Jvm.debug().on(this.getClass(), "received lastIndexReplicated=" + Long.toHexString(lastIndexReplicated) + " ,file=" + this.queue().file().getAbsolutePath());
            StoreTailer temp = this.queue.acquireTailer();
            try {
                RollCycle rollCycle = this.queue.rollCycle();
                int cycle0 = rollCycle.toCycle(lastIndexReplicated);
                if (!temp.cycle(cycle0, false)) {
                    Jvm.warn().on(this.getClass(), "Got an acknowledge index " + Long.toHexString(lastIndexReplicated) + " for a cycle which could not found");
                    return;
                }
                if (temp.store == null) {
                    Jvm.warn().on(this.getClass(), "Got an acknowledge index " + Long.toHexString(lastIndexReplicated) + " discarded.");
                    return;
                }
                temp.store.lastIndexReplicated(lastIndexReplicated);
            }
            finally {
                temp.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long lastAcknowledgedIndexReplicated() throws EOFException {
            StoreTailer temp = (StoreTailer)this.queue.acquireTailer().toEnd();
            try {
                long l = temp.store.lastAcknowledgedIndexReplicated();
                return l;
            }
            finally {
                temp.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long lastIndexReplicated(long index) {
            StoreTailer temp = (StoreTailer)this.queue.acquireTailer().toEnd();
            try {
                long l = temp.store.lastIndexReplicated();
                return l;
            }
            finally {
                temp.release();
            }
        }

        public void setCycle(int cycle) {
            this.cycle = cycle;
            this.timeForNextCycle = cycle == Integer.MIN_VALUE ? Long.MAX_VALUE : (long)(cycle + 1) * (long)this.queue.rollCycle().length() + this.queue.epoch();
        }

        int getIndexMoveCount() {
            return this.moveToState.indexMoveCount;
        }

        private static final class MoveToState {
            private long lastMovedToIndex = Long.MIN_VALUE;
            private TailerDirection directionAtLastMoveTo = TailerDirection.NONE;
            private long readPositionAtLastMove = Long.MIN_VALUE;
            private int indexMoveCount = 0;

            private MoveToState() {
            }

            void onSuccessfulLookup(long movedToIndex, TailerDirection direction, long readPosition) {
                this.lastMovedToIndex = movedToIndex;
                this.directionAtLastMoveTo = direction;
                this.readPositionAtLastMove = readPosition;
            }

            void onSuccessfulScan(long movedToIndex, TailerDirection direction, long readPosition) {
                this.lastMovedToIndex = movedToIndex;
                this.directionAtLastMoveTo = direction;
                this.readPositionAtLastMove = readPosition;
            }

            void reset() {
                this.lastMovedToIndex = Long.MIN_VALUE;
                this.directionAtLastMoveTo = TailerDirection.NONE;
                this.readPositionAtLastMove = Long.MIN_VALUE;
            }

            private boolean indexIsCloseToAndAheadOfLastIndexMove(long index, TailerState state, TailerDirection direction, SingleChronicleQueue queue) {
                return this.lastMovedToIndex != Long.MIN_VALUE && index - this.lastMovedToIndex < 70L && state == TailerState.FOUND_CYCLE && direction == this.directionAtLastMoveTo && queue.rollCycle().toCycle(index) == queue.rollCycle().toCycle(this.lastMovedToIndex) && index > this.lastMovedToIndex;
            }

            private boolean canReuseLastIndexMove(long index, TailerState state, TailerDirection direction, SingleChronicleQueue queue, Wire wire) {
                return (wire == null || wire.bytes().readPosition() == this.readPositionAtLastMove) && index == this.lastMovedToIndex && index != 0L && state == TailerState.FOUND_CYCLE && direction == this.directionAtLastMoveTo && queue.rollCycle().toCycle(index) == queue.rollCycle().toCycle(this.lastMovedToIndex);
            }
        }

        class StoreTailerContext
        extends BinaryReadDocumentContext {
            boolean rollbackOnClose;

            public void rollbackOnClose() {
                this.rollbackOnClose = true;
            }

            StoreTailerContext() {
                super(null);
                this.rollbackOnClose = false;
            }

            public long index() {
                return StoreTailer.this.index();
            }

            public int sourceId() {
                return StoreTailer.this.sourceId();
            }

            public void close() {
                try {
                    if (!this.rollbackOnClose && this.isPresent()) {
                        StoreTailer.this.incrementIndex();
                        super.close();
                    } else {
                        this.present = false;
                        if (this.start != -1L) {
                            ((Bytes)this.wire.bytes().readPosition(this.start)).readLimit(this.readLimit);
                        }
                        this.start = -1L;
                    }
                }
                finally {
                    this.rollbackOnClose = false;
                }
            }

            boolean present(boolean present) {
                this.present = present;
                return this.present;
            }

            public void wire(@Nullable AbstractWire wire) {
                AbstractWire oldWire = this.wire;
                this.wire = wire;
                if (oldWire != null) {
                    SingleChronicleQueueExcerpts.releaseWireResources((Wire)oldWire);
                }
            }
        }
    }

    private static final class ClosableResources {
        private final SingleChronicleQueue queue;
        private volatile Bytes wireReference = null;
        private volatile Bytes bufferWireReference = null;
        private volatile Bytes wireForIndexReference = null;
        private volatile CommonStore storeReference = null;

        ClosableResources(SingleChronicleQueue queue) {
            this.queue = queue;
        }

        private static void releaseIfNotNull(Bytes bytesReference) {
            if (bytesReference != null && bytesReference.refCount() > 0L) {
                bytesReference.release();
            }
        }

        private void releaseResources() {
            ClosableResources.releaseIfNotNull(this.wireForIndexReference);
            ClosableResources.releaseIfNotNull(this.wireReference);
            ClosableResources.releaseIfNotNull(this.bufferWireReference);
            if (this.storeReference != null && this.storeReference.refCount() > 0L) {
                this.queue.release(this.storeReference);
            }
        }
    }

    static class StoreAppender
    implements ExcerptAppender,
    ExcerptContext,
    InternalAppender {
        public static final int REPEAT_WHILE_ROLLING = 128;
        @NotNull
        private final SingleChronicleQueue queue;
        @NotNull
        private final StoreAppenderContext context;
        private final ClosableResources closableResources;
        @NotNull
        private final HeaderWriteStrategy headerWriteStrategy;
        @Nullable
        WireStore store;
        private int cycle = Integer.MIN_VALUE;
        @Nullable
        private Wire wire;
        @Nullable
        private Wire bufferWire;
        @Nullable
        private Wire wireForIndex;
        private long position = 0L;
        @Nullable
        private volatile Thread appendingThread = null;
        private long lastIndex = Long.MIN_VALUE;
        private boolean lazyIndexing = false;
        private long lastPosition;
        private int lastCycle;
        @Nullable
        private PretoucherState pretoucher = null;
        private MarshallableOut.Padding padToCacheLines = MarshallableOut.Padding.SMART;

        StoreAppender(@NotNull SingleChronicleQueue queue, boolean progressOnContention) {
            this.queue = queue;
            queue.addCloseListener(this, StoreAppender::close);
            this.context = new StoreAppenderContext();
            this.closableResources = new ClosableResources(queue);
            queue.ensureThatRollCycleDoesNotConflictWithExistingQueueFiles();
            this.headerWriteStrategy = progressOnContention ? new HeaderWriteStrategyDefer() : new HeaderWriteStrategyOriginal();
        }

        @Override
        @NotNull
        public MarshallableOut.Padding padToCacheAlignMode() {
            return this.padToCacheLines;
        }

        @Override
        public void padToCacheAlign(MarshallableOut.Padding padToCacheLines) {
            this.padToCacheLines = padToCacheLines;
        }

        public void writeBytes(@NotNull WriteBytesMarshallable marshallable) throws UnrecoverableTimeoutException {
            try (DocumentContext dc = this.writingDocument();){
                marshallable.writeMarshallable((BytesOut)dc.wire().bytes());
                if (this.padToCacheAlignMode() != MarshallableOut.Padding.ALWAYS) {
                    ((StoreAppenderContext)dc).padToCacheAlign = false;
                }
            }
        }

        public void writeText(@NotNull CharSequence text) throws UnrecoverableTimeoutException {
            try (DocumentContext dc = this.writingDocument();){
                dc.wire().bytes().append8bit(text);
                if (this.padToCacheAlignMode() != MarshallableOut.Padding.ALWAYS) {
                    ((StoreAppenderContext)dc).padToCacheAlign = false;
                }
            }
        }

        void close() {
            Wire w0 = this.wireForIndex;
            this.wireForIndex = null;
            if (w0 != null) {
                w0.bytes().release();
            }
            Wire w = this.wire;
            this.wire = null;
            if (w != null) {
                w.bytes().release();
            }
            if (this.store != null) {
                this.queue.release(this.store);
            }
            if (this.bufferWire != null) {
                this.bufferWire.bytes().release();
                this.bufferWire = null;
            }
            this.store = null;
        }

        @Override
        public void pretouch() {
            Wire wire;
            this.setCycle(this.queue.cycle());
            if (this.pretoucher == null) {
                this.pretoucher = new PretoucherState(() -> this.store.writePosition());
            }
            if ((wire = this.wire) != null) {
                this.pretoucher.pretouch((MappedBytes)wire.bytes());
            }
        }

        @Override
        @Nullable
        public Wire wire() {
            return this.wire;
        }

        @Override
        @Nullable
        public Wire wireForIndex() {
            return this.wireForIndex;
        }

        @Override
        public long timeoutMS() {
            return this.queue.timeoutMS;
        }

        void lastIndex(long index) {
            this.lastIndex = index;
        }

        @Override
        @NotNull
        public ExcerptAppender lazyIndexing(boolean lazyIndexing) {
            this.lazyIndexing = lazyIndexing;
            try {
                this.resetPosition();
            }
            catch (EOFException ex) {
                throw new IllegalStateException("EOF found");
            }
            return this;
        }

        @Override
        public boolean lazyIndexing() {
            return this.lazyIndexing;
        }

        public boolean recordHistory() {
            return this.sourceId() != 0;
        }

        private void setCycle(int cycle) {
            if (cycle != this.cycle) {
                this.setCycle2(cycle, true);
            }
        }

        private void setCycle2(int cycle, boolean createIfAbsent) {
            if (cycle < 0) {
                throw new IllegalArgumentException("You can not have a cycle that starts before Epoch. cycle=" + cycle);
            }
            SingleChronicleQueue queue = this.queue;
            if (this.store != null) {
                queue.release(this.store);
            }
            this.store = queue.storeForCycle(cycle, queue.epoch(), createIfAbsent);
            this.closableResources.storeReference = this.store;
            this.resetWires(queue);
            this.cycle = cycle;
            assert (this.wire.startUse());
            this.wire.parent((Object)this);
            this.wire.pauser(queue.pauserSupplier.get());
            try {
                this.resetPosition();
                queue.onRoll(cycle);
            }
            catch (EOFException eof) {
                this.handleRoll(cycle);
            }
        }

        private void resetWires(@NotNull SingleChronicleQueue queue) {
            WireType wireType = queue.wireType();
            Wire oldw = this.wire;
            this.wire = (Wire)wireType.apply((Object)this.store.bytes());
            this.closableResources.wireReference = this.wire.bytes();
            if (oldw != null) {
                SingleChronicleQueueExcerpts.releaseWireResources(oldw);
            }
            Wire old = this.wireForIndex;
            this.wireForIndex = (Wire)wireType.apply((Object)this.store.bytes());
            this.closableResources.wireForIndexReference = this.wireForIndex.bytes();
            if (old != null) {
                SingleChronicleQueueExcerpts.releaseWireResources(old);
            }
        }

        private void resetPosition() throws UnrecoverableTimeoutException, EOFException {
            try {
                if (this.store == null || this.wire == null) {
                    return;
                }
                this.position(this.store.writePosition());
                Bytes bytes = this.wire.bytes();
                int header = bytes.readVolatileInt(this.position);
                if (header == -1073741824) {
                    throw new EOFException();
                }
                assert (this.position == 0L || Wires.isReadyData((int)header));
                bytes.writePosition(this.position + 4L + (long)Wires.lengthOf((int)header));
                if (this.lazyIndexing) {
                    this.wire.headerNumber(Long.MIN_VALUE);
                    return;
                }
                long headerNumber = this.store.sequenceForPosition(this, this.position, true);
                this.wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, headerNumber + 1L) - 1L);
                assert (this.lazyIndexing || this.wire.headerNumber() != -1L || this.checkIndex(this.wire.headerNumber(), this.position));
            }
            catch (StreamCorruptedException | BufferOverflowException e) {
                throw new AssertionError((Object)e);
            }
            assert (this.checkWritePositionHeaderNumber());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
            assert (this.checkAppendingThread());
            assert (this.checkWritePositionHeaderNumber());
            if (this.queue.isClosed.get()) {
                throw new IllegalStateException("Queue is closed");
            }
            boolean ok = false;
            try {
                int cycle = this.queue.cycle();
                if (this.wire == null) {
                    this.setCycle2(cycle, true);
                } else if (this.cycle != cycle) {
                    this.rollCycleTo(cycle);
                }
                int safeLength = (int)this.queue.overlapSize();
                ok = this.headerWriteStrategy.onContextOpen(metaData, safeLength);
                StoreAppenderContext storeAppenderContext = this.context;
                return storeAppenderContext;
            }
            finally {
                assert (ok || this.resetAppendingThread());
            }
        }

        private int handleRoll(int cycle) {
            assert (!((AbstractWire)this.wire).isInsideHeader());
            int qCycle = this.queue.cycle();
            if (cycle < this.queue.cycle()) {
                cycle = qCycle;
                this.setCycle2(cycle, true);
            } else if (cycle == qCycle) {
                this.setCycle2(++cycle, true);
            } else {
                throw new IllegalStateException("Found an EOF on the next cycle file, this next file, should not have an EOF as its cycle number is greater than the current cycle (based on the current time), this should only happen if it was written by a different appender set with a different EPOCH or different roll cycle.All your appenders ( that write to a given directory ) should have the same EPOCH and roll cycle qCycle=" + qCycle + ", cycle=" + cycle + ", queue-file=" + this.queue.file().getAbsolutePath());
            }
            return cycle;
        }

        boolean checkWritePositionHeaderNumber() {
            if (this.wire == null || this.wire.headerNumber() == Long.MIN_VALUE) {
                return true;
            }
            try {
                long pos1 = this.position;
                long seq1 = this.queue.rollCycle().toSequenceNumber(this.wire.headerNumber() + 1L) - 1L;
                long seq2 = this.store.sequenceForPosition(this, pos1, true);
                if (seq1 != seq2) {
                    String message = "~~~~~~~~~~~~~~ thread: " + Thread.currentThread().getName() + "  pos1: " + pos1 + " seq1: " + seq1 + " seq2: " + seq2;
                    System.err.println(message);
                    throw new AssertionError((Object)message);
                }
            }
            catch (IOException e) {
                Jvm.fatal().on(this.getClass(), (Throwable)e);
                throw Jvm.rethrow((Throwable)e);
            }
            return true;
        }

        @Override
        @NotNull
        public DocumentContext writingDocument(long index) {
            this.context.isClosed = false;
            assert (this.checkAppendingThread());
            this.context.wire = this.acquireBufferWire();
            this.context.wire.headerNumber(index);
            this.context.isClosed = false;
            return this.context;
        }

        @Override
        public int sourceId() {
            return this.queue.sourceId;
        }

        @Override
        public void writeBytes(@NotNull BytesStore bytes) throws UnrecoverableTimeoutException {
            this.append((m, w) -> {
                Bytes cfr_ignored_0 = (Bytes)w.bytes().write(m);
            }, bytes);
        }

        @NotNull
        Wire acquireBufferWire() {
            if (this.bufferWire == null) {
                this.bufferWire = (Wire)this.queue.wireType().apply((Object)Bytes.elasticByteBuffer());
                this.closableResources.bufferWireReference = this.bufferWire.bytes();
            } else {
                this.bufferWire.clear();
            }
            return this.bufferWire;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeBytes(long index, @NotNull BytesStore bytes) {
            if (this.queue.isClosed.get()) {
                throw new IllegalStateException("Queue is closed");
            }
            int cycle = this.queue.rollCycle().toCycle(index);
            if (this.wire == null) {
                this.setCycle2(cycle, true);
            } else if (this.cycle != cycle) {
                this.rollCycleTo(cycle);
            }
            int safeLength = (int)this.queue.overlapSize();
            assert (this.checkAppendingThread());
            try {
                boolean rollbackDontClose;
                long pos = this.wire.bytes().writePosition();
                this.headerWriteStrategy.onContextOpen(false, safeLength);
                boolean bl = rollbackDontClose = index != this.wire.headerNumber() + 1L;
                if (rollbackDontClose) {
                    this.wire.bytes().writeSkip(-4L);
                    this.wire.bytes().writeVolatileInt(this.wire.bytes().writePosition(), 0);
                    this.wire.bytes().writeLimit(this.wire.bytes().capacity());
                    this.position = pos;
                    ((AbstractWire)this.wire).forceNotInsideHeader();
                    if (index > this.wire.headerNumber() + 1L) {
                        throw new IllegalStateException("Unable to move to index " + Long.toHexString(index) + " beyond the end of the queue");
                    }
                    return;
                }
                try {
                    this.context.wire().bytes().write(bytes);
                }
                finally {
                    this.context.close();
                }
            }
            finally {
                this.appendingThread = null;
                this.context.isClosed = true;
            }
        }

        private void position(long position) {
            if (position > this.store.writePosition() + this.queue.blockSize()) {
                throw new IllegalArgumentException("pos: " + position + ", store.writePosition()=" + this.store.writePosition() + " queue.blockSize()=" + this.queue.blockSize());
            }
            this.position = position;
        }

        private void moveToIndexForWrite(long index) throws EOFException {
            if (this.wire != null && this.wire.headerNumber() == index) {
                return;
            }
            int cycle = this.queue.rollCycle().toCycle(index);
            ScanResult scanResult = this.moveToIndex(cycle, this.queue.rollCycle().toSequenceNumber(index));
            switch (scanResult) {
                case FOUND: {
                    throw new IllegalStateException("Unable to move to index " + Long.toHexString(index) + " as the index already exists");
                }
                case NOT_REACHED: {
                    throw new IllegalStateException("Unable to move to index " + Long.toHexString(index) + " beyond the end of the queue");
                }
                case NOT_FOUND: 
                case END_OF_FILE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown ScanResult: " + (Object)((Object)scanResult));
                }
            }
        }

        ScanResult moveToIndex(int cycle, long sequenceNumber) throws UnrecoverableTimeoutException {
            if (LOG.isDebugEnabled()) {
                Jvm.debug().on(this.getClass(), "moveToIndex: " + Long.toHexString(cycle) + " " + Long.toHexString(sequenceNumber));
            }
            if (this.cycle != cycle) {
                if (cycle > this.cycle) {
                    this.rollCycleTo(cycle);
                } else {
                    this.setCycle2(cycle, true);
                }
            }
            ScanResult scanResult = this.store.moveToIndexForRead(this, sequenceNumber);
            Bytes bytes = this.wire.bytes();
            if (scanResult == ScanResult.NOT_FOUND) {
                bytes.writePosition(bytes.readPosition());
                return scanResult;
            }
            bytes.readLimit(bytes.readPosition());
            return scanResult;
        }

        @Override
        public long lastIndexAppended() {
            if (this.lastIndex != Long.MIN_VALUE) {
                return this.lastIndex;
            }
            if (this.lastPosition == Long.MIN_VALUE || this.wire == null) {
                throw new IllegalStateException("nothing has been appended, so there is no last index");
            }
            try {
                long sequenceNumber = this.store.sequenceForPosition(this, this.lastPosition, true);
                long index = this.queue.rollCycle().toIndex(this.lastCycle, sequenceNumber);
                this.lastIndex(index);
                return index;
            }
            catch (Exception e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public int cycle() {
            if (this.cycle == Integer.MIN_VALUE) {
                int cycle = this.queue.lastCycle();
                if (cycle < 0) {
                    cycle = this.queue.cycle();
                }
                this.setCycle2(cycle, true);
            }
            return this.cycle;
        }

        @Override
        @NotNull
        public SingleChronicleQueue queue() {
            return this.queue;
        }

        @Override
        public Runnable getCloserJob() {
            return () -> this.closableResources.releaseResources();
        }

        void beforeAppend(Wire wire, long index) {
        }

        private <T> void append(@NotNull WireWriter<T> wireWriter, T writer) throws UnrecoverableTimeoutException {
            assert (this.checkAppendingThread());
            try {
                int cycle = this.queue.cycle();
                if (this.cycle != cycle || this.wire == null) {
                    this.rollCycleTo(cycle);
                }
                try {
                    this.position(this.store.writeHeader(this.wire, (int)this.queue.overlapSize(), this.timeoutMS()));
                    assert (((AbstractWire)this.wire).isInsideHeader());
                    this.beforeAppend(this.wire, this.wire.headerNumber() + 1L);
                    wireWriter.write(writer, (WireOut)this.wire);
                    this.wire.updateHeader(this.position, false);
                    this.lastIndex(this.wire.headerNumber());
                    this.lastPosition = this.position;
                    this.lastCycle = cycle;
                    this.store.writePosition(this.position);
                    this.writeIndexForPosition(this.lastIndex, this.position);
                }
                catch (EOFException theySeeMeRolling) {
                    try {
                        this.append2(wireWriter, writer);
                    }
                    catch (EOFException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            }
            catch (StreamCorruptedException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                assert (this.resetAppendingThread());
            }
        }

        private void rollCycleTo(int cycle) throws UnrecoverableTimeoutException {
            if (this.wire != null) {
                if (this.cycle == cycle) {
                    throw new AssertionError();
                }
                this.store.writeEOF(this.wire, this.timeoutMS());
            }
            this.setCycle2(cycle, true);
        }

        public void writeEndOfCycleIfRequired() {
            if (this.wire != null && this.queue.cycle() != this.cycle) {
                this.store.writeEOF(this.wire, this.timeoutMS());
            }
        }

        <T> void append2(@NotNull WireWriter<T> wireWriter, T writer) throws UnrecoverableTimeoutException, EOFException, StreamCorruptedException {
            this.setCycle(Math.max(this.queue.cycle(), this.cycle + 1));
            this.position(this.store.writeHeader(this.wire, (int)this.queue.overlapSize(), this.timeoutMS()));
            this.beforeAppend(this.wire, this.wire.headerNumber() + 1L);
            wireWriter.write(writer, (WireOut)this.wire);
            this.wire.updateHeader(this.position, false);
        }

        private boolean checkAppendingThread() {
            Thread appendingThread = this.appendingThread;
            Thread currentThread = Thread.currentThread();
            if (appendingThread != null) {
                if (appendingThread == currentThread) {
                    throw new IllegalStateException("Nested blocks of writingDocument() not supported");
                }
                throw new IllegalStateException("Attempting to use Appender in " + currentThread + " while used by " + appendingThread);
            }
            this.appendingThread = currentThread;
            return true;
        }

        private boolean resetAppendingThread() {
            if (this.appendingThread == null) {
                throw new IllegalStateException("Attempting to release Appender in " + Thread.currentThread() + " but already released");
            }
            this.appendingThread = null;
            return true;
        }

        void writeIndexForPosition(long index, long position) throws UnrecoverableTimeoutException, StreamCorruptedException {
            if (!this.lazyIndexing) {
                long sequenceNumber = this.queue.rollCycle().toSequenceNumber(index);
                this.store.setPositionForSequenceNumber(this, sequenceNumber, position);
            }
        }

        boolean checkIndex(long index, long position) {
            try {
                long seq1 = this.queue.rollCycle().toSequenceNumber(index + 1L) - 1L;
                long seq2 = this.store.sequenceForPosition(this, position, true);
                if (seq1 != seq2) {
                    long seq3 = ((SingleChronicleQueueStore)this.store).indexing.linearScanByPosition(this.wireForIndex(), position, 0L, 0L, true);
                    System.out.println("Thread=" + Thread.currentThread().getName() + " pos: " + position + " seq1: " + Long.toHexString(seq1) + " seq2: " + Long.toHexString(seq2) + " seq3: " + Long.toHexString(seq3));
                    System.out.println(this.store.dump());
                    assert (seq1 == seq3) : "seq1=" + seq1 + ", seq3=" + seq3;
                    assert (seq1 == seq2) : "seq1=" + seq1 + ", seq2=" + seq2;
                }
            }
            catch (EOFException | StreamCorruptedException | UnrecoverableTimeoutException e) {
                throw new AssertionError((Object)e);
            }
            return true;
        }

        public String toString() {
            return "StoreAppender{queue=" + this.queue + ", cycle=" + this.cycle + ", position=" + this.position + ", lastIndex=" + this.lastIndex + ", lazyIndexing=" + this.lazyIndexing + ", lastPosition=" + this.lastPosition + ", lastCycle=" + this.lastCycle + '}';
        }

        private class HeaderWriteStrategyDefer
        implements HeaderWriteStrategy {
            private HeaderWriteStrategyDefer() {
            }

            @Override
            public boolean onContextOpen(boolean metaData, int safeLength) {
                assert (StoreAppender.this.wire != null);
                long pos = StoreAppender.this.store.tryWriteHeader(StoreAppender.this.wire, safeLength);
                if (pos != -1L) {
                    StoreAppender.this.position(pos);
                    StoreAppender.this.context.wire = StoreAppender.this.wire;
                    ((StoreAppender)StoreAppender.this).context.deferredHeader = false;
                } else {
                    StoreAppender.this.context.wire = StoreAppender.this.acquireBufferWire();
                    ((StoreAppender)StoreAppender.this).context.deferredHeader = true;
                }
                ((StoreAppender)StoreAppender.this).context.isClosed = false;
                StoreAppender.this.context.rollbackOnClose = false;
                ((StoreAppender)StoreAppender.this).context.padToCacheAlign = StoreAppender.this.padToCacheAlignMode() != MarshallableOut.Padding.NEVER;
                StoreAppender.this.context.metaData(metaData);
                return true;
            }

            @Override
            public void onContextClose() {
                if (((StoreAppender)StoreAppender.this).context.deferredHeader) {
                    int safeLength = (int)StoreAppender.this.queue.overlapSize();
                    assert (StoreAppender.this.wire != null);
                    assert (StoreAppender.this.wire != StoreAppender.this.context.wire);
                    for (int i = 0; i < 128; ++i) {
                        try {
                            long pos = StoreAppender.this.store.writeHeader(StoreAppender.this.wire, safeLength, StoreAppender.this.timeoutMS());
                            StoreAppender.this.position(pos);
                            long length = StoreAppender.this.context.wire.bytes().copyTo((BytesStore)StoreAppender.this.wire.bytes());
                            StoreAppender.this.wire.bytes().writePosition(length + StoreAppender.this.wire.bytes().writePosition());
                            StoreAppender.this.context.wire = StoreAppender.this.wire;
                            return;
                        }
                        catch (EOFException theySeeMeRolling) {
                            StoreAppender.this.cycle = StoreAppender.this.handleRoll(StoreAppender.this.cycle);
                            continue;
                        }
                    }
                    throw new IllegalStateException("Unable to roll to the current cycle");
                }
            }
        }

        private class HeaderWriteStrategyOriginal
        implements HeaderWriteStrategy {
            private HeaderWriteStrategyOriginal() {
            }

            @Override
            public boolean onContextOpen(boolean metaData, int safeLength) {
                for (int i = 0; i < 128; ++i) {
                    try {
                        assert (StoreAppender.this.wire != null);
                        long pos = StoreAppender.this.store.writeHeader(StoreAppender.this.wire, safeLength, StoreAppender.this.timeoutMS());
                        StoreAppender.this.position(pos);
                        ((StoreAppender)StoreAppender.this).context.isClosed = false;
                        StoreAppender.this.context.rollbackOnClose = false;
                        StoreAppender.this.context.wire = StoreAppender.this.wire;
                        ((StoreAppender)StoreAppender.this).context.padToCacheAlign = StoreAppender.this.padToCacheAlignMode() != MarshallableOut.Padding.NEVER;
                        StoreAppender.this.context.metaData(metaData);
                        return true;
                    }
                    catch (EOFException theySeeMeRolling) {
                        StoreAppender.this.cycle = StoreAppender.this.handleRoll(StoreAppender.this.cycle);
                        continue;
                    }
                }
                throw new IllegalStateException("Unable to roll to the current cycle");
            }

            @Override
            public void onContextClose() {
            }
        }

        private static interface HeaderWriteStrategy {
            public void onContextClose();

            public boolean onContextOpen(boolean var1, int var2);
        }

        class StoreAppenderContext
        implements DocumentContext {
            boolean isClosed;
            boolean deferredHeader;
            boolean padToCacheAlign = true;
            private boolean metaData = false;
            private boolean rollbackOnClose = false;
            @Nullable
            private Wire wire;

            StoreAppenderContext() {
            }

            public int sourceId() {
                return StoreAppender.this.sourceId();
            }

            public boolean isPresent() {
                return false;
            }

            @NotNull
            public Wire wire() {
                return this.wire;
            }

            public boolean isMetaData() {
                return this.metaData;
            }

            public void metaData(boolean metaData) {
                this.metaData = metaData;
            }

            public boolean isClosed() {
                return this.isClosed;
            }

            public void rollbackOnClose() {
                this.rollbackOnClose = true;
            }

            public void close() {
                if (this.isClosed) {
                    LOG.warn("Already Closed, close was called twice.");
                    return;
                }
                try {
                    boolean interrupted = Thread.currentThread().isInterrupted();
                    if (this.rollbackOnClose || interrupted) {
                        if (interrupted) {
                            LOG.warn("Thread is interrupted. Can't guarantee complete message, so not committing");
                        }
                        for (long i = StoreAppender.this.position + 4L; i <= this.wire.bytes().writePosition(); ++i) {
                            this.wire.bytes().writeByte(i, (byte)0);
                        }
                        this.wire.bytes().writeVolatileInt(StoreAppender.this.position, 0);
                        this.wire.bytes().writePosition(StoreAppender.this.position);
                        ((AbstractWire)this.wire).forceNotInsideHeader();
                        return;
                    }
                    StoreAppender.this.headerWriteStrategy.onContextClose();
                    if (this.wire == StoreAppender.this.wire) {
                        if (this.padToCacheAlign) {
                            this.wire.padToCacheAlign();
                        }
                        boolean updatedHeader = false;
                        for (int i = 0; i < 128; ++i) {
                            try {
                                this.wire.updateHeader(StoreAppender.this.position, this.metaData);
                                updatedHeader = true;
                                break;
                            }
                            catch (EOFException theySeeMeRolling) {
                                StoreAppender.this.cycle = StoreAppender.this.handleRoll(StoreAppender.this.cycle);
                                continue;
                            }
                        }
                        if (!updatedHeader) {
                            throw new IllegalStateException("Unable to roll to the current cycle");
                        }
                        StoreAppender.this.lastPosition = StoreAppender.this.position;
                        StoreAppender.this.lastCycle = StoreAppender.this.cycle;
                        if (!this.metaData) {
                            StoreAppender.this.lastIndex(this.wire.headerNumber());
                            StoreAppender.this.store.writePosition(StoreAppender.this.position);
                            if (StoreAppender.this.lastIndex != Long.MIN_VALUE) {
                                StoreAppender.this.writeIndexForPosition(StoreAppender.this.lastIndex, StoreAppender.this.position);
                            } else assert (StoreAppender.this.lazyIndexing || StoreAppender.this.lastIndex == Long.MIN_VALUE || StoreAppender.this.checkIndex(StoreAppender.this.lastIndex, StoreAppender.this.position));
                        }
                        assert (StoreAppender.this.checkWritePositionHeaderNumber());
                    } else if (this.wire != null) {
                        this.isClosed = true;
                        assert (StoreAppender.this.resetAppendingThread());
                        StoreAppender.this.writeBytes(this.wire.headerNumber(), (BytesStore)this.wire.bytes());
                        this.wire = StoreAppender.this.wire;
                    }
                }
                catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
                    throw new IllegalStateException(e);
                }
                finally {
                    assert (this.isClosed || StoreAppender.this.resetAppendingThread());
                }
            }

            public long index() throws IORuntimeException {
                if (this.wire.headerNumber() == Long.MIN_VALUE) {
                    try {
                        long headerNumber0 = StoreAppender.this.queue.rollCycle().toIndex(StoreAppender.this.cycle, StoreAppender.this.store.sequenceForPosition(StoreAppender.this, StoreAppender.this.position, false));
                        assert (((AbstractWire)this.wire).isInsideHeader());
                        return this.isMetaData() ? headerNumber0 : headerNumber0 + 1L;
                    }
                    catch (IOException e) {
                        throw new IORuntimeException((Throwable)e);
                    }
                }
                return this.isMetaData() ? Long.MIN_VALUE : this.wire.headerNumber() + 1L;
            }

            public boolean isNotComplete() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @FunctionalInterface
    public static interface InternalAppender {
        public void writeBytes(long var1, BytesStore var3);
    }

    @FunctionalInterface
    static interface WireWriter<T> {
        public void write(T var1, WireOut var2);
    }
}

