/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.File;
import java.io.StreamCorruptedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SimpleStoreRecovery;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueueStore
implements WireStore {
    @NotNull
    final SCQIndexing indexing;
    @NotNull
    private final WireType wireType;
    @NotNull
    private final SCQRoll roll;
    @NotNull
    private final LongValue writePosition;
    private final MappedBytes mappedBytes;
    private final MappedFile mappedFile;
    @NotNull
    private final ReferenceCounter refCount;
    private final StoreRecovery recovery;
    private int deltaCheckpointInterval;
    @Nullable
    private LongValue lastAcknowledgedIndexReplicated;

    @UsedViaReflection
    private SingleChronicleQueueStore(WireIn wire) {
        assert (wire.startUse());
        try {
            this.wireType = (WireType)wire.read((WireKey)MetaDataField.wireType).object(WireType.class);
            assert (this.wireType != null);
            this.writePosition = wire.newLongReference();
            wire.read((WireKey)MetaDataField.writePosition).int64(this.writePosition);
            this.roll = (SCQRoll)wire.read((WireKey)MetaDataField.roll).typedMarshallable();
            this.mappedBytes = (MappedBytes)wire.bytes();
            this.mappedFile = this.mappedBytes.mappedFile();
            this.refCount = ReferenceCounter.onReleased(this::onCleanup);
            this.indexing = (SCQIndexing)wire.read((WireKey)MetaDataField.indexing).typedMarshallable();
            assert (this.indexing != null);
            this.indexing.writePosition = this.writePosition;
            this.lastAcknowledgedIndexReplicated = wire.bytes().readRemaining() > 0L ? wire.read((WireKey)MetaDataField.lastAcknowledgedIndexReplicated).int64ForBinding(null) : null;
            this.recovery = wire.bytes().readRemaining() > 0L ? (StoreRecovery)wire.read((WireKey)MetaDataField.recovery).typedMarshallable() : new SimpleStoreRecovery();
            this.deltaCheckpointInterval = wire.bytes().readRemaining() > 0L ? wire.read((WireKey)MetaDataField.deltaCheckpointInterval).int32() : -1;
        }
        finally {
            assert (wire.endUse());
        }
    }

    public SingleChronicleQueueStore(@Nullable RollCycle rollCycle, @NotNull WireType wireType, @NotNull MappedBytes mappedBytes, long epoch, int indexCount, int indexSpacing, StoreRecovery recovery, int deltaCheckpointInterval) {
        this.recovery = recovery;
        this.roll = new SCQRoll(rollCycle, epoch);
        this.wireType = wireType;
        this.mappedBytes = mappedBytes;
        this.mappedFile = mappedBytes.mappedFile();
        this.refCount = ReferenceCounter.onReleased(this::onCleanup);
        indexCount = Maths.nextPower2((int)indexCount, (int)8);
        indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        this.indexing = new SCQIndexing(wireType, indexCount, indexSpacing);
        this.indexing.writePosition = this.writePosition = (LongValue)wireType.newLongReference().get();
        this.lastAcknowledgedIndexReplicated = (LongValue)wireType.newLongReference().get();
        this.deltaCheckpointInterval = deltaCheckpointInterval;
    }

    public static void dumpStore(Wire wire) {
        Bytes bytes = wire.bytes();
        bytes.readPositionUnlimited(0L);
        Jvm.debug().on(SingleChronicleQueueStore.class, Wires.fromSizePrefixedBlobs((WireIn)wire));
    }

    public static String dump(String directoryFilePath) {
        SingleChronicleQueue q = SingleChronicleQueueBuilder.binary(directoryFilePath).build();
        return q.dump();
    }

    @Override
    public WireType wireType() {
        return this.wireType;
    }

    @Override
    public File file() {
        return this.mappedFile == null ? null : this.mappedFile.file();
    }

    @Override
    public long lastAcknowledgedIndexReplicated() {
        return this.lastAcknowledgedIndexReplicated == null ? -1L : this.lastAcknowledgedIndexReplicated.getVolatileValue();
    }

    @Override
    public void lastAcknowledgedIndexReplicated(long newValue) {
        if (this.lastAcknowledgedIndexReplicated != null) {
            this.lastAcknowledgedIndexReplicated.setMaxValue(newValue);
        }
    }

    @Override
    public String dump() {
        MappedBytes bytes = MappedBytes.mappedBytes((MappedFile)this.mappedFile);
        try {
            bytes.readLimit(bytes.realCapacity());
            String string = Wires.fromSizePrefixedBlobs((Bytes)bytes);
            return string;
        }
        finally {
            bytes.release();
        }
    }

    @Override
    public long writePosition() {
        return this.writePosition.getVolatileValue();
    }

    @Override
    public WireStore writePosition(long position) {
        assert (this.writePosition.getVolatileValue() + this.mappedFile.chunkSize() > position);
        int header = this.mappedBytes.readVolatileInt(position);
        if (!Wires.isReadyData((int)header)) {
            throw new AssertionError();
        }
        this.writePosition.setMaxValue(position);
        return this;
    }

    @Override
    public long epoch() {
        return this.roll.epoch();
    }

    @Override
    public ScanResult moveToIndexForRead(@NotNull ExcerptContext ec, long index) {
        try {
            return this.indexing.moveToIndex(this.recovery, ec, index);
        }
        catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
            return ScanResult.NOT_REACHED;
        }
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    public void close() {
        while (this.refCount.get() > 0L) {
            this.refCount.release();
        }
    }

    @Override
    @NotNull
    public MappedBytes bytes() {
        return MappedBytes.mappedBytes((MappedFile)this.mappedFile);
    }

    @Override
    public long sequenceForPosition(ExcerptContext ec, long position, boolean inclusive) throws EOFException, UnrecoverableTimeoutException, StreamCorruptedException {
        return this.indexing.sequenceForPosition(this.recovery, ec, position, inclusive);
    }

    public String toString() {
        return "SingleChronicleQueueStore{indexing=" + this.indexing + ", wireType=" + this.wireType + ", checkpointInterval=" + this.deltaCheckpointInterval + ", roll=" + this.roll + ", writePosition=" + this.writePosition + ", mappedFile=" + this.mappedFile + ", refCount=" + this.refCount + ", lastAcknowledgedIndexReplicated=" + this.lastAcknowledgedIndexReplicated + '}';
    }

    private void onCleanup() {
        this.mappedBytes.release();
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        if (this.lastAcknowledgedIndexReplicated == null) {
            this.lastAcknowledgedIndexReplicated = wire.newLongReference();
        }
        wire.write((WireKey)MetaDataField.wireType).object((Object)this.wireType).writeAlignTo(8, 0).write((WireKey)MetaDataField.writePosition).int64forBinding(0L, this.writePosition).write((WireKey)MetaDataField.roll).typedMarshallable((WriteMarshallable)this.roll).write((WireKey)MetaDataField.indexing).typedMarshallable((WriteMarshallable)this.indexing).write((WireKey)MetaDataField.lastAcknowledgedIndexReplicated).int64forBinding(-1L, this.lastAcknowledgedIndexReplicated);
        wire.write((WireKey)MetaDataField.recovery).typedMarshallable((WriteMarshallable)this.recovery);
        wire.write((WireKey)MetaDataField.deltaCheckpointInterval).int32(this.deltaCheckpointInterval);
        wire.padToCacheAlign();
    }

    @Override
    public void setPositionForSequenceNumber(ExcerptContext ec, long sequenceNumber, long position) throws UnrecoverableTimeoutException, StreamCorruptedException {
        long nextSequence = this.indexing.nextEntryToBeIndexed();
        if (nextSequence > sequenceNumber) {
            return;
        }
        try {
            this.indexing.setPositionForSequenceNumber(this.recovery, ec, sequenceNumber, position);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public long writeHeader(Wire wire, int length, long timeoutMS) throws EOFException, UnrecoverableTimeoutException {
        return this.recovery.writeHeader(wire, length, timeoutMS, this.writePosition);
    }

    @Override
    public void writeEOF(Wire wire, long timeoutMS) throws UnrecoverableTimeoutException {
        try {
            wire.writeEndOfWire(timeoutMS, TimeUnit.MILLISECONDS, this.writePosition());
        }
        catch (TimeoutException e) {
            this.recovery.writeEndOfWire(wire, timeoutMS);
        }
    }

    @Override
    public int deltaCheckpointInterval() {
        return this.deltaCheckpointInterval;
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{SCQIndexing.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(SCQRoll.class, "Roll");
    }

    static enum MetaDataField implements WireKey
    {
        wireType,
        writePosition,
        roll,
        indexing,
        lastAcknowledgedIndexReplicated,
        recovery,
        deltaCheckpointInterval;


        @Nullable
        public Object defaultValue() {
            throw new IORuntimeException("field " + (String)this.name() + " required");
        }
    }
}

