/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.RollingResourcesCache;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.WireStoreSupplier;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueue
implements RollingChronicleQueue {
    public static final String SUFFIX = ".cq4";
    private static final Logger LOG = LoggerFactory.getLogger(SingleChronicleQueue.class);
    protected final ThreadLocal<ExcerptAppender> excerptAppenderThreadLocal = ThreadLocal.withInitial(this::newAppender);
    protected final int sourceId;
    final Supplier<Pauser> pauserSupplier;
    final long timeoutMS;
    @NotNull
    final File path;
    @NotNull
    private final RollCycle rollCycle;
    @NotNull
    private final RollingResourcesCache dateCache;
    @NotNull
    private final WireStorePool pool;
    private final long epoch;
    private final boolean isBuffered;
    @NotNull
    private final WireType wireType;
    private final long blockSize;
    @NotNull
    private final Consumer<BytesRingBufferStats> onRingBufferStats;
    private final EventLoop eventLoop;
    private final long bufferCapacity;
    private final int indexSpacing;
    private final int indexCount;
    @NotNull
    private final TimeProvider time;
    @NotNull
    private final BiFunction<RollingChronicleQueue, Wire, WireStore> storeFactory;
    private final StoreRecoveryFactory recoverySupplier;
    long firstAndLastCycleTime = 0L;
    int firstCycle = Integer.MAX_VALUE;
    int lastCycle = Integer.MIN_VALUE;
    private ThreadLocal<ExcerptContext> tlTailer;
    private final Set<Runnable> closers = new CopyOnWriteArraySet<Runnable>();
    volatile AtomicBoolean isClosed = new AtomicBoolean();

    protected SingleChronicleQueue(@NotNull SingleChronicleQueueBuilder builder) {
        this.rollCycle = builder.rollCycle();
        this.epoch = builder.epoch();
        this.dateCache = new RollingResourcesCache(this.rollCycle, this.epoch, this.textToFile(builder), this.fileToText());
        this.pool = WireStorePool.withSupplier(new StoreSupplier(), builder.storeFileListener());
        this.isBuffered = builder.buffered();
        this.path = builder.path();
        this.wireType = builder.wireType();
        this.blockSize = builder.blockSize();
        this.eventLoop = builder.eventLoop();
        this.bufferCapacity = builder.bufferCapacity();
        this.onRingBufferStats = builder.onRingBufferStats();
        this.indexCount = builder.indexCount();
        this.indexSpacing = builder.indexSpacing();
        this.time = builder.timeProvider();
        this.pauserSupplier = builder.pauserSupplier();
        this.timeoutMS = builder.timeoutMS();
        this.storeFactory = builder.storeFactory();
        this.sourceId = builder.sourceId();
        this.recoverySupplier = builder.recoverySupplier();
        this.tlTailer = ThreadLocal.withInitial(() -> new SingleChronicleQueueExcerpts.StoreTailer(this));
    }

    @NotNull
    private Function<String, File> textToFile(@NotNull SingleChronicleQueueBuilder builder) {
        return name -> new File(builder.path(), name + SUFFIX);
    }

    @NotNull
    private Function<File, String> fileToText() {
        return file -> {
            String name = file.getName();
            return name.substring(0, name.length() - SUFFIX.length());
        };
    }

    @Override
    public int sourceId() {
        return this.sourceId;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    @NotNull
    public File file() {
        return this.path;
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        int max = this.lastCycle();
        for (int i = this.firstCycle(); i <= max; ++i) {
            WireStore wireStore = this.storeForCycle(i, this.epoch, false);
            if (wireStore == null) continue;
            sb.append(wireStore.dump());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dump(Writer writer, long fromIndex, long toIndex) {
        try {
            long firstIndex = this.firstIndex();
            writer.append("# firstIndex: ").append(Long.toHexString(firstIndex)).append("\n");
            ExcerptTailer tailer = this.createTailer();
            if (!tailer.moveToIndex(fromIndex)) {
                if (firstIndex <= fromIndex) return;
                tailer.toStart();
            }
            Bytes bytes = Wires.acquireBytes();
            TextWire text = new TextWire(bytes);
            while (true) {
                Throwable throwable;
                DocumentContext dc;
                block40: {
                    block41: {
                        block38: {
                            block39: {
                                dc = tailer.readingDocument();
                                throwable = null;
                                if (dc.isPresent()) break block38;
                                writer.append("# no more messages at ").append(Long.toHexString(dc.index())).append("\n");
                                if (dc == null) return;
                                if (throwable == null) break block39;
                                try {
                                    dc.close();
                                    return;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                    return;
                                }
                            }
                            dc.close();
                            return;
                        }
                        if (dc.index() <= toIndex) break block40;
                        if (dc == null) return;
                        if (throwable == null) break block41;
                        try {
                            dc.close();
                            return;
                        }
                        catch (Throwable e) {
                            throwable.addSuppressed(e);
                            return;
                        }
                    }
                    dc.close();
                    return;
                }
                try {
                    writer.append("# index: ").append(Long.toHexString(dc.index())).append("\n");
                    Wire wire = dc.wire();
                    long start = wire.bytes().readPosition();
                    try {
                        text.clear();
                        wire.copyTo((WireOut)text);
                        writer.append(bytes.toString());
                    }
                    catch (Exception e) {
                        wire.bytes().readPosition(start);
                        writer.append((CharSequence)wire.bytes()).append("\n");
                    }
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace(new PrintWriter(writer));
            return;
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(SingleChronicleQueue.class).debug("", (Throwable)e);
            }
        }
    }

    @Override
    public int indexCount() {
        return this.indexCount;
    }

    @Override
    public int indexSpacing() {
        return this.indexSpacing;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    @NotNull
    public RollCycle rollCycle() {
        return this.rollCycle;
    }

    public StoreRecoveryFactory recoverySupplier() {
        return this.recoverySupplier;
    }

    public boolean buffered() {
        return this.isBuffered;
    }

    @Nullable
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    protected ExcerptAppender newAppender() {
        return new SingleChronicleQueueExcerpts.StoreAppender(this);
    }

    @Override
    @NotNull
    public ExcerptAppender acquireAppender() {
        return this.excerptAppenderThreadLocal.get();
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() {
        return new SingleChronicleQueueExcerpts.StoreTailer(this);
    }

    @Override
    @Nullable
    public final WireStore storeForCycle(int cycle, long epoch, boolean createIfAbsent) {
        return this.pool.acquire(cycle, epoch, createIfAbsent);
    }

    @Override
    public int nextCycle(int cycle, @NotNull TailerDirection direction) throws ParseException {
        return this.pool.nextCycle(cycle, direction);
    }

    private long exceptsPerCycle(long cycle) {
        WireStore wireStore = this.storeForCycle((int)cycle, this.epoch, false);
        try {
            return wireStore.sequenceForPosition(this.tlTailer.get(), wireStore.writePosition(), true) + 1L;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public long countExcerpts(long lowerIndex, long upperIndex) throws IllegalStateException {
        NavigableSet<Long> cycles;
        int upperCycle;
        int lowerCycle;
        if (lowerIndex > upperIndex) {
            long temp = lowerIndex;
            lowerIndex = upperIndex;
            upperIndex = temp;
        }
        if (lowerIndex == upperIndex) {
            return 0L;
        }
        long result = 0L;
        long sequenceNotSet = this.rollCycle().toSequenceNumber(-1L);
        if (this.rollCycle().toSequenceNumber(lowerIndex) == sequenceNotSet) {
            ++result;
            ++lowerIndex;
        }
        if (this.rollCycle().toSequenceNumber(upperIndex) == sequenceNotSet) {
            --result;
            ++upperIndex;
        }
        if ((lowerCycle = this.rollCycle().toCycle(lowerIndex)) == (upperCycle = this.rollCycle().toCycle(upperIndex))) {
            return upperIndex - lowerIndex;
        }
        long upperSeqNum = this.rollCycle().toSequenceNumber(upperIndex);
        long lowerSeqNum = this.rollCycle().toSequenceNumber(lowerIndex);
        if (lowerCycle + 1 == upperCycle) {
            long l = this.exceptsPerCycle(lowerCycle);
            return result += l - lowerSeqNum + upperSeqNum;
        }
        try {
            cycles = this.pool.listCyclesBetween(lowerCycle, upperCycle);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if ((Long)cycles.first() == (long)lowerCycle) {
            long l = this.exceptsPerCycle(lowerCycle);
            result += l - lowerSeqNum;
        } else {
            throw new IllegalStateException("Cycle not found, lower-cycle=" + Long.toHexString(lowerCycle));
        }
        if ((Long)cycles.last() == (long)upperCycle) {
            result += upperSeqNum;
        } else {
            throw new IllegalStateException("Cycle not found,  upper-cycle=" + Long.toHexString(upperCycle));
        }
        if (cycles.size() == 2) {
            return result;
        }
        Long[] array = cycles.toArray(new Long[cycles.size()]);
        for (int i = 1; i < array.length - 1; ++i) {
            long x = this.exceptsPerCycle(array[i]);
            result += x;
        }
        return result;
    }

    public void addCloseListener(Runnable closer) {
        this.closers.add(closer);
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public void close() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        this.closers.forEach(Runnable::run);
        this.pool.close();
    }

    @Override
    public final void release(@NotNull WireStore store) {
        this.pool.release(store);
    }

    @Override
    public final int cycle() {
        return this.rollCycle.current(this.time, this.epoch);
    }

    @Override
    public long firstIndex() {
        int cycle = this.firstCycle();
        if (cycle == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.rollCycle().toIndex(cycle, 0L);
    }

    String[] getList() {
        return this.path.list();
    }

    private void setFirstAndLastCycle() {
        long now = this.time.currentTimeMillis();
        if (now == this.firstAndLastCycleTime) {
            return;
        }
        this.firstCycle = Integer.MAX_VALUE;
        this.lastCycle = Integer.MIN_VALUE;
        String[] files = this.getList();
        if (files == null) {
            return;
        }
        for (String file : files) {
            try {
                if (!file.endsWith(SUFFIX)) continue;
                int fileCycle = this.dateCache.parseCount(file = file.substring(0, file.length() - SUFFIX.length()));
                if (this.firstCycle > fileCycle) {
                    this.firstCycle = fileCycle;
                }
                if (this.lastCycle >= fileCycle) continue;
                this.lastCycle = fileCycle;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    @Override
    public int firstCycle() {
        this.setFirstAndLastCycle();
        return this.firstCycle;
    }

    void onRoll(int cycle) {
        if (this.lastCycle < cycle) {
            this.lastCycle = cycle;
        }
    }

    @Override
    public int lastCycle() {
        this.setFirstAndLastCycle();
        return this.lastCycle;
    }

    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats;
    }

    public long blockSize() {
        return this.blockSize;
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    public long bufferCapacity() {
        return this.bufferCapacity;
    }

    private MappedBytes mappedBytes(File cycleFile) throws FileNotFoundException {
        long chunkSize = OS.pageAlign((long)this.blockSize);
        long overlapSize = OS.pageAlign((long)(this.blockSize / 4L));
        return MappedBytes.mappedBytes((File)cycleFile, (long)chunkSize, (long)overlapSize);
    }

    private int toCycle(Map.Entry<Long, File> entry) throws ParseException {
        if (entry == null || entry.getValue() == null) {
            return -1;
        }
        return this.dateCache.parseCount(this.fileToText().apply(entry.getValue()));
    }

    public String toString() {
        return "SingleChronicleQueue{sourceId=" + this.sourceId + ", path=" + this.path + '}';
    }

    private class StoreSupplier
    implements WireStoreSupplier {
        private StoreSupplier() {
        }

        @Override
        public WireStore acquire(int cycle, boolean createIfAbsent) {
            SingleChronicleQueue that = SingleChronicleQueue.this;
            RollingResourcesCache.Resource dateValue = that.dateCache.resourceFor(cycle);
            try {
                WireStore wireStore;
                File path = dateValue.path;
                File parentFile = path.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                if (!path.exists() && !createIfAbsent) {
                    return null;
                }
                if (createIfAbsent) {
                    this.checkDiskSpace(path);
                }
                MappedBytes mappedBytes = SingleChronicleQueue.this.mappedBytes(path);
                AbstractWire wire = (AbstractWire)SingleChronicleQueue.this.wireType.apply((Object)mappedBytes);
                assert (wire.startUse());
                wire.pauser(SingleChronicleQueue.this.pauserSupplier.get());
                wire.headerNumber(SingleChronicleQueue.this.rollCycle.toIndex(cycle, 0L) - 1L);
                if (wire.writeFirstHeader()) {
                    wireStore = (WireStore)SingleChronicleQueue.this.storeFactory.apply(that, wire);
                    wire.updateFirstHeader();
                } else {
                    wire.readFirstHeader(SingleChronicleQueue.this.timeoutMS, TimeUnit.MILLISECONDS);
                    StringBuilder name = Wires.acquireStringBuilder();
                    ValueIn valueIn = wire.readEventName(name);
                    if (StringUtils.isEqual((StringBuilder)name, (CharSequence)MetaDataKeys.header.name())) {
                        wireStore = (WireStore)valueIn.typedMarshallable();
                    } else {
                        throw new StreamCorruptedException("The first message should be the header, was " + name);
                    }
                }
                return wireStore;
            }
            catch (IOException | TimeoutException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        private void checkDiskSpace(File path) throws IOException {
            Path root = path.getParentFile().toPath().getRoot();
            if (root != null && root.getFileSystem() != null) {
                long totalSpace;
                long unallocatedBytes = Files.getFileStore(root).getUnallocatedSpace();
                if ((double)unallocatedBytes < (double)(totalSpace = Files.getFileStore(root).getTotalSpace()) * 0.05) {
                    LOG.warn("your disk is more than 95% full, warning: chronicle-queue may crash if it runs out of space.");
                } else if (unallocatedBytes < 0x6400000L) {
                    LOG.warn("your disk is almost full, warning: chronicle-queue may crash if it runs out of space.");
                }
            }
        }

        private NavigableMap<Long, File> cycleTree() throws ParseException {
            File[] files;
            File parentFile = SingleChronicleQueue.this.path;
            if (!parentFile.exists()) {
                throw new AssertionError((Object)("parentFile=" + parentFile.getName() + " does not exist"));
            }
            RollingResourcesCache dateCache = SingleChronicleQueue.this.dateCache;
            TreeMap<Long, File> tree = new TreeMap<Long, File>();
            for (File file2 : files = parentFile.listFiles(file -> file.getName().endsWith(SingleChronicleQueue.SUFFIX))) {
                tree.put(dateCache.toLong(file2), file2);
            }
            return tree;
        }

        @Override
        public int nextCycle(int currentCycle, TailerDirection direction) throws ParseException {
            if (direction == TailerDirection.NONE) {
                throw new AssertionError((Object)"direction is NONE");
            }
            assert (currentCycle >= 0) : "currentCycle=" + Integer.toHexString(currentCycle);
            NavigableMap<Long, File> tree = this.cycleTree();
            File currentCycleFile = ((SingleChronicleQueue)SingleChronicleQueue.this).dateCache.resourceFor((long)((long)currentCycle)).path;
            if (!currentCycleFile.exists()) {
                throw new IllegalStateException("file not exists, currentCycle, file=" + currentCycleFile);
            }
            Long key = SingleChronicleQueue.this.dateCache.toLong(currentCycleFile);
            File file = (File)tree.get(key);
            if (file == null) {
                throw new AssertionError((Object)("missing currentCycle, file=" + currentCycleFile));
            }
            switch (direction) {
                case FORWARD: {
                    return SingleChronicleQueue.this.toCycle(tree.higherEntry(key));
                }
                case BACKWARD: {
                    return SingleChronicleQueue.this.toCycle(tree.lowerEntry(key));
                }
            }
            throw new UnsupportedOperationException("Unsupported Direction");
        }

        @Override
        public NavigableSet<Long> cycles(int lowerCycle, int upperCycle) throws ParseException {
            NavigableMap<Long, File> tree = this.cycleTree();
            Long lowerKey = this.toKey(lowerCycle, "lowerCycle");
            Long upperKey = this.toKey(upperCycle, "upperCycle");
            assert (lowerKey != null);
            assert (upperKey != null);
            return tree.subMap(lowerKey, true, upperKey, true).navigableKeySet();
        }

        private Long toKey(int cyle, String m) {
            File file = ((SingleChronicleQueue)SingleChronicleQueue.this).dateCache.resourceFor((long)((long)cyle)).path;
            if (!file.exists()) {
                throw new IllegalStateException("'file not found' for the " + m + ", file=" + file);
            }
            return SingleChronicleQueue.this.dateCache.toLong(file);
        }
    }
}

