/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.wire.WireDumper;

public class DumpQueueMain {
    public static void main(String[] args) {
        DumpQueueMain.dump(args[0]);
    }

    public static void dump(String path) {
        File path2 = new File(path);
        if (path2.isDirectory()) {
            File[] files = path2.listFiles();
            if (files == null) {
                System.err.println("Directory not found " + path);
            }
            for (File file : files) {
                DumpQueueMain.dumpFile(file);
            }
        } else {
            DumpQueueMain.dumpFile(path2);
        }
    }

    private static void dumpFile(File file) {
        if (file.getName().endsWith(".cq4")) {
            try (MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)0x400000L);){
                bytes.readLimit(bytes.realCapacity());
                StringBuilder sb = new StringBuilder();
                WireDumper dumper = WireDumper.of((Bytes)bytes);
                while (bytes.readRemaining() >= 4L) {
                    sb.setLength(0);
                    boolean last = dumper.dumpOne(sb);
                    System.out.println(sb);
                    if (!last) continue;
                    break;
                }
            }
            catch (IOException ioe) {
                System.err.println("Failed to read " + file + " " + ioe);
            }
        }
    }
}

