/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedStoreRecovery
extends AbstractMarshallable
implements StoreRecovery,
Demarshallable {
    public static final StoreRecoveryFactory FACTORY = TimedStoreRecovery::new;
    private static final Logger LOG = LoggerFactory.getLogger(TimedStoreRecovery.class);
    private final LongValue timeStamp;

    @UsedViaReflection
    public TimedStoreRecovery(WireIn in) {
        this.timeStamp = in.read(() -> "timeStamp").int64ForBinding(in.newLongReference());
    }

    public TimedStoreRecovery(WireType wireType) {
        this.timeStamp = (LongValue)wireType.newLongReference().get();
    }

    public void writeMarshallable(@NotNull WireOut out) {
        out.write((CharSequence)"timeStamp").int64forBinding(0L);
    }

    long acquireLock(long timeoutMS) {
        long start = System.currentTimeMillis();
        while (true) {
            long now = System.currentTimeMillis();
            long ts = this.timeStamp.getVolatileValue();
            long tsEnd = now + timeoutMS / 2L;
            if (ts < now && this.timeStamp.compareAndSwapValue(ts, tsEnd)) {
                return tsEnd;
            }
            if (now >= start + timeoutMS) {
                Jvm.warn().on(this.getClass(), "Unable to obtain the global lock in time, retrying");
                start = now;
            }
            Jvm.pause((long)1L);
        }
    }

    void releaseLock(long tsEnd) {
        if (this.timeStamp.compareAndSwapValue(tsEnd, 0L)) {
            return;
        }
        Jvm.warn().on(this.getClass(), "Another thread obtained the lock ??");
    }

    @Override
    public long recoverIndex2Index(LongValue index2Index, Callable<Long> action, long timeoutMS) throws UnrecoverableTimeoutException, EOFException {
        long tsEnd = this.acquireLock(timeoutMS);
        if (index2Index.getValue() == -1L) {
            Jvm.warn().on(this.getClass(), "Rebuilding the index2index, resetting to 0");
            index2Index.setValue(0L);
        } else {
            Jvm.warn().on(this.getClass(), "The index2index value has changed, assuming it was recovered");
        }
        try {
            long l = action.call();
            return l;
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
        finally {
            this.releaseLock(tsEnd);
        }
    }

    @Override
    public long recoverSecondaryAddress(LongArrayValues index2indexArr, int index2, Callable<Long> action, long timeoutMS) throws UnrecoverableTimeoutException, EOFException {
        long tsEnd = this.acquireLock(timeoutMS);
        if (index2indexArr.getValueAt((long)index2) == -1L) {
            Jvm.warn().on(this.getClass(), "Rebuilding the index2index[" + index2 + "], resetting to 0");
            index2indexArr.setValueAt((long)index2, 0L);
        } else {
            Jvm.warn().on(this.getClass(), "The index2index[" + index2 + "] value has changed, assuming it was recovered");
        }
        try {
            long l = action.call();
            return l;
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
        finally {
            this.releaseLock(tsEnd);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public long recoverAndWriteHeader(Wire wire, int length, long timeoutMS, LongValue lastPosition) throws UnrecoverableTimeoutException {
        while (true) {
            long offset = wire.bytes().writePosition();
            int num = wire.bytes().readInt(offset);
            if (Wires.isNotComplete((int)num) && wire.bytes().compareAndSwapInt(offset, num, 0)) {
                Jvm.warn().on(this.getClass(), "Unable to write a header at index: " + Long.toHexString(wire.headerNumber()) + " position: " + offset + " resetting");
            } else {
                Jvm.warn().on(this.getClass(), "Unable to write a header at index: " + Long.toHexString(wire.headerNumber()) + " position: " + offset + " unable to reset.");
            }
            try {
                return wire.writeHeader(length, timeoutMS, TimeUnit.MILLISECONDS, lastPosition);
            }
            catch (TimeoutException e) {
                Jvm.warn().on(this.getClass(), (Throwable)e);
                continue;
            }
            break;
        }
        catch (EOFException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeEndOfWire(Wire wire, long timeoutMS) throws UnrecoverableTimeoutException {
        throw new UnsupportedOperationException();
    }
}

