/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.queue.RollCycle;

public enum RollCycles implements RollCycle
{
    SECONDLY("yyyyMMdd-HHmmss", 1000, 1024, 16),
    MINUTELY("yyyyMMdd-HHmm", 60000, 2048, 16),
    HOURLY("yyyyMMdd-HH", 3600000, 4096, 16),
    TEST_DAILY("yyyyMMdd", 86400000, 8, 1),
    SMALL_DAILY("yyyyMMdd", 86400000, 8192, 8),
    DAILY("yyyyMMdd", 86400000, 16384, 16),
    LARGE_DAILY("yyyyMMdd", 86400000, 32768, 32),
    XLARGE_DAILY("yyyyMMdd", 86400000, 131072, 256),
    HUGE_DAILY("yyyyMMdd", 86400000, 524288, 1024);

    final String format;
    final int length;
    final int cycleShift;
    final int indexCount;
    final int indexSpacing;
    final long sequenceMask;

    private RollCycles(String format, int length, int indexCount, int indexSpacing) {
        this.format = format;
        this.length = length;
        this.indexCount = Maths.nextPower2((int)indexCount, (int)8);
        this.indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        this.cycleShift = Math.max(32, Maths.intLog2((long)indexCount) * 2 + Maths.intLog2((long)indexSpacing));
        this.sequenceMask = (1L << this.cycleShift) - 1L;
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int defaultIndexCount() {
        return this.indexCount;
    }

    @Override
    public int defaultIndexSpacing() {
        return this.indexSpacing;
    }

    @Override
    public long toIndex(int cycle, long sequenceNumber) {
        return ((long)cycle << this.cycleShift) + (sequenceNumber & this.sequenceMask);
    }

    @Override
    public long toSequenceNumber(long index) {
        return index & this.sequenceMask;
    }

    @Override
    public int toCycle(long index) {
        return Maths.toUInt31((long)(index >> this.cycleShift));
    }
}

