/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.NoDocumentContext;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.InternalWire;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueueExcerpts {
    private static final Logger LOG = LoggerFactory.getLogger(SingleChronicleQueueExcerpts.class);
    private static final boolean ASSERTIONS;
    private static final String ROLL_STRING = "roll";
    private static final int ROLL_KEY;
    private static final int SPB_HEADER_SIZE = 4;

    static {
        ROLL_KEY = BytesUtil.asInt((String)ROLL_STRING);
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERTIONS = assertions;
    }

    public static class StoreTailer
    implements ExcerptTailer {
        @NotNull
        private final SingleChronicleQueue queue;
        private Wire wire;
        private long cycle;
        private long index;
        private WireStore store;
        private long nextPrefetch = OS.pageSize();
        private DocumentContext dc;

        public StoreTailer(@NotNull SingleChronicleQueue queue) {
            this.queue = queue;
            this.cycle = -1L;
            this.index = -1L;
            this.toStart();
            this.dc = this.wire == null ? NoDocumentContext.INSTANCE : new TailerDocumentContext(this.wire, this);
        }

        public String toString() {
            return "StoreTailer{index sequence=" + RollingChronicleQueue.toSequenceNumber(this.index) + ", index cycle=" + RollingChronicleQueue.toCycle(this.index) + ", store=" + this.store + ", queue=" + this.queue + '}';
        }

        @Override
        public boolean readDocument(@NotNull ReadMarshallable marshaller) {
            return this.read(marshaller, ReadMarshallable::readMarshallable);
        }

        @Override
        public boolean readBytes(@NotNull Bytes using) {
            return this.read(using, (t, w) -> t.write((BytesStore)w.bytes()));
        }

        @Override
        public DocumentContext readingDocument() {
            if (!this.next() || this.dc == NoDocumentContext.INSTANCE) {
                return NoDocumentContext.INSTANCE;
            }
            ((TailerDocumentContext)this.dc).start();
            return this.dc;
        }

        private boolean next() {
            long firstIndex;
            if (this.store == null && !this.moveToIndex(firstIndex = this.queue.firstIndex())) {
                return false;
            }
            do {
                long roll = Long.MIN_VALUE;
                Wire wire = this.wire;
                wire.bytes().readLimit(wire.bytes().capacity());
                while (wire.bytes().readVolatileInt(wire.bytes().readPosition()) != 0) {
                    long position = wire.bytes().readPosition();
                    long limit = wire.bytes().readLimit();
                    DocumentContext documentContext = wire.readingDocument();
                    Throwable throwable = null;
                    try {
                        if (!documentContext.isPresent()) {
                            boolean bl = false;
                            return bl;
                        }
                        if (documentContext.isData()) {
                            ((ReadDocumentContext)documentContext).closeReadPosition(position);
                            ((ReadDocumentContext)documentContext).closeReadLimit(limit);
                            boolean bl = true;
                            return bl;
                        }
                        StringBuilder sb = Wires.acquireStringBuilder();
                        ValueIn vi = wire.readEventName(sb);
                        if (!SingleChronicleQueueExcerpts.ROLL_STRING.contentEquals(sb)) continue;
                        roll = vi.int32();
                        break;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (documentContext == null) continue;
                        if (throwable != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        documentContext.close();
                    }
                }
                if (roll == Long.MIN_VALUE) {
                    return false;
                }
                this.cycle(roll);
            } while (this.store != null);
            return false;
        }

        @Override
        public boolean readBytes(@NotNull ReadBytesMarshallable using) {
            return this.read(using, (t, w) -> t.readMarshallable(w.bytes()));
        }

        @Override
        public long index() {
            if (this.store == null) {
                throw new IllegalArgumentException("This tailer is not bound to any cycle");
            }
            return RollingChronicleQueue.index(this.cycle, this.index);
        }

        @Override
        public long cycle() {
            return this.cycle;
        }

        @Override
        public boolean moveToIndex(long index) {
            long expectedCycle;
            if (LOG.isDebugEnabled()) {
                LOG.debug("moveToIndex: " + Long.toHexString(index));
            }
            if ((expectedCycle = RollingChronicleQueue.toCycle(index)) != this.cycle) {
                this.cycle(expectedCycle);
            }
            this.cycle = expectedCycle;
            Bytes bytes = this.wire.bytes();
            long sequenceNumber = RollingChronicleQueue.toSequenceNumber(index);
            if (sequenceNumber == -1L) {
                bytes.readPosition(0L);
                this.index = RollingChronicleQueue.index(this.cycle, sequenceNumber);
                return true;
            }
            long position = this.store.moveToIndex(this.wire, sequenceNumber);
            if (position == -1L) {
                return false;
            }
            bytes.readPosition(position);
            bytes.readLimit(bytes.realCapacity());
            this.index = RollingChronicleQueue.index(this.cycle, sequenceNumber - 1L);
            return true;
        }

        @Override
        @NotNull
        public final ExcerptTailer toStart() {
            long index = this.queue.firstIndex();
            if (index == -1L) {
                return this;
            }
            if (RollingChronicleQueue.toSequenceNumber(index) == -1L) {
                this.cycle(RollingChronicleQueue.toCycle(index));
                this.wire.bytes().readPosition(0L);
                return this;
            }
            if (!this.moveToIndex(index)) {
                throw new IllegalStateException("unable to move to the start, cycle=" + this.cycle);
            }
            return this;
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() {
            long index = this.queue.lastIndex();
            if (index == -1L) {
                return this;
            }
            this.moveToIndex(index + 1L);
            return this;
        }

        @Override
        public void prefetch() {
            long position = this.wire.bytes().readPosition();
            if (position < this.nextPrefetch) {
                return;
            }
            long prefetch = OS.mapAlign((long)position) + (long)OS.pageSize();
            this.wire.bytes().compareAndSwapInt(prefetch, -1, -1);
            this.nextPrefetch = prefetch + (long)OS.pageSize();
        }

        public RollingChronicleQueue queue() {
            return this.queue;
        }

        private <T> boolean read(@NotNull T t, @NotNull BiConsumer<T, Wire> c) {
            long index = this.index;
            if (this.store == null) {
                index = this.queue.firstIndex();
                if (index == -1L) {
                    return false;
                }
                this.moveToIndex(index);
            }
            if (this.read0(t, c)) {
                this.index = RollingChronicleQueue.index(this.cycle, RollingChronicleQueue.toSequenceNumber(index) + 1L);
                return true;
            }
            return false;
        }

        private <T> boolean read0(@NotNull T t, @NotNull BiConsumer<T, Wire> c) {
            do {
                long roll = Long.MIN_VALUE;
                this.wire.bytes().readLimit(this.wire.bytes().capacity());
                while (this.wire.bytes().readVolatileInt(this.wire.bytes().readPosition()) != 0) {
                    DocumentContext documentContext = this.wire.readingDocument();
                    Throwable throwable = null;
                    try {
                        if (!documentContext.isPresent()) {
                            boolean bl = false;
                            return bl;
                        }
                        if (documentContext.isData()) {
                            c.accept(t, this.wire);
                            boolean bl = true;
                            return bl;
                        }
                        StringBuilder sb = Wires.acquireStringBuilder();
                        ValueIn vi = this.wire.readEventName(sb);
                        if (!SingleChronicleQueueExcerpts.ROLL_STRING.contentEquals(sb)) continue;
                        roll = vi.int32();
                        break;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (documentContext == null) continue;
                        if (throwable != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        documentContext.close();
                    }
                }
                if (roll == Long.MIN_VALUE) {
                    return false;
                }
                this.cycle(roll);
            } while (this.store != null);
            return false;
        }

        @NotNull
        private StoreTailer cycle(long cycle) {
            if (this.cycle != cycle) {
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                this.cycle = cycle;
                this.store = this.queue.storeForCycle(cycle, this.queue.epoch());
                this.wire = (Wire)this.queue.wireType().apply((Object)this.store.mappedBytes());
                this.moveToIndex(RollingChronicleQueue.index(cycle, -1L));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("tailer=" + ((MappedBytes)this.wire.bytes()).mappedFile().file().getAbsolutePath());
                }
            }
            return this;
        }
    }

    private static class TailerDocumentContext
    implements DocumentContext {
        private final ReadDocumentContext dc;
        private final StoreTailer storeTailer;
        private final Wire wire;

        TailerDocumentContext(Wire wire, StoreTailer storeTailer) {
            this.storeTailer = storeTailer;
            this.dc = new ReadDocumentContext(wire);
            this.wire = wire;
        }

        public void start() {
            this.dc.start();
            if (this.isPresent()) {
                this.storeTailer.index = RollingChronicleQueue.index(this.storeTailer.cycle, RollingChronicleQueue.toSequenceNumber(this.storeTailer.index) + 1L);
            }
        }

        public boolean isMetaData() {
            return this.dc.isMetaData();
        }

        public boolean isPresent() {
            return this.dc.isPresent();
        }

        public boolean isData() {
            return this.dc.isData();
        }

        public Wire wire() {
            return this.wire;
        }

        public void close() {
            this.dc.close();
        }
    }

    private static class AppenderDocumentContext
    implements DocumentContext {
        private final WriteDocumentContext dc;
        private final Wire wire;
        private final StoreAppender storeAppender;

        AppenderDocumentContext(InternalWire wire, StoreAppender storeAppender) {
            this.storeAppender = storeAppender;
            this.dc = new WriteDocumentContext(wire);
            this.wire = wire;
        }

        public void start(boolean metaData) {
            this.dc.start(metaData);
            this.storeAppender.sequenceNumber++;
        }

        public boolean isMetaData() {
            return this.dc.isMetaData();
        }

        public boolean isPresent() {
            return this.dc.isPresent();
        }

        public boolean isData() {
            return this.dc.isData();
        }

        public Wire wire() {
            return this.wire;
        }

        public void close() {
            this.dc.close();
        }
    }

    public static class StoreAppender
    implements ExcerptAppender {
        @NotNull
        private final SingleChronicleQueue queue;
        private long sequenceNumber;
        private Wire wire;
        private long cycle;
        private WireStore store;
        private long nextPrefetch = OS.pageSize();
        private AppenderDocumentContext dc;
        private volatile Thread appendingThread = null;

        public StoreAppender(@NotNull SingleChronicleQueue queue) {
            this.queue = queue;
            long lastIndex = this.queue.lastIndex();
            long l = this.cycle = lastIndex == -1L ? queue.cycle() : RollingChronicleQueue.toCycle(lastIndex);
            if (this.cycle < 0L) {
                throw new IllegalArgumentException("You can not have a cycle that starts before Epoch. cycle=" + this.cycle);
            }
            this.store = queue.storeForCycle(this.cycle, queue.epoch());
            this.sequenceNumber = this.store.sequenceNumber();
            MappedBytes mappedBytes = this.store.mappedBytes();
            if (LOG.isDebugEnabled()) {
                LOG.debug("appender file=" + mappedBytes.mappedFile().file().getAbsolutePath());
            }
            this.wire = (Wire)this.queue.wireType().apply((Object)mappedBytes);
            this.dc = new AppenderDocumentContext((InternalWire)this.wire, this);
        }

        @Override
        public DocumentContext writingDocument() {
            this.dc.start(false);
            return this.dc;
        }

        @Override
        public long writeDocument(@NotNull WriteMarshallable writer) {
            return this.append(WireInternal::writeWireOrAdvanceIfNotEmpty, writer);
        }

        public long writeBytes(@NotNull Bytes bytes) {
            return this.append(WireInternal::writeWireOrAdvanceIfNotEmpty, bytes);
        }

        @Override
        public long writeBytes(@NotNull WriteBytesMarshallable marshallable) {
            return this.writeDocument(w -> marshallable.writeMarshallable(w.bytes()));
        }

        @Override
        public long index() {
            if (this.sequenceNumber == -1L) {
                throw new IllegalStateException();
            }
            return RollingChronicleQueue.index(this.cycle(), this.sequenceNumber);
        }

        @Override
        public long cycle() {
            return this.store.cycle();
        }

        @Override
        public void prefetch() {
            long position = this.wire.bytes().writePosition();
            if (position < this.nextPrefetch) {
                return;
            }
            long prefetch = OS.mapAlign((long)position);
            this.wire.bytes().compareAndSwapInt(prefetch, -1, -1);
            this.nextPrefetch = prefetch + (long)OS.pageSize();
        }

        public SingleChronicleQueue queue() {
            return this.queue;
        }

        public boolean consumeBytes(BytesConsumer consumer) throws InterruptedException {
            Bytes bytes = this.wire.bytes();
            long start = bytes.writePosition();
            bytes.writeInt(Integer.MIN_VALUE);
            if (!consumer.accept(bytes)) {
                bytes.writeSkip(-4L);
                bytes.writeInt(bytes.writePosition(), 0);
                return false;
            }
            long len = bytes.writePosition() - start - 4L;
            if (len == 0L) {
                bytes.writeSkip(-4L);
                bytes.writeInt(bytes.writePosition(), 0);
                return false;
            }
            bytes.writeInt(start, Wires.toIntU30((long)len, (String)"Document length %,d out of 30-bit int range."));
            this.store().writePosition(bytes.writePosition()).storeIndexLocation(this.wire, start, ++this.sequenceNumber);
            return true;
        }

        private <T> long append(@NotNull WireWriter<T> wireWriter, @NotNull T writer) {
            if (ASSERTIONS) {
                Thread appendingThread = this.appendingThread;
                if (appendingThread != null) {
                    throw new IllegalStateException("Attempting to use Appneder in " + Thread.currentThread() + " while used by " + appendingThread);
                }
                this.appendingThread = Thread.currentThread();
            }
            WireStore store = this.store();
            Bytes bytes = this.wire.bytes();
            long position = -1L;
            do {
                long readPosition;
                int spbHeader;
                if (((spbHeader = bytes.readInt(readPosition = bytes.readPosition())) & 0x40000000) != 0) {
                    if (!Wires.isReady((long)spbHeader)) continue;
                    if (bytes.readInt(readPosition + 4L) == ROLL_KEY) {
                        store = this.store();
                        bytes = this.wire.bytes();
                        bytes.writePosition(store.writePosition());
                        bytes.readPosition(store.writePosition());
                    }
                }
                position = wireWriter.writeOrAdvanceIfNotEmpty((WireOut)this.wire, false, writer);
            } while (position <= 0L);
            ++this.sequenceNumber;
            store.writePosition(bytes.writePosition());
            store.storeIndexLocation(this.wire, position, this.sequenceNumber);
            long index = RollingChronicleQueue.index(store.cycle(), this.sequenceNumber);
            if (ASSERTIONS) {
                this.appendingThread = null;
            }
            return index;
        }

        @ForceInline
        private WireStore store() {
            if (this.cycle != this.queue.cycle()) {
                long nextCycle = this.queue.cycle();
                if (this.store != null) {
                    while (!this.store.appendRollMeta(this.wire, nextCycle)) {
                        Thread.yield();
                    }
                    this.queue.release(this.store);
                }
                this.cycle = nextCycle;
                this.store = this.queue.storeForCycle(this.cycle, this.queue.epoch());
                this.wire = (Wire)this.queue.wireType().apply((Object)this.store.mappedBytes());
                this.sequenceNumber = this.store.firstSequenceNumber();
            }
            return this.store;
        }
    }

    @FunctionalInterface
    public static interface WireWriter<T> {
        public long writeOrAdvanceIfNotEmpty(@NotNull WireOut var1, boolean var2, @NotNull T var3);
    }

    @FunctionalInterface
    public static interface BytesConsumer {
        public boolean accept(Bytes<?> var1) throws InterruptedException;
    }
}

