/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireOut;

public enum ChronicleReader {


    public static void main(String ... args) throws IOException, InterruptedException {
        if (args.length < 1) {
            System.err.println("Usage: java " + ChronicleReader.class.getName() + " {chronicle-base-path} {regex} [from-index]");
            System.exit(-1);
        }
        String basePath = args[0];
        String regex = args.length > 0 ? args[1] : "";
        long index = args.length > 1 ? Long.decode(args[2]) : 0L;
        ChronicleReader.tailFileFrom(basePath, regex, index, false);
    }

    public static void tailFileFrom(String basePath, String regex, long index, boolean stopAtEnd) throws IOException, InterruptedException {
        ChronicleQueue ic = SingleChronicleQueueBuilder.binary(new File(basePath)).build();
        ExcerptTailer tailer = ic.createTailer();
        if (index > 0L) {
            System.out.println("Waiting for index " + index);
            while (!tailer.moveToIndex(index)) {
                Thread.sleep(500L);
            }
        }
        Bytes bytes2 = Bytes.elasticByteBuffer();
        while (true) {
            DocumentContext dc = tailer.readingDocument();
            Throwable throwable = null;
            try {
                String text;
                if (!dc.isPresent()) {
                    if (stopAtEnd) break;
                    Thread.sleep(50L);
                    continue;
                }
                System.out.print("0x" + Long.toHexString(dc.index()) + ": ");
                Bytes bytes = dc.wire().bytes();
                byte b0 = bytes.readByte(bytes.readPosition());
                if (b0 < 0) {
                    bytes2.clear();
                    new BinaryWire(bytes).copyTo((WireOut)new TextWire(bytes2));
                    text = bytes2.toString();
                } else {
                    text = bytes.toString();
                }
                if (!regex.isEmpty() && !text.matches(regex)) continue;
                System.out.println(text);
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
                continue;
            }
            break;
        }
    }
}

