/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.ExcerptFactory;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerptFactory;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueFields;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueueBuilder
implements ChronicleQueueBuilder,
SingleChronicleQueueFields {
    private static final Logger LOG = LoggerFactory.getLogger((String)SingleChronicleQueueBuilder.class.getName());
    private final File path;
    private long blockSize;
    @NotNull
    private WireType wireType;
    @NotNull
    private RollCycle rollCycle;
    private long epoch;
    private boolean isBuffered;
    private Consumer<Throwable> onThrowable = Throwable::printStackTrace;
    @Nullable
    private EventLoop eventLoop;
    @NotNull
    private ExcerptFactory<SingleChronicleQueue> excerptFactory;
    private long bufferCapacity = 0x200000L;
    private Consumer<BytesRingBufferStats> onRingBufferStats = r -> {
        long writeBytesRemaining = r.minNumberOfWriteBytesRemaining();
        if (writeBytesRemaining == Long.MAX_VALUE) {
            return;
        }
        double percentageFree = (double)writeBytesRemaining / (double)r.capacity() * 100.0;
        if (percentageFree > 0.5) {
            return;
        }
        long writeCount = r.getAndClearWriteCount();
        long readCount = r.getAndClearReadCount();
        LOG.info("ring buffer=" + (r.capacity() - writeBytesRemaining) / 1024L + "KB/" + r.capacity() / 1024L + "KB [" + (int)percentageFree + "% Free], " + "" + "writes=" + writeCount + ", reads=" + readCount + ", " + "maxCopyTimeNs=" + r.maxCopyTimeNs() / 1000L + " us");
    };

    public SingleChronicleQueueBuilder(@NotNull String path) {
        this(new File(path));
    }

    protected SingleChronicleQueueBuilder(@NotNull String path, @NotNull ExcerptFactory<SingleChronicleQueue> excerptFactory) {
        this(new File(path), excerptFactory);
    }

    public SingleChronicleQueueBuilder(@NotNull File path) {
        this(path, (ExcerptFactory<SingleChronicleQueue>)SingleChronicleQueueExcerptFactory.INSTANCE);
    }

    protected SingleChronicleQueueBuilder(@NotNull File path, @NotNull ExcerptFactory<SingleChronicleQueue> excerptFactory) {
        this.path = path;
        this.blockSize = 0x4000000L;
        this.wireType = WireType.BINARY;
        this.rollCycle = RollCycles.DAYS;
        this.epoch = 0L;
        this.excerptFactory = excerptFactory;
    }

    @NotNull
    public static SingleChronicleQueueBuilder binary(@NotNull File name) {
        return SingleChronicleQueueBuilder.binary(name.getAbsolutePath());
    }

    @NotNull
    private static SingleChronicleQueueBuilder binary(@NotNull String name) {
        return new SingleChronicleQueueBuilder(name).wireType(WireType.BINARY);
    }

    @NotNull
    public static SingleChronicleQueueBuilder text(@NotNull File name) {
        return SingleChronicleQueueBuilder.text(name.getAbsolutePath());
    }

    @NotNull
    private static SingleChronicleQueueBuilder text(@NotNull String name) {
        return new SingleChronicleQueueBuilder(name).wireType(WireType.TEXT);
    }

    @NotNull
    public static SingleChronicleQueueBuilder raw(@NotNull File name) {
        return SingleChronicleQueueBuilder.raw(name.getAbsolutePath());
    }

    @NotNull
    private static SingleChronicleQueueBuilder raw(@NotNull String name) {
        return new SingleChronicleQueueBuilder(name).wireType(WireType.RAW);
    }

    @NotNull
    public SingleChronicleQueueBuilder onRingBufferStats(@NotNull Consumer<BytesRingBufferStats> onRingBufferStats) {
        this.onRingBufferStats = onRingBufferStats;
        return this;
    }

    @Override
    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats;
    }

    @Override
    @NotNull
    public File path() {
        return this.path;
    }

    @NotNull
    public SingleChronicleQueueBuilder blockSize(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    @Override
    public long blockSize() {
        return this.blockSize;
    }

    @NotNull
    public SingleChronicleQueueBuilder wireType(@NotNull WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    @NotNull
    public SingleChronicleQueueBuilder rollCycle(@NotNull RollCycle rollCycle) {
        this.rollCycle = rollCycle;
        return this;
    }

    @Override
    public long bufferCapacity() {
        return this.bufferCapacity;
    }

    @NotNull
    public SingleChronicleQueueBuilder bufferCapacity(long ringBufferSize) {
        this.bufferCapacity = ringBufferSize;
        return this;
    }

    @NotNull
    public SingleChronicleQueueBuilder epoch(long epoch) {
        this.epoch = epoch;
        return this;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    @NotNull
    public RollCycle rollCycle() {
        return this.rollCycle;
    }

    @NotNull
    public SingleChronicleQueueBuilder excertpFactory(@NotNull ExcerptFactory<SingleChronicleQueue> excerptFactory) {
        this.excerptFactory = excerptFactory;
        return this;
    }

    public ExcerptFactory<SingleChronicleQueue> excertpFactory() {
        return this.excerptFactory;
    }

    @Override
    @NotNull
    public ChronicleQueue build() {
        if (this.isBuffered && this.eventLoop == null) {
            this.eventLoop = new EventGroup(true, this.onThrowable);
        }
        return new SingleChronicleQueue(this.clone());
    }

    @NotNull
    public SingleChronicleQueueBuilder clone() {
        try {
            return (SingleChronicleQueueBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public SingleChronicleQueueBuilder onThrowable(@NotNull Consumer<Throwable> onThrowable) {
        this.onThrowable = onThrowable;
        return this;
    }

    @NotNull
    public SingleChronicleQueueBuilder buffered(boolean isBuffered) {
        this.isBuffered = isBuffered;
        return this;
    }

    @Override
    public boolean buffered() {
        return this.isBuffered;
    }

    @Override
    @Nullable
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @NotNull
    public SingleChronicleQueueBuilder eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        return this;
    }

    @NotNull
    public SingleChronicleQueueBuilder bufferCapacity(int bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
        this.isBuffered = true;
        return this;
    }
}

