/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesRingBuffer;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.AbstractChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.threads.api.InvalidEventHandlerException;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Excerpts {
    private static final Logger LOG = LoggerFactory.getLogger(Excerpts.class);

    public static class StoreTailer
    implements ExcerptTailer {
        @NotNull
        private final AbstractChronicleQueue queue;
        private Wire wire;
        private long cycle;
        private long index;
        private WireStore store;
        private long nextPrefetch = OS.pageSize();

        public StoreTailer(@NotNull AbstractChronicleQueue queue) throws IOException {
            this.queue = queue;
            this.cycle = -1L;
            this.toStart();
        }

        @Override
        public boolean readDocument(@NotNull ReadMarshallable marshaller) throws IOException {
            return this.readAtIndex(marshaller, ReadMarshallable::readMarshallable);
        }

        @Override
        public boolean readBytes(@NotNull Bytes using) throws IOException {
            return this.readAtIndex(using, (t, w) -> t.write((BytesStore)w.bytes()));
        }

        @Override
        public boolean readBytes(@NotNull ReadBytesMarshallable using) throws IOException {
            return this.readAtIndex(using, (t, w) -> t.readMarshallable(w.bytes()));
        }

        private <T> boolean readAtIndex(T t, @NotNull BiConsumer<T, Wire> c) throws IOException {
            boolean success;
            long readPosition = this.wire.bytes().readPosition();
            long readLimit = this.wire.bytes().readLimit();
            long cycle = this.cycle;
            long index = this.index;
            if (this.store == null) {
                long firstIndex = this.queue.firstIndex();
                if (index == -1L) {
                    return false;
                }
                this.moveToIndex(firstIndex);
            }
            if (success = this.readAt(t, c)) {
                this.index = ChronicleQueue.index(cycle, ChronicleQueue.toSequenceNumber(index) + 1L);
                return true;
            }
            this.cycle(cycle);
            this.wire.bytes().readLimit(readLimit);
            this.wire.bytes().readPosition(readPosition);
            return false;
        }

        private <T> boolean readAt(T t, @NotNull BiConsumer<T, Wire> c) throws IOException {
            do {
                long roll = Long.MIN_VALUE;
                this.wire.bytes().readLimit(this.wire.bytes().capacity());
                while (this.wire.bytes().readLong(this.wire.bytes().readPosition()) != 0L) {
                    DocumentContext documentContext = this.wire.readingDocument();
                    Throwable throwable = null;
                    try {
                        if (!documentContext.isPresent()) {
                            boolean bl = false;
                            return bl;
                        }
                        if (documentContext.isData()) {
                            c.accept(t, this.wire);
                            boolean bl = true;
                            return bl;
                        }
                        StringBuilder sb = Wires.acquireStringBuilder();
                        ValueIn vi = this.wire.readEventName(sb);
                        if (!"roll".contentEquals(sb)) continue;
                        roll = vi.int32();
                        break;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (documentContext == null) continue;
                        if (throwable != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        documentContext.close();
                    }
                }
                if (roll == Long.MIN_VALUE) {
                    return false;
                }
                this.cycle(roll);
            } while (this.store != null);
            return false;
        }

        @Override
        public long index() {
            if (this.store == null) {
                throw new IllegalArgumentException("This tailer is not bound to any cycle");
            }
            return ChronicleQueue.index(this.cycle, this.index);
        }

        @Override
        public boolean moveToIndex(long index) throws IOException {
            long expectedCycle;
            if (LOG.isDebugEnabled()) {
                LOG.debug(SingleChronicleQueueStore.IndexOffset.toBinaryString(index));
                LOG.debug(SingleChronicleQueueStore.IndexOffset.toScale());
            }
            if ((expectedCycle = ChronicleQueue.toCycle(index)) != this.cycle) {
                this.cycle(expectedCycle);
            }
            this.cycle = expectedCycle;
            Bytes bytes = this.wire.bytes();
            long sequenceNumber = ChronicleQueue.toSequenceNumber(index);
            if (sequenceNumber == -1L) {
                bytes.readPosition(0L);
                this.index = ChronicleQueue.index(this.cycle, sequenceNumber);
                return true;
            }
            long position = this.store.moveToIndex(this.wire, ChronicleQueue.toSequenceNumber(index));
            if (position == -1L) {
                return false;
            }
            bytes.readPosition(position);
            bytes.readLimit(bytes.realCapacity());
            this.index = ChronicleQueue.index(this.cycle, sequenceNumber - 1L);
            return true;
        }

        @Override
        @NotNull
        public ExcerptTailer toStart() throws IOException {
            long index = this.queue.firstIndex();
            if (ChronicleQueue.toSequenceNumber(index) == -1L) {
                this.cycle(ChronicleQueue.toCycle(index));
                this.wire.bytes().readPosition(0L);
                return this;
            }
            if (!this.moveToIndex(index)) {
                throw new IllegalStateException("unable to move to the start, cycle=" + this.cycle);
            }
            return this;
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() throws IOException {
            if (!this.moveToIndex(this.queue.lastIndex())) {
                throw new IllegalStateException("unable to move to the start");
            }
            return this;
        }

        @Override
        @NotNull
        public ChronicleQueue queue() {
            return this.queue;
        }

        @NotNull
        private StoreTailer cycle(long cycle) throws IOException {
            if (this.cycle != cycle) {
                if (null != this.store) {
                    this.queue.release(this.store);
                }
                this.cycle = cycle;
                this.store = this.queue.storeForCycle(cycle, this.queue.epoch());
                this.wire = (Wire)this.queue.wireType().apply((Object)this.store.mappedBytes());
                this.moveToIndex(ChronicleQueue.index(cycle, -1L));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("tailer=" + ((MappedBytes)this.wire.bytes()).mappedFile().file().getAbsolutePath());
                }
            }
            return this;
        }

        @Override
        public void prefetch() {
            long position = this.wire.bytes().readPosition();
            if (position < this.nextPrefetch) {
                return;
            }
            long prefetch = OS.mapAlign((long)position) + (long)OS.pageSize();
            this.wire.bytes().compareAndSwapInt(prefetch, -1, -1);
            this.nextPrefetch = prefetch + (long)OS.pageSize();
        }
    }

    public static class StoreAppender
    extends DefaultAppender<AbstractChronicleQueue> {
        long index = -1L;
        private Wire wire;
        private long cycle;
        private WireStore store;
        private long nextPrefetch = OS.pageSize();

        public StoreAppender(@NotNull AbstractChronicleQueue queue) {
            super(queue);
            long lastIndex = ((AbstractChronicleQueue)this.queue).lastIndex();
            long l = this.cycle = lastIndex == -1L ? queue.cycle() : ChronicleQueue.toCycle(lastIndex);
            if (this.cycle < 0L) {
                throw new IllegalArgumentException("You can not have a cycle that starts before Epoch. cycle=" + this.cycle);
            }
            this.store = queue.storeForCycle(this.cycle, queue.epoch());
            this.index = this.store.sequenceNumber();
            MappedBytes mappedBytes = this.store.mappedBytes();
            if (LOG.isDebugEnabled()) {
                LOG.debug("appender file=" + mappedBytes.mappedFile().file().getAbsolutePath());
            }
            this.wire = (Wire)this.queue().wireType().apply((Object)mappedBytes);
        }

        @Override
        public long writeDocument(@NotNull WriteMarshallable writer) throws IOException {
            long position;
            WireStore store = this.store();
            do {
                if ((position = WireInternal.writeDataOrAdvanceIfNotEmpty((WireOut)this.wire, (boolean)false, (WriteMarshallable)writer)) == 0L) continue;
                ++this.index;
            } while (position <= 0L);
            store.writePosition(this.wire.bytes().writePosition());
            store.storeIndexLocation(this.wire, position, this.index);
            return ChronicleQueue.index(store.cycle(), this.index);
        }

        @Override
        public long writeBytes(@NotNull WriteBytesMarshallable marshallable) throws IOException {
            return this.writeDocument(wire1 -> marshallable.writeMarshallable(wire1.bytes()));
        }

        @Override
        public long writeBytes(@NotNull Bytes bytes) throws IOException {
            return this.writeDocument(wire1 -> {
                Bytes cfr_ignored_0 = (Bytes)wire1.bytes().write((BytesStore)bytes);
            });
        }

        @Override
        public long index() {
            if (this.index == -1L) {
                throw new IllegalStateException();
            }
            return ChronicleQueue.index(this.cycle(), this.index);
        }

        @Override
        public long cycle() {
            return this.store.cycle();
        }

        @NotNull
        Wire wire() {
            return this.wire;
        }

        @ForceInline
        private WireStore store() {
            if (this.cycle != ((AbstractChronicleQueue)this.queue).cycle()) {
                long nextCycle = ((AbstractChronicleQueue)this.queue).cycle();
                if (this.store != null) {
                    while (!this.store.appendRollMeta(this.wire, nextCycle)) {
                        Thread.yield();
                    }
                    ((AbstractChronicleQueue)this.queue).release(this.store);
                }
                this.cycle = nextCycle;
                this.store = ((AbstractChronicleQueue)this.queue).storeForCycle(this.cycle, ((AbstractChronicleQueue)this.queue).epoch());
                this.wire = (Wire)this.queue().wireType().apply((Object)this.store.mappedBytes());
            }
            return this.store;
        }

        @Override
        public void prefetch() {
            long position = this.wire.bytes().writePosition();
            if (position < this.nextPrefetch) {
                return;
            }
            long prefetch = OS.mapAlign((long)position);
            this.wire.bytes().compareAndSwapInt(prefetch, -1, -1);
            this.nextPrefetch = prefetch + (long)OS.pageSize();
        }
    }

    public static class BufferedAppender
    implements ExcerptAppender {
        @NotNull
        private final BytesRingBuffer ringBuffer;
        @NotNull
        private final StoreAppender underlyingAppender;
        private final Wire tempWire;
        @NotNull
        private final EventLoop eventLoop;

        public BufferedAppender(@NotNull EventLoop eventLoop, @NotNull StoreAppender underlyingAppender, long ringBufferCapacity, final @NotNull Consumer<BytesRingBufferStats> ringBufferStats) {
            this.eventLoop = eventLoop;
            this.ringBuffer = BytesRingBuffer.newInstance((NativeBytesStore)NativeBytesStore.nativeStoreWithFixedCapacity((long)ringBufferCapacity));
            this.underlyingAppender = underlyingAppender;
            this.tempWire = (Wire)underlyingAppender.queue().wireType().apply((Object)Bytes.elasticByteBuffer());
            EventHandler handler = () -> {
                Wire wire = underlyingAppender.wire();
                Bytes bytes = wire.bytes();
                long start = bytes.writePosition();
                bytes.writeInt(Integer.MIN_VALUE);
                try {
                    if (!this.ringBuffer.read(bytes)) {
                        bytes.writeSkip(-4L);
                        bytes.writeInt(bytes.writePosition(), 0);
                        return false;
                    }
                    long len = bytes.writePosition() - start - 4L;
                    if (len == 0L) {
                        bytes.writeSkip(-4L);
                        bytes.writeInt(bytes.writePosition(), 0);
                        return false;
                    }
                    bytes.writeInt(start, Wires.toIntU30((long)len, (String)"Document length %,d out of 30-bit int range."));
                    ++storeAppender.index;
                    underlyingAppender.store().writePosition(wire.bytes().writePosition());
                    underlyingAppender.store().storeIndexLocation(wire, start, storeAppender.index);
                    return true;
                }
                catch (Throwable t) {
                    throw Jvm.rethrow((Throwable)t);
                }
            };
            eventLoop.addHandler(handler);
            eventLoop.addHandler(new EventHandler(){

                public boolean action() throws InvalidEventHandlerException {
                    ringBufferStats.accept(ringBuffer);
                    return true;
                }

                @NotNull
                public HandlerPriority priority() {
                    return HandlerPriority.MONITOR;
                }
            });
            eventLoop.start();
        }

        @NotNull
        public BytesRingBuffer ringBuffer() {
            return this.ringBuffer;
        }

        @Override
        public long writeDocument(@NotNull WriteMarshallable writer) throws IOException {
            Bytes bytes = this.tempWire.bytes();
            bytes.clear();
            writer.writeMarshallable((WireOut)this.tempWire);
            return this.writeBytes(bytes);
        }

        @Override
        public long writeBytes(@NotNull WriteBytesMarshallable marshallable) throws IOException {
            Bytes bytes = this.tempWire.bytes();
            bytes.clear();
            marshallable.writeMarshallable(bytes);
            return this.writeBytes(bytes);
        }

        @Override
        public long writeBytes(@NotNull Bytes<?> bytes) throws IOException {
            try {
                while (!this.ringBuffer.offer(bytes)) {
                    Thread.yield();
                }
                this.eventLoop.unpause();
            }
            catch (InterruptedException e) {
                throw Jvm.rethrow((Throwable)e);
            }
            return -1L;
        }

        @Override
        public long index() {
            throw new UnsupportedOperationException("");
        }

        @Override
        public long cycle() {
            return this.underlyingAppender.cycle();
        }

        @Override
        @NotNull
        public ChronicleQueue queue() {
            return this.underlyingAppender.queue();
        }

        @Override
        public void prefetch() {
        }
    }

    public static abstract class DefaultAppender<T extends ChronicleQueue>
    implements ExcerptAppender {
        @NotNull
        final T queue;

        public DefaultAppender(@NotNull T queue) {
            this.queue = queue;
        }

        @Override
        public long writeDocument(@NotNull WriteMarshallable writer) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long writeBytes(@NotNull Bytes<?> bytes) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long index() {
            throw new UnsupportedOperationException();
        }

        @Override
        public abstract long cycle();

        @Override
        @NotNull
        public ChronicleQueue queue() {
            return this.queue;
        }
    }
}

