/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.ringbuffer;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.zip.Deflater;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.ringbuffer.BytesRingBuffer;
import net.openhft.chronicle.threads.NamedThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZippedDocumentAppender
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)ZippedDocumentAppender.class.getName());
    @NotNull
    private final BytesRingBuffer q;
    @NotNull
    private final ChronicleQueue chronicleQueue;
    public static final String ERR_MSG = "It not possible to zip more than Integer.MAX_VALUE bytes in one go";
    @NotNull
    private final ExecutorService qReader;

    public ZippedDocumentAppender(@NotNull BytesRingBuffer bytesRingBuffer, @NotNull ChronicleQueue chronicleQueue) {
        this.q = bytesRingBuffer;
        this.chronicleQueue = chronicleQueue;
        this.qReader = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("qReader"));
        this.qReader.submit(new Consumer());
    }

    public void append(@NotNull Bytes bytes) throws InterruptedException {
        while (!this.q.offer(bytes)) {
        }
    }

    @Override
    public void close() {
        this.qReader.shutdown();
    }

    private class Consumer
    implements BytesRingBuffer.BytesProvider,
    Runnable {
        @NotNull
        private Deflater compresser = new Deflater();
        @NotNull
        private byte[] input = new byte[0];
        @NotNull
        private byte[] output = new byte[0];
        @NotNull
        private Bytes<ByteBuffer> inputBuffer = BytesStore.wrap((ByteBuffer)ByteBuffer.wrap(this.input)).bytesForRead();
        @NotNull
        private Bytes<ByteBuffer> outputBuffer = BytesStore.wrap((ByteBuffer)ByteBuffer.wrap(this.input)).bytesForWrite();

        private Consumer() {
            this.input = new byte[0];
            this.inputBuffer = BytesStore.wrap((ByteBuffer)ByteBuffer.wrap(this.input)).bytesForRead();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Bytes value;
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    while ((value = ZippedDocumentAppender.this.q.poll(this)) == null) {
                    }
                    this.compresser.setInput(this.input, (int)value.readPosition(), (int)value.readRemaining());
                    this.compresser.finish();
                    int limit = this.compresser.deflate(this.output);
                    this.compresser.end();
                    this.outputBuffer.writePosition(0L);
                    this.outputBuffer.writeLimit((long)limit);
                    ExcerptAppender appender = ZippedDocumentAppender.this.chronicleQueue.createAppender();
                    appender.writeDocument(w -> w.write(() -> "zipped").bytes(this.outputBuffer));
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
                return;
            }
        }

        @Override
        @NotNull
        public Bytes provide(long maxSize) {
            if (maxSize < this.inputBuffer.capacity()) {
                return (Bytes)this.inputBuffer.clear();
            }
            if (maxSize > Integer.MAX_VALUE) {
                throw new IllegalStateException(ZippedDocumentAppender.ERR_MSG);
            }
            this.input = new byte[(int)maxSize];
            this.inputBuffer = BytesStore.wrap((ByteBuffer)ByteBuffer.wrap(this.input)).bytesForRead();
            this.output = new byte[(int)maxSize];
            this.outputBuffer = BytesStore.wrap((ByteBuffer)ByteBuffer.wrap(this.output)).bytesForWrite();
            return this.inputBuffer;
        }
    }
}

