/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.tcp;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import net.openhft.chronicle.network.NetworkUtil;
import net.openhft.chronicle.network.tcp.ChronicleSocket;

public enum ChronicleSocketFactory {


    public static ChronicleSocket toChronicleSocket(final Socket socket) {
        return new ChronicleSocket(){

            @Override
            public void setTcpNoDelay(boolean tcpNoDelay) throws SocketException {
                NetworkUtil.setTcpNoDelay(socket, tcpNoDelay);
            }

            @Override
            public int getReceiveBufferSize() throws SocketException {
                return socket.getReceiveBufferSize();
            }

            @Override
            public void setReceiveBufferSize(int tcpBuffer) throws SocketException {
                socket.setReceiveBufferSize(tcpBuffer);
            }

            @Override
            public int getSendBufferSize() throws SocketException {
                return socket.getSendBufferSize();
            }

            @Override
            public void setSendBufferSize(int tcpBuffer) throws SocketException {
                socket.setSendBufferSize(tcpBuffer);
            }

            @Override
            public void setSoTimeout(int i) throws SocketException {
                socket.setSoTimeout(i);
            }

            @Override
            public void setSoLinger(boolean b, int i) throws SocketException {
                socket.setSoLinger(b, i);
            }

            @Override
            public void shutdownInput() throws IOException {
                socket.shutdownInput();
            }

            @Override
            public void shutdownOutput() throws IOException {
                socket.shutdownOutput();
            }

            @Override
            public Object getRemoteSocketAddress() {
                return socket.getRemoteSocketAddress();
            }

            @Override
            public Object getLocalSocketAddress() {
                return socket.getLocalSocketAddress();
            }

            @Override
            public int getLocalPort() {
                return socket.getLocalPort();
            }
        };
    }
}

