/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.network.ConnectionStrategy;
import net.openhft.chronicle.network.NetworkUtil;
import net.openhft.chronicle.network.VanillaClientConnectionMonitor;
import net.openhft.chronicle.network.connection.ClientConnectionMonitor;
import net.openhft.chronicle.wire.AbstractMarshallableCfg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConnectionStrategy
extends AbstractMarshallableCfg
implements ConnectionStrategy {
    protected int tcpBufferSize = Jvm.getInteger((String)"tcp.client.buffer.size", (Integer)NetworkUtil.TCP_BUFFER_SIZE);
    private final transient AtomicBoolean isClosed = new AtomicBoolean(false);
    protected ClientConnectionMonitor clientConnectionMonitor = new VanillaClientConnectionMonitor();
    protected String localSocketBindingHost;
    protected int localSocketBindingPort = 0;
    protected String localBindingNetworkInterface;
    protected ProtocolFamily localBindingProtocolFamily;

    @Override
    @Nullable
    public InetSocketAddress localSocketBinding() throws SocketException, UnknownHostException, IllegalStateException {
        if (this.localSocketBindingHost != null && this.localBindingNetworkInterface != null) {
            Jvm.warn().on(AbstractConnectionStrategy.class, "You have specified both localSocketBindingHost and localBindingNetworkInterface, using localSocketBindingHost");
        }
        if (this.localSocketBindingHost != null) {
            return this.getSocketBindingForHostName();
        }
        if (this.localBindingNetworkInterface != null) {
            return this.getSocketBindingForInterface();
        }
        return null;
    }

    @NotNull
    private InetSocketAddress getSocketBindingForHostName() throws UnknownHostException {
        List permittedAddresses = Arrays.stream(InetAddress.getAllByName(this.localSocketBindingHost)).filter(this::addressPermittedByProtocolFamily).collect(Collectors.toList());
        if (permittedAddresses.size() > 1) {
            Jvm.warn().on(AbstractConnectionStrategy.class, "Multiple eligible addresses available for hostname/protocol " + this.localSocketBindingHost + "/" + this.protocolFamilyAsString() + " (" + permittedAddresses + "), using " + permittedAddresses.get(0));
        } else if (permittedAddresses.isEmpty()) {
            throw new IllegalStateException("None of addresses for hostname " + this.localSocketBindingHost + " available for binding for protocol " + this.protocolFamilyAsString());
        }
        return new InetSocketAddress((InetAddress)permittedAddresses.get(0), this.localSocketBindingPort);
    }

    @NotNull
    private InetSocketAddress getSocketBindingForInterface() throws SocketException {
        List<InetAddress> permittedAddresses = this.permittedAddressesForInterface();
        if (permittedAddresses.size() > 1) {
            Jvm.warn().on(AbstractConnectionStrategy.class, "Multiple eligible addresses available on interface/protocol " + this.localBindingNetworkInterface + "/" + this.protocolFamilyAsString() + " (" + permittedAddresses + "), using " + permittedAddresses.get(0));
        } else if (permittedAddresses.isEmpty()) {
            throw new IllegalStateException("None of addresses from interface " + this.localBindingNetworkInterface + " available for binding for protocol " + this.protocolFamilyAsString());
        }
        return new InetSocketAddress(permittedAddresses.get(0), this.localSocketBindingPort);
    }

    private String protocolFamilyAsString() {
        return this.localBindingProtocolFamily != null ? this.localBindingProtocolFamily.toString() : "ANY";
    }

    private List<InetAddress> permittedAddressesForInterface() throws SocketException {
        NetworkInterface networkInterface = NetworkInterface.getByName(this.localBindingNetworkInterface);
        if (networkInterface == null) {
            throw new IllegalStateException("No matching interface found for name " + this.localBindingNetworkInterface + ", available interfaces: " + this.getAvailableInterfaceNames());
        }
        ArrayList<InetAddress> permittedAddresses = new ArrayList<InetAddress>();
        Enumeration<InetAddress> addressEnumeration = networkInterface.getInetAddresses();
        while (addressEnumeration.hasMoreElements()) {
            InetAddress address = addressEnumeration.nextElement();
            if (!this.addressPermittedByProtocolFamily(address)) continue;
            permittedAddresses.add(address);
        }
        return permittedAddresses;
    }

    private String getAvailableInterfaceNames() throws SocketException {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        boolean first = true;
        while (networkInterfaces.hasMoreElements()) {
            if (!first) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(networkInterfaces.nextElement().getName());
            first = false;
        }
        return stringBuilder.toString();
    }

    private boolean addressPermittedByProtocolFamily(InetAddress address) {
        if (this.localBindingProtocolFamily == null) {
            return true;
        }
        if (this.localBindingProtocolFamily == StandardProtocolFamily.INET) {
            return address instanceof Inet4Address;
        }
        if (this.localBindingProtocolFamily == StandardProtocolFamily.INET6) {
            return address instanceof Inet6Address;
        }
        return false;
    }

    public void localSocketBindingHost(String localSocketBindingHost) {
        this.localSocketBindingHost = localSocketBindingHost;
    }

    public void localSocketBindingPort(int localSocketBindingPort) {
        this.localSocketBindingPort = localSocketBindingPort;
    }

    public void localBindingNetworkInterface(String localBindingNetworkInterface) {
        this.localBindingNetworkInterface = localBindingNetworkInterface;
    }

    public void localBindingProtocolFamily(ProtocolFamily localBindingProtocolFamily) {
        this.localBindingProtocolFamily = localBindingProtocolFamily;
    }

    @Override
    public AbstractConnectionStrategy open() {
        this.isClosed.set(false);
        return this;
    }

    @Override
    public void close() {
        this.isClosed.set(true);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    protected long defaultMinPauseSec() {
        return ConnectionStrategy.super.minPauseSec();
    }

    protected long defaultMaxPauseSec() {
        return ConnectionStrategy.super.maxPauseSec();
    }
}

