/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.ssl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.internal.HeapBytesStore;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.core.internal.util.DirectBufferUtil;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.ssl.BufferHandler;

@Deprecated
public final class BytesBufferHandler<N extends NetworkContext<N>>
extends SimpleCloseable
implements BufferHandler {
    private static final Bytes<ByteBuffer> EMPTY_APPLICATION_INPUT = Bytes.wrapForRead((ByteBuffer)ByteBuffer.allocate(0));
    private TcpHandler<N> delegateHandler;
    private Bytes<ByteBuffer> input;
    private Bytes<ByteBuffer> output;
    private N networkContext;
    private Reference<ByteBuffer> decryptedInBuf;
    private Bytes<ByteBuffer> decryptedInput;
    private Reference<ByteBuffer> decryptedOutBuf;
    private Bytes<ByteBuffer> decryptedOutput;

    public void set(TcpHandler<N> delegate, Bytes<ByteBuffer> input, Bytes<ByteBuffer> output, N networkContext) {
        this.delegateHandler = delegate;
        this.input = input;
        this.output = output;
        this.networkContext = networkContext;
    }

    @Override
    public int readData(ByteBuffer target) {
        int toRead = Math.min(target.remaining(), (int)this.input.readRemaining());
        this.input.read(target);
        return toRead;
    }

    @Override
    public void handleDecryptedData(ByteBuffer input, ByteBuffer output) {
        boolean atStart;
        boolean bl = atStart = input.position() == 0;
        if (!atStart) {
            input.flip();
        }
        this.prepareBuffers(input, output);
        Bytes<ByteBuffer> applicationInput = this.decryptedInput;
        if (atStart) {
            applicationInput = EMPTY_APPLICATION_INPUT;
        }
        this.delegateHandler.process(applicationInput, this.decryptedOutput, this.networkContext);
        output.position((int)this.decryptedOutput.writePosition());
        input.position((int)this.decryptedInput.readPosition());
        if (this.decryptedInput.readPosition() != 0L) {
            input.compact();
        }
    }

    private void prepareBuffers(ByteBuffer input, ByteBuffer output) {
        if (this.decryptedInBuf == null || input != this.decryptedInBuf.get() || this.decryptedInput == null) {
            if (this.decryptedInput != null) {
                this.decryptedInput.releaseLast();
            }
            this.decryptedInput = this.wrap(input);
            this.decryptedInBuf = new WeakReference<ByteBuffer>(input);
        }
        this.decryptedInput.readPosition((long)input.position());
        this.decryptedInput.readLimit((long)input.limit());
        if (this.decryptedOutBuf == null || output != this.decryptedOutBuf.get() || this.decryptedOutput == null) {
            if (this.decryptedOutput != null) {
                this.decryptedOutput.releaseLast();
            }
            this.decryptedOutput = this.wrap(output);
            this.decryptedOutBuf = new WeakReference<ByteBuffer>(output);
        }
        this.decryptedOutput.writePosition((long)output.position());
        this.decryptedOutput.writeLimit((long)output.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bytes<ByteBuffer> wrap(ByteBuffer bb) {
        NativeBytesStore bs = bb.isDirect() ? new NativeBytesStore(DirectBufferUtil.addressOrThrow((ByteBuffer)bb), (long)bb.capacity()) : HeapBytesStore.wrap((ByteBuffer)bb);
        try {
            Bytes bytes = bs.bytesForRead();
            return bytes;
        }
        finally {
            bs.release(ReferenceOwner.INIT);
        }
    }

    @Override
    public int writeData(ByteBuffer encrypted) {
        if (this.output.readPosition() != 0L) {
            this.output.compact();
        }
        int writeRemaining = (int)(this.output.writeRemaining() > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.output.writeRemaining());
        int toWrite = Math.min(encrypted.remaining(), writeRemaining);
        this.output.writeSome(encrypted);
        return toWrite;
    }

    protected void performClose() {
        if (this.decryptedOutput != null) {
            this.decryptedOutput.releaseLast();
        }
        if (this.decryptedInput != null) {
            this.decryptedInput.releaseLast();
        }
    }
}

