/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.api.session;

import java.net.InetSocketAddress;
import java.util.UUID;
import net.openhft.chronicle.network.SessionMode;
import net.openhft.chronicle.network.connection.EventId;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SessionDetails
extends WriteMarshallable {
    public UUID sessionId();

    public UUID clientId();

    @Nullable
    public String userId();

    @Nullable
    public String securityToken();

    @Nullable
    public String domain();

    public SessionMode sessionMode();

    @Nullable
    public InetSocketAddress clientAddress();

    public long connectTimeMS();

    public <I> void set(Class<I> var1, I var2);

    @NotNull
    public <I> I get(Class<I> var1);

    @Nullable
    public WireType wireType();

    public byte hostId();

    default public void writeMarshallable(@NotNull WireOut w) {
        w.writeEventName((WireKey)EventId.userId).text(this.userId()).writeEventName((WireKey)EventId.domain).text(this.domain());
        if (this.sessionMode() != null) {
            w.writeEventName((WireKey)EventId.sessionMode).text(this.sessionMode().toString());
        }
        w.writeEventName((WireKey)EventId.securityToken).text(this.securityToken()).writeEventName((WireKey)EventId.clientId).text(this.clientId().toString()).writeEventName((WireKey)EventId.hostId).int8(this.hostId()).writeEventName((WireKey)EventId.wireType).asEnum((Enum)this.wireType());
    }
}

