/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.HeartbeatListener;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaNetworkContext<T extends NetworkContext<T>>
extends AbstractCloseable
implements NetworkContext<T> {
    private ChronicleSocketChannel socketChannel;
    private boolean isAcceptor = true;
    private HeartbeatListener heartbeatListener;
    private SessionDetailsProvider sessionDetails;
    private long heartbeatTimeoutMs;
    private WireOutPublisher wireOutPublisher;
    private WireType wireType = WireType.TEXT;
    private Runnable socketReconnector;
    @Nullable
    private NetworkStatsListener<T> networkStatsListener;
    @Deprecated
    private ServerThreadingStrategy serverThreadingStrategy = ServerThreadingStrategy.SINGLE_THREADED;

    public VanillaNetworkContext() {
        this.singleThreadedCheckDisabled(true);
    }

    @Override
    public ChronicleSocketChannel socketChannel() {
        return this.socketChannel;
    }

    protected boolean shouldPerformCloseInBackground() {
        return false;
    }

    @Override
    @NotNull
    public T socketChannel(@NotNull ChronicleSocketChannel socketChannel) {
        this.throwExceptionIfClosedInSetter();
        this.socketChannel = socketChannel;
        return this.self();
    }

    @Override
    public void onHandlerChanged(TcpHandler<T> handler) {
    }

    @Override
    @NotNull
    public T isAcceptor(boolean isAcceptor) {
        this.throwExceptionIfClosedInSetter();
        this.isAcceptor = isAcceptor;
        return this.self();
    }

    @Override
    public boolean isAcceptor() {
        return this.isAcceptor;
    }

    @Override
    public synchronized WireOutPublisher wireOutPublisher() {
        return this.wireOutPublisher;
    }

    @Override
    public T wireOutPublisher(@NotNull WireOutPublisher wireOutPublisher) {
        this.throwExceptionIfClosedInSetter();
        this.wireOutPublisher = wireOutPublisher;
        return this.self();
    }

    @Override
    public WireType wireType() {
        return this.wireType;
    }

    @Override
    @NotNull
    public T wireType(@NotNull WireType wireType) {
        this.throwExceptionIfClosedInSetter();
        this.wireType = wireType;
        return this.self();
    }

    @Override
    public SessionDetailsProvider sessionDetails() {
        return this.sessionDetails;
    }

    @Override
    @NotNull
    public T sessionDetails(SessionDetailsProvider sessionDetails) {
        this.throwExceptionIfClosedInSetter();
        this.sessionDetails = sessionDetails;
        return this.self();
    }

    @Override
    public T heartbeatTimeoutMs(long heartbeatTimeoutMs) {
        this.throwExceptionIfClosedInSetter();
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
        return this.self();
    }

    @Override
    public long heartbeatTimeoutMs() {
        return this.heartbeatTimeoutMs;
    }

    @Override
    public HeartbeatListener heartbeatListener() {
        return this.heartbeatListener;
    }

    @Override
    public void heartbeatListener(@NotNull HeartbeatListener heartbeatListener) {
        this.throwExceptionIfClosedInSetter();
        this.heartbeatListener = heartbeatListener;
    }

    protected void performClose() {
        Closeable.closeQuietly((Object[])new Object[]{this.socketChannel, this.wireOutPublisher, this.networkStatsListener});
    }

    @Override
    public Runnable socketReconnector() {
        return this.socketReconnector;
    }

    @Override
    @NotNull
    public T socketReconnector(Runnable socketReconnector) {
        this.throwExceptionIfClosedInSetter();
        Closeable.closeQuietly((Object)this.socketReconnector);
        this.socketReconnector = socketReconnector;
        return this.self();
    }

    @Override
    public void networkStatsListener(@NotNull NetworkStatsListener<T> networkStatsListener) {
        this.throwExceptionIfClosedInSetter();
        this.networkStatsListener = networkStatsListener;
    }

    @Override
    @Nullable
    public NetworkStatsListener<T> networkStatsListener() {
        return this.networkStatsListener;
    }

    @Override
    @Deprecated
    public ServerThreadingStrategy serverThreadingStrategy() {
        return this.serverThreadingStrategy;
    }

    @Override
    @Deprecated
    public T serverThreadingStrategy(ServerThreadingStrategy serverThreadingStrategy) {
        this.throwExceptionIfClosedInSetter();
        this.serverThreadingStrategy = serverThreadingStrategy;
        return this.self();
    }

    private T self() {
        return (T)this;
    }
}

