/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster.handlers;

import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.network.ConnectionListener;
import net.openhft.chronicle.network.api.session.SubHandler;
import net.openhft.chronicle.network.api.session.WritableSubHandler;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.network.cluster.ConnectionManager;
import net.openhft.chronicle.network.cluster.HeartbeatEventHandler;
import net.openhft.chronicle.network.cluster.handlers.CspTcpHandler;
import net.openhft.chronicle.network.cluster.handlers.RejectedHandlerException;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UberHandler<T extends ClusteredNetworkContext<T>>
extends CspTcpHandler<T>
implements Demarshallable,
WriteMarshallable {
    private final int remoteIdentifier;
    private final int localIdentifier;
    @Nullable
    private ConnectionManager.EventEmitterToken eventEmitterToken;
    @Nullable
    private ConnectionManager<T> connectionChangedNotifier;
    private int writerOffset = 0;

    @UsedViaReflection
    private UberHandler(@NotNull WireIn wire) {
        this.remoteIdentifier = wire.read("remoteIdentifier").int32();
        this.localIdentifier = wire.read("localIdentifier").int32();
        @NotNull WireType wireType = (WireType)Objects.requireNonNull(wire.read("wireType").object(WireType.class));
        this.wireType(wireType);
    }

    private UberHandler(int localIdentifier, int remoteIdentifier, @NotNull WireType wireType) {
        this.localIdentifier = localIdentifier;
        this.remoteIdentifier = remoteIdentifier;
        this.checkRemoteAndLocalIdentifiersAreNotEqual();
        this.wireType(wireType);
    }

    public static WriteMarshallable uberHandler(int localIdentifier, int remoteIdentifier, WireType wireType) {
        return wire -> {
            try (DocumentContext ignored = wire.writingDocument(true);){
                wire.write(() -> "handler").typedMarshallable(new UberHandler(localIdentifier, remoteIdentifier, wireType));
            }
        };
    }

    public int remoteIdentifier() {
        return this.remoteIdentifier;
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((CharSequence)"remoteIdentifier").int32(this.localIdentifier);
        wire.write((CharSequence)"localIdentifier").int32(this.remoteIdentifier);
        wire.write((CharSequence)"wireType").object((Object)this.wireType);
    }

    @Override
    protected void onInitialize() {
        @NotNull ClusteredNetworkContext nc = (ClusteredNetworkContext)this.nc();
        nc.wireType(this.wireType());
        this.isAcceptor(nc.isAcceptor());
        this.validateIdentifiers();
        @NotNull WireOutPublisher publisher = nc.wireOutPublisher();
        this.publisher(publisher);
        @NotNull EventLoop eventLoop = nc.eventLoop();
        if (!eventLoop.isClosing()) {
            eventLoop.start();
            if (((ClusteredNetworkContext)this.nc()).isAcceptor()) {
                this.publish(UberHandler.uberHandler(this.localIdentifier, this.remoteIdentifier, this.wireType));
            }
            if (!this.isClosed()) {
                this.notifyConnectionListeners();
            }
        }
    }

    private void validateIdentifiers() {
        this.checkIdentifierEqualsHostId();
        this.checkRemoteAndLocalIdentifiersAreNotEqual();
    }

    private void checkRemoteAndLocalIdentifiersAreNotEqual() {
        if (this.remoteIdentifier == this.localIdentifier) {
            throw new IllegalArgumentException("remoteIdentifier=" + this.remoteIdentifier + ", localIdentifier=" + this.localIdentifier);
        }
    }

    private void checkIdentifierEqualsHostId() {
        byte localHostIdentifier = ((ClusteredNetworkContext)this.nc()).getLocalHostIdentifier();
        if (this.localIdentifier != localHostIdentifier && localHostIdentifier != 0) {
            throw new IllegalArgumentException("Received a handler for host ID: " + this.localIdentifier + ", my host ID is: " + localHostIdentifier + " this is probably a configuration error");
        }
    }

    private void notifyConnectionListeners() {
        this.connectionChangedNotifier = ((ClusterContext)((Object)((ClusteredNetworkContext)this.nc()).clusterContext())).connectionManager(this.remoteIdentifier);
        if (this.connectionChangedNotifier != null) {
            this.eventEmitterToken = this.connectionChangedNotifier.onConnectionChanged(true, this.nc(), this.eventEmitterToken);
        }
    }

    @Override
    protected void performClose() {
        ClusteredNetworkContext nc = (ClusteredNetworkContext)this.nc();
        if (this.connectionChangedNotifier != null) {
            this.eventEmitterToken = this.connectionChangedNotifier.onConnectionChanged(false, nc, this.eventEmitterToken);
        }
        try {
            ConnectionListener listener;
            if (nc != null && (listener = nc.acquireConnectionListener()) != null) {
                listener.onDisconnected(this.localIdentifier, this.remoteIdentifier(), nc.isAcceptor());
            }
        }
        catch (Exception e) {
            Jvm.error().on(this.getClass(), "close:", (Throwable)e);
            throw Jvm.rethrow((Throwable)e);
        }
        Closeable.closeQuietly((Object)this.writers);
        this.writers.clear();
        super.performClose();
    }

    @Override
    protected void onRead(@NotNull DocumentContext dc, @NotNull WireOut outWire) {
        try {
            if (this.isClosing()) {
                return;
            }
            SubHandler handler = this.handler();
            if (handler != null && handler.inProgress()) {
                try {
                    if (!handler.onTouch(outWire)) {
                        dc.rollbackOnClose();
                        return;
                    }
                }
                catch (Exception e) {
                    this.removeHandler(handler);
                }
                return;
            }
            this.onMessageReceivedOrWritten();
            Wire inWire = dc.wire();
            if (dc.isMetaData()) {
                if (!this.readMeta((WireIn)inWire)) {
                    return;
                }
                SubHandler handler2 = this.handler();
                handler2.remoteIdentifier(this.remoteIdentifier);
                handler2.localIdentifier(this.localIdentifier);
                try {
                    handler2.onInitialize(outWire);
                    if (handler2.inProgress()) {
                        dc.rollbackOnClose();
                        return;
                    }
                }
                catch (RejectedExecutionException e) {
                    Jvm.warn().on(this.getClass(), "EventGroup shutdown", (Throwable)e);
                    this.removeHandler(handler2);
                }
                catch (RejectedHandlerException ex) {
                    Jvm.warn().on(this.getClass(), "Removing rejected handler: " + handler2 + ", message=" + ex.getMessage(), (Throwable)ex);
                    this.removeHandler(handler2);
                }
                return;
            }
            SubHandler handler3 = this.handler();
            if (handler3 != null && dc.isData() && !inWire.bytes().isEmpty()) {
                try {
                    handler3.onRead((WireIn)inWire, outWire);
                }
                catch (RejectedHandlerException ex) {
                    Jvm.warn().on(this.getClass(), "Removing rejected handler: " + handler3 + ", message=" + ex.getMessage(), (Throwable)ex);
                    this.removeHandler(handler3);
                }
            } else if (handler3 == null) {
                Jvm.warn().on(this.getClass(), "handler == null, check that the Csp/Cid has been sent, failed to fully process the following YAML\n");
            }
        }
        catch (ClosedIllegalStateException e) {
            Jvm.warn().on(this.getClass(), this.toString(), (Throwable)e);
            this.close();
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), this.toString(), e);
        }
    }

    @Override
    public void performIdleWork() {
        if (this.connectionChangedNotifier != null && this.eventEmitterToken != null) {
            this.connectionChangedNotifier.executeNewListeners(this.nc(), this.eventEmitterToken);
        }
    }

    @Override
    protected void onBytesWritten() {
        this.onMessageReceivedOrWritten();
    }

    @Override
    protected void onWrite(@NotNull WireOut outWire) {
        super.onWrite(outWire);
        int removedCount = 0;
        for (int i = 0; i < this.writers.size(); ++i) {
            int writerIndex = (i + this.writerOffset - removedCount) % this.writers.size();
            try {
                if (this.isClosing()) {
                    return;
                }
                WritableSubHandler w = (WritableSubHandler)this.writers.get(writerIndex);
                if (w == null) continue;
                w.onWrite(outWire);
                continue;
            }
            catch (RejectedHandlerException e) {
                WritableSubHandler handler = (WritableSubHandler)this.writers.get(writerIndex);
                Jvm.warn().on(this.getClass(), "Removing rejected handler: " + handler + ", message=" + e.getMessage(), (Throwable)e);
                this.removeHandler(handler);
                ++removedCount;
                continue;
            }
            catch (Exception e) {
                Jvm.error().on(this.getClass(), "onWrite:", (Throwable)e);
                throw Jvm.rethrow((Throwable)e);
            }
        }
        if (!this.writers.isEmpty()) {
            this.writerOffset = (this.writerOffset + 1) % this.writers.size();
        }
    }

    private void onMessageReceivedOrWritten() {
        HeartbeatEventHandler heartbeatEventHandler = this.heartbeatEventHandler();
        if (heartbeatEventHandler != null) {
            heartbeatEventHandler.onMessageReceived();
        }
    }

    public String toString() {
        return "UberHandler{remoteIdentifier=" + this.remoteIdentifier + ", localIdentifier=" + this.localIdentifier + '}';
    }
}

