/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.network.NetworkContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionManager<T extends NetworkContext<T>> {
    private static final int EMPTY_SEQUENCE = -1;
    private final Set<ConnectionListenerHolder<?>> connectionListeners = Collections.newSetFromMap(new IdentityHashMap());
    private final AtomicInteger lastListenerAddedSequence = new AtomicInteger(-1);

    public synchronized void addListener(@NotNull ConnectionListener<T> connectionListener) {
        this.connectionListeners.add(new ConnectionListenerHolder<T>(this.lastListenerAddedSequence.incrementAndGet(), connectionListener));
    }

    public void executeNewListeners(@NotNull T nc, @NotNull EventEmitterToken token) {
        assert (token != null) : "Only emitters who've already emitted should call executeNewListeners";
        if (this.lastListenerAddedSequence.get() > token.latestSequenceExecuted) {
            this.executeListenersWithSequenceGreaterThan(token.latestSequenceExecuted, nc, token);
        }
    }

    public EventEmitterToken onConnectionChanged(boolean isConnected, @NotNull T nc, @Nullable EventEmitterToken token) {
        EventEmitterToken tokenToUse = token == null ? new EventEmitterToken() : token;
        if (tokenToUse.connected.compareAndSet(!isConnected, isConnected)) {
            this.executeListenersWithSequenceGreaterThan(-1, nc, tokenToUse);
        }
        return tokenToUse;
    }

    private synchronized void executeListenersWithSequenceGreaterThan(int lowerSequenceLimit, @NotNull T nc, @NotNull EventEmitterToken token) {
        this.connectionListeners.forEach(l -> {
            if (((ConnectionListenerHolder)l).sequence > lowerSequenceLimit) {
                try {
                    ((ConnectionListenerHolder)l).connectionListener.onConnectionChange(nc, token.connected.get());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                token.latestSequenceExecuted = Math.max(token.latestSequenceExecuted, ((ConnectionListenerHolder)l).sequence);
            }
        });
    }

    public static final class EventEmitterToken {
        private final AtomicBoolean connected = new AtomicBoolean(false);
        private volatile int latestSequenceExecuted = Integer.MIN_VALUE;

        private EventEmitterToken() {
        }
    }

    private static final class ConnectionListenerHolder<C extends NetworkContext<C>> {
        private final int sequence;
        private final ConnectionListener<C> connectionListener;

        public ConnectionListenerHolder(int sequence, ConnectionListener<C> connectionListener) {
            this.sequence = sequence;
            this.connectionListener = connectionListener;
        }
    }

    @FunctionalInterface
    public static interface ConnectionListener<T extends NetworkContext<T>> {
        public void onConnectionChange(T var1, boolean var2);
    }
}

