/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.network.AlwaysStartOnPrimaryConnectionStrategy;
import net.openhft.chronicle.network.HostnamePortLookupTable;
import net.openhft.chronicle.network.api.NetworkStats;
import net.openhft.chronicle.network.internal.lookuptable.FileBasedHostnamePortLookupTable;
import net.openhft.chronicle.network.internal.lookuptable.ProcessLocalHostnamePortLookupTable;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketFactory;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannelFactory;
import org.jetbrains.annotations.NotNull;

public final class TCPRegistry
extends Enum<TCPRegistry> {
    public static final String TCP_REGISTRY_LOOKUP_TABLE_IMPLEMENTATION_PROPERTY = "chronicle.tcpRegistry.lookupTableImplementation";
    static HostnamePortLookupTable lookupTable;
    static final Map<String, ChronicleServerSocketChannel> DESC_TO_SERVER_SOCKET_CHANNEL_MAP;
    private static final /* synthetic */ TCPRegistry[] $VALUES;

    public static TCPRegistry[] values() {
        return (TCPRegistry[])$VALUES.clone();
    }

    public static TCPRegistry valueOf(String name) {
        return Enum.valueOf(TCPRegistry.class, name);
    }

    public static void useCrossProcessRegistry() {
        System.setProperty(TCP_REGISTRY_LOOKUP_TABLE_IMPLEMENTATION_PROPERTY, FileBasedHostnamePortLookupTable.class.getName());
    }

    public static void useInMemoryRegistry() {
        System.setProperty(TCP_REGISTRY_LOOKUP_TABLE_IMPLEMENTATION_PROPERTY, ProcessLocalHostnamePortLookupTable.class.getName());
    }

    public static void reset() {
        Closeable.closeQuietly(DESC_TO_SERVER_SOCKET_CHANNEL_MAP.values());
        Closeable.closeQuietly((Object)lookupTable);
        lookupTable = null;
        DESC_TO_SERVER_SOCKET_CHANNEL_MAP.clear();
        Jvm.pause((long)50L);
    }

    public static Set<String> aliases() {
        return TCPRegistry.lookupTable().aliases();
    }

    public static void assertAllServersStopped() {
        @NotNull ArrayList<String> closed = new ArrayList<String>();
        for (Map.Entry<String, ChronicleServerSocketChannel> entry : DESC_TO_SERVER_SOCKET_CHANNEL_MAP.entrySet()) {
            if (entry.getValue().isOpen()) {
                closed.add(entry.toString());
            }
            Closeable.closeQuietly((Object)entry.getValue());
        }
        TCPRegistry.lookupTable().clear();
        DESC_TO_SERVER_SOCKET_CHANNEL_MAP.clear();
        if (!closed.isEmpty()) {
            throw new AssertionError((Object)("Had to stop " + closed));
        }
    }

    public static void setAlias(String name, @NotNull String hostname, int port) {
        TCPRegistry.addInetSocketAddress(name, hostname, port);
    }

    public static void createServerSocketChannelFor(String ... descriptions) throws IOException {
        TCPRegistry.createServerSocketChannelFor(false, descriptions);
    }

    public static void createServerSocketChannelFor(boolean isNative, String ... descriptions) throws IOException {
        for (String description : descriptions) {
            InetSocketAddress address;
            if (description.contains(":")) {
                @NotNull String[] split = description.trim().split(":");
                String host = split[0];
                int port = Integer.parseInt(split[1]);
                address = TCPRegistry.createInetSocketAddress(host, port);
            } else {
                address = new InetSocketAddress("localhost", 0);
            }
            TCPRegistry.createSSC(isNative, description, address);
        }
    }

    private static void createSSC(boolean isNative, String description, InetSocketAddress address) throws IOException {
        ChronicleServerSocketChannel ssc = isNative ? ChronicleServerSocketFactory.openNative() : ChronicleServerSocketFactory.open();
        ssc.socket().setReuseAddress(true);
        ssc.bind(address);
        assert (ssc.isOpen());
        DESC_TO_SERVER_SOCKET_CHANNEL_MAP.put(description, ssc);
        TCPRegistry.lookupTable().put(description, (InetSocketAddress)ssc.socket().getLocalSocketAddress());
    }

    public static ChronicleServerSocketChannel acquireServerSocketChannel(@NotNull String description) throws IOException {
        ChronicleServerSocketChannel ssc = DESC_TO_SERVER_SOCKET_CHANNEL_MAP.get(description);
        if (ssc != null && ssc.isOpen()) {
            return ssc;
        }
        InetSocketAddress address = TCPRegistry.lookup(description);
        ssc = ChronicleServerSocketFactory.open();
        ssc.socket().setReuseAddress(true);
        try {
            ssc.bind(address);
        }
        catch (Exception e) {
            Jvm.warn().on(TCPRegistry.class, "Error when attempting to bind to address " + address, (Throwable)e);
            throw Jvm.rethrow((Throwable)e);
        }
        DESC_TO_SERVER_SOCKET_CHANNEL_MAP.put(description, ssc);
        return ssc;
    }

    public static InetSocketAddress lookup(@NotNull String description) {
        InetSocketAddress address = TCPRegistry.lookupTable().lookup(description);
        if (address != null) {
            return address;
        }
        String property = System.getProperty(description);
        if (property != null) {
            @NotNull String[] parts = property.split(":", 2);
            if (parts[0].equals("null")) {
                throw new IllegalArgumentException("Invalid hostname \"null\"");
            }
            if (parts.length == 1) {
                throw new IllegalArgumentException("Alias " + description + " as " + property + " malformed, expected hostname:port");
            }
            try {
                int port = Integer.parseInt(parts[1]);
                address = TCPRegistry.addInetSocketAddress(description, parts[0], port);
                return address;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Alias " + description + " as " + property + " malformed, expected hostname:port with port as a number");
            }
        }
        @NotNull String[] parts = description.split(":", 2);
        if (parts.length == 1) {
            throw new IllegalArgumentException("Description " + description + " malformed, expected hostname:port");
        }
        try {
            int port = Integer.parseInt(parts[1]);
            address = TCPRegistry.addInetSocketAddress(description, parts[0], port);
            return address;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Description " + description + " malformed, expected hostname:port with port as a number");
        }
    }

    @NotNull
    private static InetSocketAddress addInetSocketAddress(String description, @NotNull String hostname, int port) {
        if (port <= 0 || port >= 65536) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
        @NotNull InetSocketAddress address = TCPRegistry.createInetSocketAddress(hostname, port);
        TCPRegistry.lookupTable().put(description, address);
        return address;
    }

    @NotNull
    private static InetSocketAddress createInetSocketAddress(@NotNull String hostname, int port) {
        return hostname.isEmpty() || hostname.equals("*") ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
    }

    public static ChronicleSocketChannel createSocketChannel(@NotNull String description) throws IOException {
        return TCPRegistry.createSocketChannel(false, description);
    }

    public static ChronicleSocketChannel createSocketChannel(boolean isNative, @NotNull String description) throws IOException {
        return ChronicleSocketChannelFactory.wrap(isNative, TCPRegistry.lookup(description));
    }

    public static void dumpAllSocketChannels() {
        TCPRegistry.lookupTable().forEach((s, inetSocketAddress) -> System.out.println(s + ": " + inetSocketAddress.toString()));
    }

    public static void assertAllServersStopped(long timeout, TimeUnit unit) {
        long endtime = System.currentTimeMillis() + unit.toMillis(timeout);
        @NotNull ArrayList<ChronicleServerSocketChannel> closed = new ArrayList<ChronicleServerSocketChannel>();
        for (Map.Entry<String, ChronicleServerSocketChannel> entry : DESC_TO_SERVER_SOCKET_CHANNEL_MAP.entrySet()) {
            if (!entry.getValue().isOpen()) continue;
            closed.add(entry.getValue());
        }
        TCPRegistry.lookupTable().clear();
        DESC_TO_SERVER_SOCKET_CHANNEL_MAP.clear();
        if (closed.isEmpty()) {
            return;
        }
        do {
            Jvm.pause((long)1L);
            Iterator iterator = closed.iterator();
            while (iterator.hasNext()) {
                ChronicleServerSocketChannel next = (ChronicleServerSocketChannel)iterator.next();
                if (!next.isOpen()) {
                    iterator.remove();
                }
                if (!closed.isEmpty()) continue;
                return;
            }
        } while (System.currentTimeMillis() < endtime);
        Closeable.closeQuietly(closed);
        Jvm.pause((long)500L);
        StringBuilder e = new StringBuilder();
        String sep = "";
        for (ChronicleServerSocketChannel serverSocketChannel : closed) {
            if (!serverSocketChannel.isOpen()) continue;
            try {
                SocketAddress address = serverSocketChannel.getLocalAddress();
                e.append(sep).append(address);
                sep = ",";
            }
            catch (ClosedChannelException address) {
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        if (e.length() > 0) {
            throw new AssertionError((Object)("Had to stop " + e));
        }
    }

    private static synchronized HostnamePortLookupTable lookupTable() {
        if (lookupTable == null) {
            TCPRegistry.createNewLookupTable();
        }
        return lookupTable;
    }

    private static void createNewLookupTable() {
        try {
            Class<?> lookupTableClass = Class.forName(System.getProperty(TCP_REGISTRY_LOOKUP_TABLE_IMPLEMENTATION_PROPERTY, ProcessLocalHostnamePortLookupTable.class.getName()));
            lookupTable = (HostnamePortLookupTable)lookupTableClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating lookup table", ex);
        }
    }

    static {
        $VALUES = new TCPRegistry[0];
        DESC_TO_SERVER_SOCKET_CHANNEL_MAP = new ConcurrentSkipListMap<String, ChronicleServerSocketChannel>();
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{NetworkStats.class, AlwaysStartOnPrimaryConnectionStrategy.class});
    }
}

